/*
 * Printer class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;

/**
 * ʏo͂̂߂̃\bh`C^[tFCXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
 */
public interface Printer
{
  /**
   * 𒆒f邩ǂݒ肷B
   *
   * @param  isStopped 𒆒fꍇ<tt>true</tt>ݒ肷B
   */
  void setStopped(boolean isStopped);

  /**
   * 𒆒f邩ǂ𔻒肷B
   *
   * @return  𒆒fꍇ<tt>true</tt>ԂB
   */
  boolean isStopped();

  /**
   * w肳ꂽO̎P[X茋ʃIuWFNg쐬B
   * <br>
   * ̃NX̏o͕@ɍP[X茋ʃIuWFNg쐬B
   * Ⴆ΁A̍ۂƍŏI肾o͂̂ł΁A茋ʃIuWFNg
   * PPێKv͂ȂȀWvlێĂ΂悢B
   * AGUIʂɂꂼ̔茋ʃIuWFNg̓eo͂đ삷
   * 悤ȏꍇ́A茋ʂ̊Kw֌Wێ悤Ȕ茋ʃIuWFNg
   * KvƂȂB
   *
   * @param  name P[XB
   * @param  parent e̎P[X茋ʃIuWFNgB
   * @return P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  CaseResult createCaseResult(String name, CaseResult parent);

  /**
   * Ŝ̊JnɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void testStarted(CaseResult root);

  /**
   * Ŝ̏IɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void testEnded(CaseResult root);

  /**
   * P[X̊JnɌĂяo郁\bhB
   *
   * @param  current Jn鎎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void caseStarted(CaseResult current);

  /**
   * P[X̏IɌĂяo郁\bhB
   *
   * @param  current I鎎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void caseEnded(CaseResult current);

  /**
   * 肪sꂽɌĂяo郁\bhB
   *
   * @param  check 茋ʃIuWFNgB
   * @param  current ݂̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void checkOccured(CheckResult check, CaseResult current);

  /**
   * bZ[W̓o^ꍇɌĂяo郁\bhB
   *
   * @param  msg o^郁bZ[WB
   * @param  current ݂̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void messageNoted(String msg, CaseResult current);

  /**
   * ̒fɌĂяo郁\bhB
   *
   * @param  current ݂̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void testStopped(CaseResult current);
}
