/*
 * CoverageTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import ts.tester.coverage.Coverage.MethodKey;
import ts.tester.util.ObjectSerializer;
import java.util.*;
import java.io.*;
import com.sun.jdi.*;
import com.sun.jdi.event.*;

/**
 * <code>Coverage</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:48 $
 */
public class CoverageTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(CoverageTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner class -- */

  class CoverageEx extends Coverage
  {
    CoverageEx(Class<?> execClass)
    { super(execClass); }
    CoverageEx(Class<?> execClass, String cmdArgs)
    { super(execClass, cmdArgs); }
    @Override protected void entryLine(Location location)
    {}
    @Override protected void passLine(Location location)
    {}
    @Override protected void entryClass(ReferenceType refType)
    {}
    @Override protected void entryMethod(Method method)
    {}
    @Override protected void exitMethod(Method method)
    {}
    @Override public Collection<String> allSourcePaths()
    { return  null; }
    @Override public Collection<String> allClassNames()
    { return  null; }
    @Override public Collection<MethodKey> methodKeysOf(String className)
    { return  null; }
  }

  /* -- test case -- */

  public void constructor_execClass()
  {
    MSG("ʏ̑");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    NOTNULL(coverage);
  }

  public void constructor_execClass_1()
  {
    MSG("Ƀkw肵ꍇ");
    try {
      Coverage coverage = new CoverageEx(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void constructor_execClass_commandArgs()
  {
    MSG("ʏ̏ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class, "-a bbb");
    NOTNULL(coverage);
  }

  public void constructor_execClass_commandArgs_1()
  {
    MSG("k̏ꍇ");

    try {
      Coverage coverage = new CoverageEx(CoverageTest.class, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      Coverage coverage = new CoverageEx(null, "-a bbb");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_execClass_commandArgs_2()
  {
    MSG("main֐ȂNXw肵ꍇ");

    try {
      Coverage coverage = new CoverageEx(String.class, "-A BBB");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setPrinter()
  {
    MSG("ʏ̑̏ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    HtmlPrinter printer = new HtmlPrinter("");
    coverage.setPrinter(printer);

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("printer_", printer);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("classPath_");
    oi.ignore("vmOptions_");
    oi.ignore("targetClassPatternLst_");
    oi.ignore("exclusionClassPatternLst_");
    oi.ignore("classFilterType_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");

    oi.inspect(coverage);
  }

  public void setPrinter_1()
  {
    MSG("k̏ꍇ");

    try {
      Coverage coverage = new CoverageEx(CoverageTest.class);
      coverage.setPrinter(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setClassFilterType()
  {
    MSG("ʏ̑̏ꍇ");

    Coverage coverage = new CoverageEx(CaseResultTest.class);
    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("classFilterType_", Coverage.FilterType.ALLOW_DENY_ALLOW);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CaseResultTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("printer_");
    oi.ignore("classPath_");
    oi.ignore("vmOptions_");
    oi.ignore("targetClassPatternLst_");
    oi.ignore("exclusionClassPatternLst_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    coverage.setClassFilterType(Coverage.FilterType.DENY_ALLOW_DENY);
    oi.expect("classFilterType_", Coverage.FilterType.DENY_ALLOW_DENY);
    oi.inspect(coverage);
  }

  public void setClassFilterType_1()
  {
    MSG("k̏ꍇ");

    Coverage coverage = new CoverageEx(CaseResultTest.class);
    try {
      coverage.setClassFilterType(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void addClassPath()
  {
    MSG("ʏ̑̊mF");

    Coverage coverage = new CoverageEx(CaseResultTest.class);

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("classPath_", new StringBuffer());
    oi.expect("classFilterType_", Coverage.FilterType.ALLOW_DENY_ALLOW);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CaseResultTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("printer_");
    oi.ignore("vmOptions_");
    oi.ignore("targetClassPatternLst_");
    oi.ignore("exclusionClassPatternLst_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    coverage.addClassPath("aaa");
    oi.expect("classPath_", new StringBuffer("aaa"));
    oi.inspect(coverage);

    coverage.addClassPath("bbb");
    oi.expect("classPath_", new StringBuffer("aaa;bbb"));
    oi.inspect(coverage);

    coverage.addClassPath("ccc;ddd");
    oi.expect("classPath_", new StringBuffer("aaa;bbb;ccc;ddd"));
    oi.inspect(coverage);
  }

  public void addClassPath_1()
  {
    MSG("Ƀkw肵ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    try {
      coverage.addClassPath(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addTargetClassPattern()
  {
    MSG("ʏ̑̊mF");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    List<String> lst = new ArrayList<String>(3);

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("targetClassPatternLst_", lst);
    oi.expect("classPath_", new StringBuffer());
    oi.expect("classFilterType_", Coverage.FilterType.ALLOW_DENY_ALLOW);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("printer_");
    oi.ignore("vmOptions_");
    oi.ignore("exclusionClassPatternLst_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    coverage.addTargetClassPattern("java.*");
    lst.add("java.*");
    oi.expect("targetClassPatternLst_", lst);
    oi.inspect(coverage);

    coverage.addTargetClassPattern("com.sun.*");
    lst.add("com.sun.*");
    oi.expect("targetClassPatternLst_", lst);
    oi.inspect(coverage);
  }

  public void addTargetClassPattern_1()
  {
    MSG("Ƀkw肳ꂽꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    try {
      coverage.addTargetClassPattern(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addExclusionClassPattern()
  {
    MSG("ʏ̑̊mF");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    List<String> lst = new ArrayList<String>(3);
    List<String> lst0 = new ArrayList<String>(0);

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("exclusionClassPatternLst_", lst);
    oi.expect("targetClassPatternLst_", lst0);
    oi.expect("classPath_", new StringBuffer());
    oi.expect("classFilterType_", Coverage.FilterType.ALLOW_DENY_ALLOW);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("printer_");
    oi.ignore("vmOptions_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    coverage.addExclusionClassPattern("java.*");
    lst.add("java.*");
    oi.expect("exclusionClassPatternLst_", lst);
    oi.inspect(coverage);

    coverage.addExclusionClassPattern("com.sun.*");
    lst.add("com.sun.*");
    oi.expect("exclusionClassPatternLst_", lst);
    oi.inspect(coverage);
  }

  public void addExclusionClassPattern_1()
  {
    MSG("Ƀkw肳ꂽꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    try {
      coverage.addExclusionClassPattern(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void setVMOptions()
  {
    MSG("ʏ̏ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    List<String> lst0 = new ArrayList<String>(0);

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("vmOptions_", "");
    oi.expect("exclusionClassPatternLst_", lst0);
    oi.expect("targetClassPatternLst_", lst0);
    oi.expect("classPath_", new StringBuffer());
    oi.expect("classFilterType_", Coverage.FilterType.ALLOW_DENY_ALLOW);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("printer_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    coverage.setVMOptions("-Xms:256m");
    oi.expect("vmOptions_", "-Xms:256m");
    oi.inspect(coverage);
  }

  public void setVMOptions_1()
  {
    MSG("k̏ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    try {
      coverage.setVMOptions(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void hasMainFunction()
  {
    MSG("ʏ̑");

    Coverage coverage = new CoverageEx(CoverageTest.class);

    ObjectInspector oi = new ObjectInspector(this);
    try {
      EQUAL(oi.invokeMethod(coverage, "hasMainFunction", Class.class,
        CoverageTest.class), Boolean.TRUE);
      EQUAL(oi.invokeMethod(coverage, "hasMainFunction", Class.class,
        Coverage.class), Boolean.FALSE);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void hasMainFunction_1()
  {
    MSG("k̏ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);

    ObjectInspector oi = new ObjectInspector(this);
    try {
      EQUAL(oi.invokeMethod(coverage, "hasMainFunction", Class.class, null),
        Boolean.FALSE);
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setExecClass()
  {
    MSG("ʏ̑");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    List<String> lst0 = new ArrayList<String>(0);
    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.expect("vmOptions_", "");
    oi.expect("exclusionClassPatternLst_", lst0);
    oi.expect("targetClassPatternLst_", lst0);
    oi.expect("classPath_", new StringBuffer());
    oi.expect("classFilterType_", Coverage.FilterType.ALLOW_DENY_ALLOW);
    oi.expect("sourceBasePath_", null);
    oi.ignore("printer_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);


    coverage.setExecClass(ResultTest.class, "aaa bbbb");
    oi.expect("execClass_", ResultTest.class);
    oi.expect("commandArgs_", "aaa bbbb");
    oi.inspect(coverage);
  }

  public void setExecClass_1()
  {
    MSG("k̏ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    try {
      coverage.setExecClass(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    try {
      coverage.setExecClass(null, "");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    try {
      coverage.setExecClass(ResultTest.class, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  static class MyTest {
    public void main(String[] args) {}
  }

  public void setExecClass_2()
  {
    MSG("w肳ꂽNXmain֐Ȃꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    try {
      coverage.setExecClass(Coverage.class, "");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    coverage = new CoverageEx(CoverageTest.class);
    try {
      coverage.setExecClass(MyTest.class, "");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

  }

  public void setSourceBasePath()
  {
    MSG("ʏ̑̏ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("classPath_");
    oi.ignore("vmOptions_");
    oi.ignore("targetClassPatternLst_");
    oi.ignore("exclusionClassPatternLst_");
    oi.ignore("classFilterType_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.ignore("printer_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    coverage.setSourceBasePath("aaa/bbb");
    oi.expect("sourceBasePath_", "aaa/bbb");
    oi.inspect(coverage);
  }

  public void setSourceBasePath_1()
  {
    MSG("k̏ꍇ");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    
    try {
      coverage.setSourceBasePath(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setOutputStream()
  {
    MSG("ʏ̑̏ꍇ");
    Coverage coverage = new CoverageEx(CoverageTest.class);

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("outputStream_", System.out);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("classPath_");
    oi.ignore("vmOptions_");
    oi.ignore("targetClassPatternLst_");
    oi.ignore("exclusionClassPatternLst_");
    oi.ignore("classFilterType_");
    oi.ignore("errorStream_");
    oi.ignore("printer_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    coverage.setOutputStream(baos);
    oi.expect("outputStream_", baos);
    oi.inspect(coverage);
  }

  public void setOutputStream_1()
  {
    MSG("k̏ꍇ");
    Coverage coverage = new CoverageEx(CoverageTest.class);

    try {
      coverage.setOutputStream(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setErrorStream()
  {
    MSG("ʏ̑̏ꍇ");
    Coverage coverage = new CoverageEx(CoverageTest.class);

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("errorStream_", System.err);
    oi.expect("outputStream_", System.out);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("classPath_");
    oi.ignore("vmOptions_");
    oi.ignore("targetClassPatternLst_");
    oi.ignore("exclusionClassPatternLst_");
    oi.ignore("classFilterType_");
    oi.ignore("printer_");
    oi.ignore("eventOfEntryMethodEnabled_");
    oi.ignore("eventOfExitMethodEnabled_");
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    coverage.setErrorStream(baos);
    oi.expect("errorStream_", baos);
    oi.inspect(coverage);
  }

  public void setErrorStream_1()
  {
    MSG("k̏ꍇ");
    Coverage coverage = new CoverageEx(CoverageTest.class);

    try {
      coverage.setErrorStream(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void launchVM()
  {
    MSG("ʏ̑");
    Coverage coverage = new CoverageEx(CoverageTest.class);
    ObjectInspector oi = new ObjectInspector(this);
    try {
      VirtualMachine vm = (VirtualMachine) 
        oi.invokeMethod(coverage, "launchVM");
      NOTNULL(vm);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void launchVM_1()
  {
    MSG("R}hCw肳ꂽꍇ");
    Coverage coverage = new CoverageEx(CoverageTest.class);
    coverage.setExecClass(CoverageTest.class, "class=ts.tester.TesterTest");
    ObjectInspector oi = new ObjectInspector(this);
    try {
      VirtualMachine vm = (VirtualMachine) 
        oi.invokeMethod(coverage, "launchVM");
      NOTNULL(vm);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void enableEventRequest()
  {
    MSG("NXtB^^CvALLOW_DENY_ALLOW");
    Coverage coverage = new CoverageEx(CoverageTest.class);
    ObjectInspector oi = new ObjectInspector(this);
    try {
      VirtualMachine vm = (VirtualMachine) 
        oi.invokeMethod(coverage, "launchVM");
      oi.invokeMethod(coverage, "enableEventRequest", VirtualMachine.class, vm);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void enableEventRequest_1()
  {
    MSG("NXtB^^CvDENY_ALLOW_DENY");
    Coverage coverage = new CoverageEx(CoverageTest.class);
    coverage.setClassFilterType(Coverage.FilterType.DENY_ALLOW_DENY);
    coverage.addTargetClassPattern("ts.*");
    coverage.addExclusionClassPattern("java.*");
    ObjectInspector oi = new ObjectInspector(this);
    try {
      VirtualMachine vm = (VirtualMachine) 
        oi.invokeMethod(coverage, "launchVM");
      oi.invokeMethod(coverage, "enableEventRequest", VirtualMachine.class, vm);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void prepareVM()
  {
    MSG("ʏ̑");
    Coverage coverage = new CoverageEx(CoverageTest.class);
    ObjectInspector oi = new ObjectInspector(this);
    try {
      VirtualMachine vm;
      vm = (VirtualMachine) oi.invokeMethod(coverage, "launchVM");
      Object ret;
      ret = oi.invokeMethod(coverage, "prepareVM", VirtualMachine.class, vm);
      EQUAL(ret, Void.TYPE);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void z_handleEvent_entryLine() throws Exception
  {
    MSG("entryLine\bȟĂяoo");

    final Map<String, Set<Integer>> sourceMap_;
    sourceMap_ = new HashMap<String, Set<Integer>>();

    Coverage coverage = new CoverageEx(ResultTest.class) {
      @Override protected void entryLine(Location location)
      {
        try {
          Set<Integer> set = sourceMap_.get(location.sourcePath());
          if (set == null) {
            set = new HashSet<Integer>();
            sourceMap_.put(location.sourcePath(), set);
          }
          set.add(location.lineNumber());
        }
        catch (Exception e) {}
      }
    };
    coverage.addExclusionClassPattern("java.*");
    coverage.addExclusionClassPattern("javax.*");
    coverage.addExclusionClassPattern("com.sun.*");
    coverage.addExclusionClassPattern("sun.*");
    coverage.addExclusionClassPattern("ts.tester.*");
    coverage.addTargetClassPattern("ts.tester.coverage.*");
    coverage.addClassPath("test");

    try {
      coverage.run();
    } catch (Exception e) {
      NG(e);
    }

    for (Map.Entry<String, Set<Integer>> src : sourceMap_.entrySet()) {
      File srcFile = new File("src\\" + src.getKey());
      Set lineSet = src.getValue();
      System.out.println("COVERAGE>>>" + srcFile.getName());
      BufferedReader br = new BufferedReader(new FileReader(srcFile));
      for (int i=1; ; i++) {
        String line = br.readLine();
        if (line == null) {
          break;
        }
        System.out.print("(" + (i) + ") ");
        System.out.print(line);
        if (lineSet.contains(i)) {
          System.out.print("[ENTRYED]");
        }
        System.out.println();
      }
    }
    OK();
  }

  public void z_handleEvent_passLine() throws Exception
  {
    MSG("passLine\bȟĂяoo");

    final Map<String, Set<Integer>> sourceMap_;
    sourceMap_ = new HashMap<String, Set<Integer>>();

    Coverage coverage = new CoverageEx(CaseResultTest.class) {
      @Override protected void passLine(Location location)
      {
        try {
          Set<Integer> set = sourceMap_.get(location.sourcePath());
          if (set == null) {
            set = new HashSet<Integer>();
            sourceMap_.put(location.sourcePath(), set);
          }
          set.add(location.lineNumber());
        }
        catch (Exception e) {}
      }
    };
    coverage.addExclusionClassPattern("java.*");
    coverage.addExclusionClassPattern("com.sun.*");
    coverage.addExclusionClassPattern("sun.*");
    coverage.addExclusionClassPattern("ts.tester.*");
    coverage.addTargetClassPattern("ts.tester.coverage.CaseResultTest*");
    coverage.addClassPath("test");

    ObjectInspector oi = new ObjectInspector(this);
    try {
      coverage.run();
    } catch (Exception e) {
      NG(e);
    }

    for (Map.Entry<String, Set<Integer>> src : sourceMap_.entrySet()) {
      File srcFile = new File("src\\" + src.getKey());
      Set lineSet = src.getValue();
      System.out.println("COVERAGE>>>" + srcFile.getName());
      BufferedReader br = new BufferedReader(new FileReader(srcFile));
      for (int i=1; ; i++) {
        String line = br.readLine();
        if (line == null) {
          break;
        }
        System.out.print("(" + (i) + ") ");
        System.out.print(line);
        if (lineSet.contains(i)) {
          System.out.print("[PASSED]");
        }
        System.out.println();
      }
    }
    OK();
  }

  public void z_handleEvent_entryAndExitMethod() throws Exception
  {
    MSG("entryMethod,exitMethod\bȟĂяoo");

    final Map<String, Set<Integer>> sourceMap_;
    sourceMap_ = new HashMap<String, Set<Integer>>();

    Coverage coverage = new CoverageEx(ResultTest.class) {
      @Override protected void entryMethod(Method method) {
        System.out.println("[ENTRY] " + method.toString());
      }
      @Override protected void exitMethod(Method method) {
        System.out.println("[EXIT ] " + method.toString());
      }
    };
    coverage.addExclusionClassPattern("java.*");
    coverage.addExclusionClassPattern("com.sun.*");
    coverage.addExclusionClassPattern("sun.*");
    coverage.addExclusionClassPattern("ts.*");
    coverage.addTargetClassPattern("ts.tester.function.FunctionTester*");
    coverage.addClassPath("test");

    ObjectInspector oi = new ObjectInspector(this);
    try {
      coverage.run();
    } catch (Exception e) {
      NG(e);
    }
    OK();
  }

  public void MethodKey_constructor()
  {
    MSG("ʏ̑̏ꍇ");

    MethodKey mk = new MethodKey("aaa", "bbb", "ccc,ddd");
    EQUAL(mk.getClassName(), "aaa");
    EQUAL(mk.getMethodName(), "bbb");
    EQUAL(mk.getArgTypeNames(), "ccc,ddd");
  }

  public void MethodKey_constructor_1()
  {
    MSG("k̏ꍇ");
    try {
      MethodKey mk = new MethodKey(null, "bbb", "ccc,ddd");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodKey mk = new MethodKey("aaa", null, "ccc,ddd");
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      MethodKey mk = new MethodKey("aaa", "bbb", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void MethodKey_compareTo()
  {
    MSG("ʏ̑̏ꍇ");

    MethodKey mk0 = new MethodKey("aaa", "bbb", "ccc,ddd");
    MethodKey mk1 = new MethodKey("aaa", "bbb", "ccc,ddd");
    MethodKey mk2 = new MethodKey("aaa", "bbb", "ccc");
    MethodKey mk3 = new MethodKey("aaa", "xxx", "ccc,ddd");
    MethodKey mk4 = new MethodKey("xxx", "bbb", "ccc,ddd");

    TRUE(mk0.compareTo(mk0) == 0);
    TRUE(mk0.compareTo(mk1) == 0);
    TRUE(mk1.compareTo(mk0) == 0);
    TRUE(mk0.compareTo(mk2) > 0);
    TRUE(mk2.compareTo(mk0) < 0);
    TRUE(mk0.compareTo(mk3) < 0);
    TRUE(mk3.compareTo(mk0) > 0);
    TRUE(mk0.compareTo(mk4) < 0);
    TRUE(mk4.compareTo(mk0) > 0);
  }

  public void MethodKey_compareTo_1()
  {
    MSG("Ƀkw肵ꍇ");

    MethodKey mk0 = new MethodKey("aaa", "bbb", "ccc");  
    try {
      mk0.compareTo(null);
      NG();
    } catch (NullPointerException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void MethodKey_compareTo_2()
  {
    MSG("MethodKeyIuWFNgȊOw肵ꍇ");

    MethodKey mk0 = new MethodKey("aaa", "bbb", "ccc");
    try {
      mk0.compareTo(new Integer(1));
      NG();
    } catch (ClassCastException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void MethodKey_serialize()
  {
    MSG("VACY̎");

    MethodKey mk = new MethodKey("ts.tester.Tester", "run", "Class, String");

    try {
      byte[] bs = ObjectSerializer.serializeToByteArray(mk);

      Object obj = ObjectSerializer.deserialize(bs);

      TRUE(obj instanceof MethodKey);

      MethodKey mk1 = (MethodKey) obj;
      EQUAL(mk1.getClassName(), "ts.tester.Tester");
      EQUAL(mk1.getMethodName(), "run");
      EQUAL(mk1.getArgTypeNames(), "Class, String");
    } catch (Exception e) {
      NG(e);
    }
  }

/*
  public void setClassFilterType_AllowDenyAllow()
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);
    coverage.setClassFilterType(Coverage.FilterType.ALLOW_DENY_ALLOW);
    try {
      coverage.addClassPath("this");
      coverage.run();
      OK();
    } catch (Exception e) {
      NG(e);
    }
    for (String className : coverage.allClassNames()) {
      OK(className);
    }
  }

  public void setClassFilterType_AllowDenyAllow_1()
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);
    coverage.setClassFilterType(Coverage.FilterType.ALLOW_DENY_ALLOW);
    coverage.addExclusionClassPattern("java.*");
    try {
      coverage.run();
      OK();
    } catch (Exception e) {
      NG(e);
    }
    for (String className : coverage.allClassNames()) {
      OK(className);
    }
  }

  public void setClassFilterType_AllowDenyAllow_2()
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);
    coverage.setClassFilterType(Coverage.FilterType.ALLOW_DENY_ALLOW);
    coverage.addExclusionClassPattern("java.*");
    coverage.addTargetClassPattern("java.net.*");
    try {
      coverage.run();
      OK();
    } catch (Exception e) {
      NG(e);
    }
    for (String className : coverage.allClassNames()) {
      OK(className);
    }
  }

  public void setClassFilterType_DenyAllowDeny()
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);
    coverage.setClassFilterType(Coverage.FilterType.DENY_ALLOW_DENY);
    try {
      coverage.addClassPath("this");
      coverage.run();
      OK();
    } catch (Exception e) {
      NG(e);
    }
    for (String className : coverage.allClassNames()) {
      OK(className);
    }
  }

  public void setClassFilterType_DenyAllowDeny_1()
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);
    coverage.setClassFilterType(Coverage.FilterType.DENY_ALLOW_DENY);
    coverage.addTargetClassPattern("java.util.*");
    try {
      coverage.addClassPath("this");
      coverage.run();
      OK();
    } catch (Exception e) {
      NG(e);
    }
    for (String className : coverage.allClassNames()) {
      OK(className);
    }
  }

  public void setClassFilterType_DenyAllowDeny_2()
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);
    coverage.setClassFilterType(Coverage.FilterType.DENY_ALLOW_DENY);
    coverage.addTargetClassPattern("java.util.*");
    coverage.addExclusionClassPattern("java.util.zip.Zip*");
    try {
      coverage.addClassPath("this");
      coverage.run();
      OK();
    } catch (Exception e) {
      NG(e);
    }
    for (String className : coverage.allClassNames()) {
      OK(className);
    }
  }
  */

  public void setEventOfEntryAndExitMethodEnabled()
  {
    MSG("\bho^EICxg̗LtOݒ肷B");

    Coverage coverage = new CoverageEx(CoverageTest.class);
    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("sourceBasePath_", null);
    oi.expect("execClass_", CoverageTest.class);
    oi.expect("commandArgs_", "");
    oi.ignore("printer_");
    oi.ignore("classPath_");
    oi.ignore("vmOptions_");
    oi.ignore("targetClassPatternLst_");
    oi.ignore("exclusionClassPatternLst_");
    oi.ignore("classFilterType_");
    oi.ignore("outputStream_");
    oi.ignore("errorStream_");
    oi.expect("eventOfEntryMethodEnabled_", true);
    oi.expect("eventOfExitMethodEnabled_", true);
    oi.ignore("objectWriter_");
    oi.ignore("DEFAULT_OBJECT_WRITER");
    oi.inspect(coverage);

    coverage.setEventOfEntryMethodEnabled(false);
    coverage.setEventOfExitMethodEnabled(false);
    oi.expect("eventOfEntryMethodEnabled_", false);
    oi.expect("eventOfExitMethodEnabled_", false);
    oi.inspect(coverage);
  }
}
