/*
 * CoverageResult class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import java.util.Map;
import java.util.TreeMap;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Collections;

/**
 * JobWv̌ʂi[NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public abstract class Result<K> 
{
  /**
   * ftHgRXgN^B
   */
  public Result()
  {}

  /**
   * ʉ߉񐔂i[錋ʃIuWFNgǍʃL[ɑΉÂēo^B
   * <br>
   * łʃL[Ƃ́AႦ΍sJobWvꍇȂ΍sԍ
   * ȂǂłB
   * <br>
   * ̃L[ɑΉ錋ʃIuWFNgɓo^Ăꍇ͉ȂB
   *
   * @param  resultKey ʃL[B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public abstract void addResult(K resultKey);

  /**
   * ̃IuWFNgi[ĂSʐ擾B
   *
   * @return SʐB
   */
  public abstract int countAllResults();
 
  /**
   * ̃IuWFNgi[Ăʉߍς݂̌ʐ擾B
   *
   * @return ʉߍς݂̌ʐB
   */
  public abstract int countPassedResults();

  /**
   * ʉߗ擾B
   * <br>
   * ʉߗ́A<tt>0.0f</tt>`<tt>1.0f</tt>̒lƂB
   *
   * @return ʉߗB
   */
  public float passedRatio()
  {
    int all = countAllResults();
    return (all > 0) ? ((float) countPassedResults() / (float) all) : 0.0f;
  }

  /**
   * ̃L[ɑΉP[X̒ʉߐ1ZB
   * <br>
   * ̃L[ɑΉP[X݂Ȃꍇ́AȂB
   *
   * @param  resultKey P[X̃L[B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public abstract void incrementPassCountOfResult(K resultKey);

  /**
   * ̃L[ɑΉP[Xv̑ΏۂǂmFB
   * <br>
   * v̑Ώۂłꍇ́A<tt>true</tt>ԂB
   *
   * @param  resultKey P[X̃L[B
   * @return ̃L[ɑΉP[Xv̑Ώۂłꍇ<tt>true</tt>B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public abstract boolean containsKeyOfResult(K resultKey);

  /**
   * ̃L[ɑΉP[X̒ʉߐ擾B
   * <br>
   * ̃L[ɑΉP[X݂Ȃꍇ́A[ԂB
   *
   * @param  resultKey P[X̃L[B
   * @return ̃L[ɑΉP[X̒ʉߐB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public abstract int getPassCountOfResult(K resultKey);

  /**
   * SẴP[X̃L[i[񋓃IuWFNgԂB
   *
   * @return SẴP[X̃L[i[񋓃IuWFNgB
   */
  public abstract Enumeration<K> enumAllResultKeys();

  /**
   * ʉ߂P[X̃L[i[񋓃IuWFNgԂB
   *
   * @return ʉ߂P[X̃L[i[񋓃IuWFNgB
   */
  public abstract Enumeration<K> enumPassedResultKeys();

  /**
   * ʉ߂ĂȂP[X̃L[i[񋓃IuWFNgԂB
   *
   * @return ʉ߂ĂȂP[X̃L[i[񋓃IuWFNgB
   */
  public abstract Enumeration<K> enumNotPassedResultKeys();
}

