/*
 * CaseResultTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.io.*;
import java.util.*;

/**
 * <code>CaseResult</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class CaseResultTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(CaseResultTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner class -- */

  class CaseResultEx extends CaseResult {
    public CaseResultEx(String name, CaseResult parent) {
      super(name, parent);
    }
    @Override public int count(ResultType  type) {
      return 111;
    }
    @Override public void addChildResult(Result result) {
    }
  }

  /* -- test case -- */

  public void constants()
  {
    EQUAL(CaseResult.NULL.getName(), "");
    EQUAL(CaseResult.NULL.count(ResultType.NG), 0);
    EQUAL(CaseResult.NULL.count(ResultType.KnownBug), 0);
    EQUAL(CaseResult.NULL.count(ResultType.Empty), 0);
    EQUAL(CaseResult.NULL.count(ResultType.Incomplete), 0);

    EQUAL(CaseResult.NULL.getParentCaseResult(),
          CaseResult.NULL);
  }

  public void constructor()
  {
    CaseResult c = new CaseResultEx("aaa", CaseResult.NULL);
    NOTNULL(c);
    EQUAL(c.getName(), "aaa");
    EQUAL(c.count(ResultType.NG), 111);
    EQUAL(c.count(ResultType.KnownBug), 111);
    EQUAL(c.count(ResultType.Empty), 111);
    EQUAL(c.count(ResultType.Incomplete), 111);
    EQUAL(c.getParentCaseResult(), CaseResult.NULL);
  }

  public void addMessage()
  {
    CaseResult c = new CaseResultEx("aaa", CaseResult.NULL);
    EQUAL(c.getMessage(), "");
    c.addMessage("aaa");
    EQUAL(c.getMessage(), "aaa\r\n");
    c.addMessage("bbb");
    EQUAL(c.getMessage(), "aaa\r\nbbb\r\n");
  }
}
