/*
 * _PrintEventTypeTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.*;

/**
 * <code>_PrintEventType</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
public class _PrintEventTypeTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(_PrintEventTypeTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("_PrintEventTypeNX̋@\sB");
  }

  /* -- test case -- */

  public void _toString()
  {
    EQUAL(_PrintEventType.CREATE_CASE_RESULT.toString(),
      "CREATE_CASE_RESULT");
    EQUAL(_PrintEventType.TEST_STARTED.toString(), "TEST_STARTED");
    EQUAL(_PrintEventType.TEST_ENDED.toString(), "TEST_ENDED");
    EQUAL(_PrintEventType.CASE_STARTED.toString(), "CASE_STARTED");
    EQUAL(_PrintEventType.CASE_ENDED.toString(), "CASE_ENDED");
    EQUAL(_PrintEventType.CHECK_OCCURED.toString(), "CHECK_OCCURED");
    EQUAL(_PrintEventType.MESSAGE_NOTED.toString(), "MESSAGE_NOTED");
    EQUAL(_PrintEventType.TEST_STOPPED.toString(), "TEST_STOPPED");
    EQUAL(_PrintEventType.CHILD_RESULT_ADDED.toString(), "CHILD_RESULT_ADDED");
  }

  public void _ordinal()
  {
    EQUAL(_PrintEventType.CREATE_CASE_RESULT.ordinal(), 0);
    EQUAL(_PrintEventType.TEST_STARTED.ordinal(), 1);
    EQUAL(_PrintEventType.TEST_ENDED.ordinal(), 2);
    EQUAL(_PrintEventType.CASE_STARTED.ordinal(), 3);
    EQUAL(_PrintEventType.CASE_ENDED.ordinal(), 4);
    EQUAL(_PrintEventType.CHECK_OCCURED.ordinal(), 5);
    EQUAL(_PrintEventType.MESSAGE_NOTED.ordinal(), 6);
    EQUAL(_PrintEventType.TEST_STOPPED.ordinal(), 7);
    EQUAL(_PrintEventType.CHILD_RESULT_ADDED.ordinal(), 8);
  }

  public void _valueOf()
  {
    EQUAL(_PrintEventType.valueOf("CREATE_CASE_RESULT"),
          _PrintEventType.CREATE_CASE_RESULT);
    EQUAL(_PrintEventType.valueOf("TEST_STARTED"),
          _PrintEventType.TEST_STARTED);
    EQUAL(_PrintEventType.valueOf("TEST_ENDED"),
          _PrintEventType.TEST_ENDED);
    EQUAL(_PrintEventType.valueOf("CASE_STARTED"),
          _PrintEventType.CASE_STARTED);
    EQUAL(_PrintEventType.valueOf("CASE_ENDED"),
          _PrintEventType.CASE_ENDED);
    EQUAL(_PrintEventType.valueOf("CHECK_OCCURED"),
          _PrintEventType.CHECK_OCCURED);
    EQUAL(_PrintEventType.valueOf("MESSAGE_NOTED"),
          _PrintEventType.MESSAGE_NOTED);
    EQUAL(_PrintEventType.valueOf("TEST_STOPPED"),
          _PrintEventType.TEST_STOPPED);
    EQUAL(_PrintEventType.valueOf("CHILD_RESULT_ADDED"),
          _PrintEventType.CHILD_RESULT_ADDED);
  }

  public void _values()
  {
    _PrintEventType[] types = _PrintEventType.values();
    EQUAL(types.length, 9);
    EQUAL(types[0], _PrintEventType.CREATE_CASE_RESULT);
    EQUAL(types[1], _PrintEventType.TEST_STARTED);
    EQUAL(types[2], _PrintEventType.TEST_ENDED);
    EQUAL(types[3], _PrintEventType.CASE_STARTED);
    EQUAL(types[4], _PrintEventType.CASE_ENDED);
    EQUAL(types[5], _PrintEventType.CHECK_OCCURED);
    EQUAL(types[6], _PrintEventType.MESSAGE_NOTED);
    EQUAL(types[7], _PrintEventType.TEST_STOPPED);
    EQUAL(types[8], _PrintEventType.CHILD_RESULT_ADDED);
  }
}
