/*
 * HtmlPrinterBaseTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.*;
import ts.util.resource.*;
import java.io.*;
import java.util.*;
import java.text.*;

/**
 * <code>HtmlPrinterBase</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:51 $
 */
public class HtmlPrinterBaseTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(HtmlPrinterBaseTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("HtmlPrinterBaseNX̋@\sB");
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("萔l̊mF");

    EQUAL(HtmlPrinterBase.KEY_TOFILE,     "printer.html.toFile");
    EQUAL(HtmlPrinterBase.KEY_HEADER,     "printer.html.format.header");
    EQUAL(HtmlPrinterBase.KEY_PRECASES,   "printer.html.format.precases");
    EQUAL(HtmlPrinterBase.KEY_CASE,       "printer.html.format.case");
    EQUAL(HtmlPrinterBase.KEY_POSTCASES,  "printer.html.format.postcases");
    EQUAL(HtmlPrinterBase.KEY_FOOTER,     "printer.html.format.footer");

    EQUAL(HtmlPrinterBase.PREFIX_CHAR,    '%');
    EQUAL(HtmlPrinterBase.EOL,            System.getProperty("line.separator"));

    EQUAL(HtmlPrinterBase.FMT_TEST,       "test");
    EQUAL(HtmlPrinterBase.FMT_CASE,       "case");

    EQUAL(HtmlPrinterBase.OPT_NAME,       ".name");
    EQUAL(HtmlPrinterBase.OPT_TESTER,     ".tester");
    EQUAL(HtmlPrinterBase.OPT_DATE,       ".date");
    EQUAL(HtmlPrinterBase.OPT_JUDGE,      ".judge");
    EQUAL(HtmlPrinterBase.OPT_CHECK,      ".check");
    EQUAL(HtmlPrinterBase.OPT_GOOD,       ".good");
    EQUAL(HtmlPrinterBase.OPT_NOGOOD,     ".nogood");
    EQUAL(HtmlPrinterBase.OPT_KNOWNBUG,   ".knownbug");
    EQUAL(HtmlPrinterBase.OPT_EMPTY,      ".empty");
    EQUAL(HtmlPrinterBase.OPT_INCOMPLETE, ".incomplete");
    EQUAL(HtmlPrinterBase.OPT_CHILD,      ".child");
    EQUAL(HtmlPrinterBase.OPT_INDEX,      ".index");
    EQUAL(HtmlPrinterBase.OPT_MESSAGE,    ".message");
  }

  public void default_constructor()
  {
    MSG("ftHgERXgN^(protected)̊mFB");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    EQUAL(printer.getTesterName(), "");
    EQUAL(printer.isStopped(), false);
    EQUAL(printer.getResource(), Resource.EMPTY);
  }

  public void constructor_testerName()
  {
    MSG("{҂ɂƂAftHg̃\[Xt@C[hRXgN^̊mFB");

    String PATH = "ts/tester/function/print/html.properties";

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name");
    EQUAL(printer.getTesterName(), "My Name");
    EQUAL(printer.isStopped(), false);

    String path = ((AbstractResource)printer.getResource()).getPath();
    path = path.substring(path.length() - PATH.length());
    EQUAL(path, PATH);
  }

  public void constructor_testerName_0()
  {
    MSG("k̏ꍇB");

    try {
      HtmlPrinterBase printer = new HtmlPrinterBase(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_testerName_resource()
  {
    MSG("{҂ƃ\[XIuWFNgɂƂRXgN^̊mFB");

    String PATH = "classes/ts/tester/function/print/html.properties";
    PropertyResource res = null;
    try {
      res =  new PropertyResource(PATH);
    } catch (Exception e) {
      NG(e);
      return;
    }

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name", res);
    EQUAL(printer.getTesterName(), "My Name");
    EQUAL(printer.isStopped(), false);
    EQUAL(printer.getResource(), res);
  }

  public void constructor_testerName_resource_0()
  {
    MSG("k̏ꍇB");

    String PATH = "classes/ts/tester/function/print/html.properties";
    PropertyResource res = null;
    try {
      res =  new PropertyResource(PATH);
    } catch (Exception e) {
      NG(e);
      return;
    }

    try {
      HtmlPrinterBase printer = new HtmlPrinterBase(null, res);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      HtmlPrinterBase printer = new HtmlPrinterBase("aaa", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setTesterName()
  {
    MSG("{҂ݒ肷郁\bh̊mFB");

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name");
    EQUAL(printer.getTesterName(), "My Name");

    printer.setTesterName("My Tester");
    EQUAL(printer.getTesterName(), "My Tester");
  }

  public void setTesterName_0()
  {
    MSG("k̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase("aaa");
    try {
      printer.setTesterName(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createCaseResult()
  {
    MSG("P[X茋ʃIuWFNg̍쐬̊mFB");

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name");
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    EQUAL(c.getName(), "aaa");
    EQUAL(c.getClass().getName(),
      "ts.tester.function.print.HtmlPrinterBase$_CaseResult");
  }

  public void createCaseResult_0()
  {
    MSG("k̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name");
    try {
      printer.createCaseResult(null, CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.createCaseResult("aaa", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testEnded()
  {
    MSG("Ŝ̏IɌĂ΂郁\bh̊mFB");

    final StringBuffer buf = new StringBuffer();
    HtmlPrinterBase printer = new HtmlPrinterBase("My Name") {
      protected void outputHtmlFile(Map<String, Object> objMap) {
        buf.append("outputHtmlFile!!!");
      }
    };

    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.testEnded(c);
    EQUAL(buf.toString(), "outputHtmlFile!!!");

    CaseResult cc1 = printer.createCaseResult("bbb", c);
    c.addChildResult(cc1);
    CaseResult cc2 = printer.createCaseResult("bbb", c);
    c.addChildResult(cc2);

    printer.testEnded(c);
    EQUAL(buf.toString(), "outputHtmlFile!!!outputHtmlFile!!!");
  }

  public void testEnded_0()
  {
    MSG("k̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase("My name");
    try {
      printer.testEnded(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testEnded_1()
  {
    MSG("HtmlPrinterBase$_CaseResultIuWFNgłȂꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase("My name");
    try {
      printer.testEnded(CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void convertToHtml()
  {
    MSG("HTMLo͗pɕϊ郁\bh̊mFB");

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name");
    EQUAL(printer.convertToHtml(""), "");
    EQUAL(printer.convertToHtml("ABC"), "ABC");
    EQUAL(printer.convertToHtml("<ABC>"), "&#60;ABC&#62;");
    EQUAL(printer.convertToHtml("A&B"), "A&#38;B");
    EQUAL(printer.convertToHtml("AAA\r\nBBB\r\n"), "AAA<BR>BBB<BR>");
  }

  public void convertToHtml_0()
  {
    MSG("k̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name");
    try {
      printer.convertToHtml(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getReplacedString()
  {
    MSG("wqϊ郁\bh̊mFB");

    PropertyResource res = new PropertyResource();
    res.setFirstValue("key", "%{test.name}");

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name", res);

    Map<String, Object> objMap = new HashMap<String, Object>();
    objMap.put("test", printer.createCaseResult("AAA", CaseResult.NULL));

    EQUAL(printer.getReplacedString("key", objMap), "AAA");


    res.setFirstValue("key0", "");
    res.setFirstValue("key1", "aaa");
    res.setFirstValue("key2", "%%");

    EQUAL(printer.getReplacedString("key0", objMap), "");
    EQUAL(printer.getReplacedString("key1", objMap), "aaa");
    EQUAL(printer.getReplacedString("key2", objMap), "%");
  }

  public void getReplacedString_0()
  {
    MSG("k̏ꍇB");

    Map<String, Object> objMap = new HashMap<String, Object>();

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name");
    try {
      printer.getReplacedString(null, objMap);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.getReplacedString("aaa", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void outputHtmlFile()
  {
    MSG("ʂHTMLt@Cɏo͂郁\bh̊mFB");

    final String PATH = "test/aaa.html";

    PropertyResource res = new PropertyResource();
    res.setFirstValue("printer.html.toFile", PATH);

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name", res);

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult c0 = printer.createCaseResult("a0", CaseResult.NULL);
    objMap.put("test", c0);

    CaseResult c1 = printer.createCaseResult("a1", c0);
    c0.addChildResult(c1);
    CaseResult c2 = printer.createCaseResult("a2", c0);
    c0.addChildResult(c2);

    printer.outputHtmlFile(objMap);

    try {
      File f = new File(PATH);
      TRUE(f.exists());
      f.delete();
    } catch (Exception e) {
      NG(e);
    }
  }
  
  public void outputHtmlFile_0()
  {
    MSG("k̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name");
    try {
      printer.outputHtmlFile(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void outputHtmlFile_1()
  {
    MSG("HTMLt@C̃pXsȏꍇB");

    final String PATH = "z:/text/aaa.html";

    PropertyResource res = new PropertyResource();
    res.setFirstValue("printer.html.toFile", PATH);

    HtmlPrinterBase printer = new HtmlPrinterBase("My Name", res);

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult c0 = printer.createCaseResult("a0", CaseResult.NULL);
    objMap.put("test", c0);

    CaseResult c1 = printer.createCaseResult("a1", c0);
    c0.addChildResult(c1);
    CaseResult c2 = printer.createCaseResult("a2", c0);
    c0.addChildResult(c2);

    printer.outputHtmlFile(objMap);

    try {
      File f = new File(PATH);
      FALSE(f.exists());
      f.delete();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void replaceArgument_buf_fmt_idx_objMap()
  {
    MSG("wqϊ郁\bh̊mFB");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    printer.setTesterName("AAA");

    CaseResult result = printer.createCaseResult("abc", CaseResult.NULL);
    Map<String, Object> objMap = new HashMap<String, Object>();
    objMap.put("test", result);

    StringBuffer buf = new StringBuffer();
    EQUAL(printer.replaceArgument(buf, "${test.tester}", 0, objMap), 13);
    EQUAL(buf.toString(), "AAA");

    buf = new StringBuffer();
    EQUAL(printer.replaceArgument(buf,"name = ${test.name}",7,objMap), 18);
    EQUAL(buf.toString(), "abc");

    buf = new StringBuffer();
    EQUAL(printer.replaceArgument(buf, "$test.tester", 0, objMap), 1);
    EQUAL(buf.toString(), "$t");

    buf = new StringBuffer();
    EQUAL(printer.replaceArgument(buf, "${test.testerXXXX", 0, objMap), 16);
    EQUAL(buf.toString(), "${test.testerXXXX");

    buf = new StringBuffer();
    EQUAL(printer.replaceArgument(buf, "${ test.tester }", 0, objMap), 15);
    EQUAL(buf.toString(), "AAA");
  }

  public void replaceArgument_buf_fmt_idx_objMap_0()
  {
    MSG("k̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    StringBuffer buf = new StringBuffer();
    Map<String, Object> objMap = new HashMap<String, Object>();

    try {
      printer.replaceArgument(null, "", 0, objMap);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.replaceArgument(buf, null, 0, objMap);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.replaceArgument(buf, "", 0, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void replaceArgument_buf_fmt_idx_objMap_1()
  {
    MSG("̃CfbNXsȏꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    StringBuffer buf = new StringBuffer();
    Map<String, Object> objMap = new HashMap<String, Object>();

    try {
      printer.replaceArgument(buf, "", -1, objMap);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.replaceArgument(buf, "", 1, objMap);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void replaceArgument_buf_fmt_idx_objMap_2()
  {
    MSG("񂪋̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    StringBuffer buf = new StringBuffer();
    Map<String, Object> objMap = new HashMap<String, Object>();

    EQUAL(printer.replaceArgument(buf, "", 0, objMap), 0);
    EQUAL(buf.toString(), "");
  }

  public void replaceArgument_arg_objMap()
  {
    MSG("wqϊ郁\bh̊mFB");
    MSG("ʃIuWFNgȂꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    printer.setTesterName("AAA");

    Map<String, Object> objMap = new HashMap<String, Object>();

    EQUAL(printer.replaceArgument("test.name", objMap), "--");
    EQUAL(printer.replaceArgument("test.tester", objMap), "--");
    EQUAL(printer.replaceArgument("case.name", objMap), "--");
    EQUAL(printer.replaceArgument("name", objMap), "--");
  }

  public void replaceArgument_arg_objMap_0()
  {
    MSG("k̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    printer.setTesterName("AAA");

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult testRes = printer.createCaseResult("TTT", CaseResult.NULL);
    objMap.put("test", testRes);

    CaseResult caseRes = printer.createCaseResult("CCC", testRes);
    objMap.put("case", caseRes);

    try {
      printer.replaceArgument(null, objMap);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.replaceArgument("", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void replaceArgument_arg_objMap__test_name_1()
  {
    MSG("wq̏ꍇB");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    printer.setTesterName("AAA");

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult testRes = printer.createCaseResult("TTT", CaseResult.NULL);
    objMap.put("test", testRes);

    CaseResult caseRes = printer.createCaseResult("CCC", testRes);
    objMap.put("case", caseRes);

    EQUAL(printer.replaceArgument("", objMap), "--");
  }

  public void replaceArgument_arg_objMap__test()
  {
    MSG("ϊ̊mF(test.*)B");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    printer.setTesterName("AAA");

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult testRes = printer.createCaseResult("TTT", CaseResult.NULL);
    testRes.addChildResult(CheckResult.OK());
    testRes.addChildResult(CheckResult.NG());
    testRes.addChildResult(CheckResult.NG());
    testRes.addChildResult(CheckResult.KnownBug());
    testRes.addChildResult(CheckResult.KnownBug());
    testRes.addChildResult(CheckResult.KnownBug());
    testRes.addChildResult(CheckResult.Empty());
    testRes.addChildResult(CheckResult.Empty());
    testRes.addChildResult(CheckResult.Empty());
    testRes.addChildResult(CheckResult.Empty());
    testRes.addChildResult(CheckResult.Incomplete());
    testRes.addChildResult(CheckResult.Incomplete());
    testRes.addChildResult(CheckResult.Incomplete());
    testRes.addChildResult(CheckResult.Incomplete());
    testRes.addChildResult(CheckResult.Incomplete());
    testRes.addMessage("");
    objMap.put("test", testRes);

    CaseResult caseRes = printer.createCaseResult("CCC", testRes);
    objMap.put("case", caseRes);

    Calendar cal = Calendar.getInstance();
    SimpleDateFormat sf = new SimpleDateFormat("MM/dd");
    String dateStr = sf.format(cal.getTime());

    EQUAL(printer.replaceArgument("test.name", objMap), "TTT");
    EQUAL(printer.replaceArgument("test.message", objMap), "\r\n");
    EQUAL(printer.replaceArgument("test.tester", objMap), "AAA");
    OK(printer.replaceArgument("test.date", objMap));
    EQUAL(printer.replaceArgument("test.date, MM/dd", objMap), dateStr);
    EQUAL(printer.replaceArgument("test.judge", objMap), "reject");
    EQUAL(printer.replaceArgument("test.check", objMap), "15");
    EQUAL(printer.replaceArgument("test.good", objMap), "1");
    EQUAL(printer.replaceArgument("test.nogood", objMap), "2");
    EQUAL(printer.replaceArgument("test.knownbug", objMap), "3");
    EQUAL(printer.replaceArgument("test.child", objMap), "15");
    EQUAL(printer.replaceArgument("test.empty", objMap), "4");
    EQUAL(printer.replaceArgument("test.incomplete", objMap), "5");
  }

  public void replaceArgument_arg_objMap__case()
  {
    MSG("ϊ̊mF(case.*)B");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    printer.setTesterName("BBB");

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult testRes = printer.createCaseResult("TTT", CaseResult.NULL);
    objMap.put("test", testRes);

    CaseResult caseRes = printer.createCaseResult("CCC", testRes);
    caseRes.addChildResult(CheckResult.OK());
    caseRes.addChildResult(CheckResult.KnownBug());
    caseRes.addChildResult(CheckResult.KnownBug());
    caseRes.addChildResult(CheckResult.Empty());
    caseRes.addChildResult(CheckResult.Empty());
    caseRes.addChildResult(CheckResult.Empty());
    caseRes.addChildResult(CheckResult.Incomplete());
    caseRes.addChildResult(CheckResult.Incomplete());
    caseRes.addChildResult(CheckResult.Incomplete());
    caseRes.addChildResult(CheckResult.Incomplete());
    caseRes.addMessage("");
    objMap.put("case", caseRes);

    EQUAL(printer.replaceArgument("case.name", objMap), "CCC");
    EQUAL(printer.replaceArgument("case.message", objMap), "\r\n");
    EQUAL(printer.replaceArgument("case.judge", objMap), "pass");
    EQUAL(printer.replaceArgument("case.check", objMap), "10");
    EQUAL(printer.replaceArgument("case.good", objMap), "1");
    EQUAL(printer.replaceArgument("case.nogood", objMap), "0");
    EQUAL(printer.replaceArgument("case.knownbug", objMap), "2");
    EQUAL(printer.replaceArgument("case.child", objMap), "10");
    EQUAL(printer.replaceArgument("case.empty", objMap), "3");
    EQUAL(printer.replaceArgument("case.incomplete", objMap), "4");
    EQUAL(printer.replaceArgument("case.index", objMap), "0");
  }

  public void replaceArgument_arg_objMap__test_2()
  {
    MSG("ϊ̊mF(test.*) - 2B");

    HtmlPrinterBase printer = new HtmlPrinterBase();
    printer.setTesterName("AAA");

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult testRes = printer.createCaseResult("TTT", CaseResult.NULL);
    objMap.put("test", testRes);
    EQUAL(printer.replaceArgument("test.lastname", objMap), "TTT");
    EQUAL(printer.replaceArgument("test.package-dir", objMap), ".");

    CaseResult testRes2 = printer.createCaseResult("aaa.bbb.", CaseResult.NULL);
    objMap.put("test", testRes2);
    EQUAL(printer.replaceArgument("test.lastname", objMap), "");
    EQUAL(printer.replaceArgument("test.package-dir", objMap), "aaa/bbb");

    CaseResult testRes3 = printer.createCaseResult(
      "aaa.bbb.ccc.DDD", CaseResult.NULL);
    objMap.put("test", testRes3);
    EQUAL(printer.replaceArgument("test.lastname", objMap), "DDD");
    EQUAL(printer.replaceArgument("test.package-dir", objMap), "aaa/bbb/ccc");
  }
}
