/*
 * Decompiled with CFR 0.152.
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ts.util.Duo;
import ts.util.Trio;
import ts.util.text.StringOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNewerThanTargetFilter
implements FileFilter {
    private File baseDir_;
    private File destDir_;
    private List<Trio<String, String, Boolean>> nameReplaceLst_ = new LinkedList<Trio<String, String, Boolean>>();
    private List<Trio<String, String, Boolean>> dirReplaceLst_ = new LinkedList<Trio<String, String, Boolean>>();

    public FileNewerThanTargetFilter(File file, File file2) {
        assert (file != null) : "@param:baseDir is null.";
        assert (file2 != null) : "@param:destDir is null.";
        this.baseDir_ = file;
        this.destDir_ = file2;
    }

    public void addNameReplaceFirst(String string, String string2) {
        assert (string != null) : "@param:regex is null.";
        assert (string2 != null) : "@param:replacement is null.";
        this.nameReplaceLst_.add(new Trio<String, String, Boolean>(string, string2, Boolean.FALSE));
    }

    public void addNameReplaceAll(String string, String string2) {
        assert (string != null) : "@param:regex is null.";
        assert (string2 != null) : "@param:replacement is null.";
        this.nameReplaceLst_.add(new Trio<String, String, Boolean>(string, string2, Boolean.TRUE));
    }

    public void addDirReplaceFirst(String string, String string2) {
        assert (string != null) : "@param:regex is null.";
        assert (string2 != null) : "@param:replacement is null.";
        this.dirReplaceLst_.add(new Trio<String, String, Boolean>(string, string2, Boolean.FALSE));
    }

    public void addDirReplaceAll(String string, String string2) {
        assert (string != null) : "@param:regex is null.";
        assert (string2 != null) : "@param:replacement is null.";
        this.dirReplaceLst_.add(new Trio<String, String, Boolean>(string, string2, Boolean.TRUE));
    }

    @Override
    public boolean accept(File file) {
        assert (file != null) : "@param:file is null.";
        try {
            if (!file.exists()) {
                return false;
            }
            File file2 = this.getTargetFile(file);
            if (!file2.exists()) {
                return true;
            }
            return file2.lastModified() < file.lastModified();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected File getTargetFile(File file) throws IOException {
        Trio<String, String, Boolean> trio22;
        Duo<String, String> duo = this.getRelativePaths(file, this.baseDir_);
        String string = duo.getSecond();
        for (Trio<String, String, Boolean> trio22 : this.nameReplaceLst_) {
            if (trio22.getThird().booleanValue()) {
                string = string.replaceAll((String)trio22.getFirst(), (String)trio22.getSecond());
                continue;
            }
            string = string.replaceFirst((String)trio22.getFirst(), (String)trio22.getSecond());
        }
        Object object = duo.getFirst();
        for (Trio trio3 : this.dirReplaceLst_) {
            if (((Boolean)trio3.getThird()).booleanValue()) {
                object = ((String)object).replaceAll((String)trio3.getFirst(), (String)trio3.getSecond());
                continue;
            }
            object = ((String)object).replaceFirst((String)trio3.getFirst(), (String)trio3.getSecond());
        }
        trio22 = this.destDir_;
        if (!StringOperation.isEmpty((String)object)) {
            trio22 = new File((File)((Object)trio22), (String)object);
        }
        if (!StringOperation.isEmpty(string)) {
            trio22 = new File((File)((Object)trio22), string);
        }
        return trio22;
    }

    protected Duo<String, String> getRelativePaths(File file, File file2) throws IOException {
        String string;
        assert (file != null) : "@param:file is null.";
        assert (file2 != null) : "@param:baseFile is null.";
        String string2 = file.getCanonicalPath();
        if (StringOperation.startsWith(string2, string = file2.getCanonicalPath())) {
            int n = StringOperation.length(string);
            String string3 = StringOperation.substring(string2, n);
            if (StringOperation.isEmpty(string3)) {
                return new Duo<String, String>("", "");
            }
            if (StringOperation.startsWith(string3, File.separator)) {
                int n2 = StringOperation.length(File.separator);
                int n3 = StringOperation.lastIndexOf(string3, File.separator);
                if (n3 < 0) {
                    return new Duo<String, String>("", string3);
                }
                if (n3 == 0) {
                    return new Duo<String, String>("", StringOperation.substring(string3, n2));
                }
                return new Duo<String, String>(StringOperation.substring(string3, n2, n3), StringOperation.substring(string3, n3 + n2));
            }
        }
        throw new IllegalArgumentException("@param:file is not a child path of @param:baseFile.");
    }
}

