/*
 * Decompiled with CFR 0.152.
 */
package ts.util.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import ts.util.resource.DefaultResource;
import ts.util.resource.IllegalKeyException;
import ts.util.resource.hierarchy.Element;
import ts.util.text.StringOperation;

public class PropertyResource
extends DefaultResource {
    public PropertyResource() {
    }

    public PropertyResource(String string) throws FileNotFoundException, IOException {
        this.load(string);
    }

    protected PropertyResource(PropertyResource propertyResource) {
        super(propertyResource);
    }

    protected DefaultResource createResource() {
        return new PropertyResource(this);
    }

    protected void load(InputStream inputStream) throws IOException {
        assert (inputStream != null) : "@param:stream is null.";
        this.renew();
        PropertiesReader propertiesReader = new PropertiesReader();
        propertiesReader.load(inputStream);
    }

    public void save(OutputStream outputStream) throws IOException {
        assert (outputStream != null) : "@param:stream is null.";
        try {
            PropertiesWriter propertiesWriter = new PropertiesWriter();
            propertiesWriter.store(outputStream, null);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            iOException.setStackTrace(exception.getStackTrace());
            throw iOException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesWriter
    extends Properties {
        static final long serialVersionUID = -3779072493340204504L;
        private PropertyResource loadRes_;
        private List<String[]> elementLst_ = new LinkedList<String[]>();
        private int index_;

        public PropertiesWriter() {
            this.loadRes_ = new PropertyResource();
            this.loadRes_.setElementSeparator(".");
            this.loadRes_.setAttributeParenthesis("(", ")");
            this.loadRes_.setAttributeSeparator(",");
            this.loadRes_.setAttributeMatchMark("=");
        }

        @Override
        public Enumeration<Object> keys() {
            this.index_ = 0;
            this.elementLst_.clear();
            this.listAllElements(PropertyResource.this.getBaseElement(), "", this.elementLst_);
            return new Enumeration<Object>(){

                @Override
                public boolean hasMoreElements() {
                    return PropertiesWriter.this.index_ < PropertiesWriter.this.elementLst_.size();
                }

                @Override
                public Object nextElement() {
                    String[] stringArray = (String[])PropertiesWriter.this.elementLst_.get(PropertiesWriter.this.index_);
                    PropertiesWriter.this.index_++;
                    return stringArray[0];
                }
            };
        }

        @Override
        public Object get(Object object) {
            if (0 < this.index_ && this.index_ <= this.elementLst_.size()) {
                String[] stringArray = this.elementLst_.get(this.index_ - 1);
                return stringArray[1];
            }
            return null;
        }

        protected void listAllElements(Element element, String string, List<String[]> list) {
            assert (element != null) : "@param:parent is null.";
            assert (string != null) : "@param:parentKey is null.";
            assert (list != null) : "@param:elemLst is null.";
            List<Element> list2 = element.getAllChildren();
            for (Element element2 : list2) {
                Object object;
                StringBuilder stringBuilder = new StringBuilder();
                if (!StringOperation.isEmpty(string)) {
                    stringBuilder.append(string).append(this.loadRes_.elementSeparator());
                }
                stringBuilder.append(element2.getName());
                Iterator iterator = element2.getAttributes().entrySet().iterator();
                if (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuilder.append(this.loadRes_.attributeParenthesis()[0]);
                    stringBuilder.append((String)object.getKey());
                    stringBuilder.append(this.loadRes_.attributeMatchMark());
                    stringBuilder.append((String)object.getValue());
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        stringBuilder.append(this.loadRes_.attributeSeparator());
                        stringBuilder.append((String)object.getKey());
                        stringBuilder.append(this.loadRes_.attributeMatchMark());
                        stringBuilder.append((String)object.getValue());
                    }
                    stringBuilder.append(this.loadRes_.attributeParenthesis()[1]);
                }
                if (element2.getValue() != null) {
                    object = new String[]{stringBuilder.toString(), element2.getValue()};
                    list.add((String[])object);
                }
                this.listAllElements(element2, stringBuilder.toString(), list);
            }
        }
    }

    private class PropertiesReader
    extends Properties {
        static final long serialVersionUID = 1121939455320561763L;
        private PropertyResource loadRes_ = new PropertyResource();

        public PropertiesReader() {
            this.loadRes_.setElementSeparator(".");
            this.loadRes_.setAttributeParenthesis("(", ")");
            this.loadRes_.setAttributeSeparator(",");
            this.loadRes_.setAttributeMatchMark("=");
        }

        public Object put(Object object, Object object2) throws IllegalKeyException {
            assert (object != null) : "@param:key is null.";
            assert (object2 != null) : "@param:value is null.";
            assert (object instanceof String) : "@param:key is not a string.";
            assert (object2 instanceof String) : "@param:value is not a string.";
            String string = object.toString();
            String string2 = object2.toString();
            if (StringOperation.isEmpty(string) && PropertyResource.this.getBaseElement() == PropertyResource.this.getRootElement()) {
                throw new IllegalKeyException(string);
            }
            List<String> list = this.loadRes_.splitKey(string);
            int n = list.size() - 1;
            List<String> list2 = list.subList(0, n);
            Element element = PropertyResource.this.findOrCreateFirstElement(list2);
            String string3 = list.get(n);
            String string4 = PropertyResource.this.getNameOfKeyElement(string3);
            List<String[]> list3 = PropertyResource.this.listAttributesOfKeyElement(string3);
            Element element2 = new Element(string4);
            for (String[] stringArray : list3) {
                element2.putAttribute(stringArray[0], stringArray[1]);
            }
            element2.setValue(string2);
            element.addChild(element2);
            return element2;
        }
    }
}

