/*
 * GeneralComparatorTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.util.Comparator;

/**
 * {@link ts.util.GeneralComparator GeneralComparator}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/10/09 17:04:50 $
 */
public class GeneralComparatorTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(GeneralComparatorTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("GeneralComparator NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^̊mF");
    Comparator<Object> c = new GeneralComparator();
    NOTNULL(c);
  }

  public void compare()
  {
    MSG("IuWFNg̑召̔r");

    Comparator<Object> c = new GeneralComparator();
    TRUE(c.compare("abc", "abc") == 0);
    TRUE(c.compare("abc", "bcd") <  0);
    TRUE(c.compare("abc", "aaa") >  0);

    TRUE(c.compare(123, 123) == 0);
    TRUE(c.compare(123, 234) <  0);
    TRUE(c.compare(123, 012) >  0);

    TRUE(c.compare("123", new Integer(123)) > 0);
    TRUE(c.compare("123", new Integer(234)) < 0);
    TRUE(c.compare("123", new Integer(012)) > 0);
    TRUE(c.compare(new Integer(234), "123") > 0);

    TRUE(c.compare("123", null) <  0);
    TRUE(c.compare(null, "112") >  0);
    TRUE(c.compare(null, null) == 0);
  }

  public void _equals()
  {
    MSG("gƓǂ̔r");

    Comparator<Object> c = new GeneralComparator();
    Comparator<Object> c1 = new GeneralComparator();
    TRUE(c.equals(c));
    FALSE(c.equals(c1));
    FALSE(c.equals(null));
    FALSE(c.equals(new Integer(123)));
  }
}

