/*
 * FileSizeFilter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;

/**
 * t@CETCYƂt@CEtB^ENXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:12 $
 */
public class FileSizeFilter implements FileFilter
{
  /** t@CETCY̍ŏlB */
  private long sizeFrom_ = -1L;

  /** t@CETCY̍őlB */
  private long sizeTo_ = -1L;

  /**
   * t@CETCY͈̔͂ɂƂRXgN^B
   * <br>
   * ̒lݒ肵ꍇ́A̒lƂĎgpȂB
   * <br>
   * ̒lł͂ȂAŏlƍől̎w肪tꍇ́A
   * ւĐݒ肷B
   *
   * @param  sizeFrom t@CETCY̍ŏlB
   * @param  sizeTo   t@CETCY̍őlB
   */
  public FileSizeFilter(long sizeFrom, long sizeTo)
  {
    if (sizeFrom >= 0 && sizeTo >= 0) {
      if (sizeFrom <= sizeTo) {
        sizeFrom_ = sizeFrom;
        sizeTo_ = sizeTo;
      }
      else {
        sizeFrom_ = sizeTo;
        sizeTo_ = sizeFrom;
      }
    }
    else {
      sizeFrom_ = (sizeFrom < 0L) ? -1L : sizeFrom;
      sizeTo_ = (sizeTo < 0L) ? -1L : sizeTo;
    }
  }

  /**
   * w肳ꂽt@C̃TCYÃIuWFNg̎TCY͈̔͂ɊY
   * iEl܂ށjǂ𔻒肷B
   *
   * @param  file Ώۂ̃t@CB
   * @return t@CETCYYꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public boolean accept(File file)
  {
    assert (file != null) : "@param:file is null.";

    if (sizeFrom_ >= 0) {
      if (file.length() < sizeFrom_) {
        return false;
      }
    }

    if (sizeTo_ >= 0) {
      if (file.length() > sizeTo_) {
        return false;
      }
    }

    return true;
  }
}

