/*
 * IllegalKeyExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * <code>IllegalKeyException</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:15 $
 */
public class IllegalKeyExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);
      run(IllegalKeyExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor_key()
  {
    MSG("ʏ̑");

    try {
      throw new IllegalKeyException("aaa.bbb.");
    } catch (IllegalKeyException e) {
      TRUE(e instanceof RuntimeException);
      EQUAL(e.getKey(), "aaa.bbb.");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void constructor_key_1()
  {
    MSG("k̏ꍇ");

    try {
      throw new IllegalKeyException(null);
    } catch (IllegalKeyException e) {
      TRUE(e instanceof RuntimeException);
      EQUAL(e.getKey(), "");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void constructor_key_msg()
  {
    MSG("ʏ̑");

    try {
      throw new IllegalKeyException("xxx.yyy.", "");
    } catch (IllegalKeyException e) {
      TRUE(e instanceof RuntimeException);
      EQUAL(e.getKey(), "xxx.yyy.");
      EQUAL(e.getMessage(), "");
      NULL(e.getCause());
    }
  }

  public void constructor_key_msg_1()
  {
    MSG("k̏ꍇ");

    try {
      throw new IllegalKeyException(null, (String) null);
    } catch (IllegalKeyException e) {
      TRUE(e instanceof RuntimeException);
      EQUAL(e.getKey(), "");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void constructor_key_msg_throwable()
  {
    MSG("ʏ̑");

    try {
      throw new IllegalKeyException("aaa.bbb.", "",
        new NullPointerException());
    } catch (IllegalKeyException e) {
      TRUE(e instanceof RuntimeException);
      EQUAL(e.getKey(), "aaa.bbb.");
      EQUAL(e.getMessage(), "");
      EQUAL(e.getCause().getClass(), NullPointerException.class);
    }
  }

  public void constructor_key_msg_throwable_1()
  {
    MSG("k̏ꍇ");

    try {
      throw new IllegalKeyException(null, null, null);
    } catch (IllegalKeyException e) {
      TRUE(e instanceof RuntimeException);
      EQUAL(e.getKey(), "");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void constructor_key_throwable()
  {
    MSG("ʏ̑");

    try {
      throw new IllegalKeyException("aaa.bbb.", new NullPointerException());
    } catch (IllegalKeyException e) {
      TRUE(e instanceof RuntimeException);
      EQUAL(e.getKey(), "aaa.bbb.");
      EQUAL(e.getMessage(), NullPointerException.class.getName());
      EQUAL(e.getCause().getClass(), NullPointerException.class);
    }
  }

  public void constructor_key_throwable_1()
  {
    MSG("k̏ꍇ");

    try {
      throw new IllegalKeyException(null, (Throwable) null);
    } catch (IllegalKeyException e) {
      TRUE(e instanceof RuntimeException);
      EQUAL(e.getKey(), "");
      NULL(e.getMessage());
      NULL(e.getCause());
    }
  }

  public void toString_0()
  {
    MSG("ObZ[Ww肵Ȃꍇ");

    try {
      throw new IllegalKeyException("aaa.bbb.");
    } catch (Exception e) {
      EQUAL(e.toString(), "ts.util.resource.IllegalKeyException: The key is illegal: aaa.bbb.");
    }
  }

  public void toString_1()
  {
    MSG("ObZ[Ww肵ꍇ");

    try {
      throw new IllegalKeyException("aaa.bbb.", "ccc");
    } catch (Exception e) {
      EQUAL(e.toString(),
        "ts.util.resource.IllegalKeyException: ccc: aaa.bbb.");
    }
    try {
      throw new IllegalKeyException("aaa.bbb.", (String) null);
    } catch (Exception e) {
      EQUAL(e.toString(), "ts.util.resource.IllegalKeyException: The key is illegal: aaa.bbb.");
    }
  }
}
