/*
 * Element class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource.hierarchy;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.LinkedList;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Kw\vfNXB 
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:16 $
 */
public class Element
{
  /** vfB */
  private String name_ ;

  /** vf̒lB */
  private String value_ = null;

  /** }bvB*/
  private AttributeMap attrMap_ = new AttributeMap();

  /** evfB */
  private Element parent_ = null;

  /** qvfi[}bvB*/
  Map<String, List<Element>> childMap_ =
    new LinkedHashMap<String, List<Element>>();

  /**
   * [gvf쐬B
   * <br>
   * [gvf́A\[X\vf̃gbvɈʒuvf̂ƂA
   * vfvflA͎Aqvf̐1ƂB
   *
   * @return 쐬ꂽ[gvfB
   */
  public static Element createRootElement()
  {
    return new Element() {
        @Override public String setValue(String value) {
          assert false;
          return "";
        }
        @Override public String putAttribute(String name, String value) {
          assert false;
          return "";
        }
      };
  }

  /**
   * ftHgRXgN^B
   */
  private Element()
  {
    name_ = "";
    parent_ = null;
  }

  /**
   * vfɂRXgN^B
   * 
   * @param  name vfB
   * @throws AssertionError vfk͋󕶎̏ꍇB
   */
  public Element(String name)
  {
    assert (name != null) : "@param:name is null.";
    assert (name.length() > 0) : "@param:name is empty.";

    name_ = name;
  }

  /**
   * vf擾B
   *
   * @return vfB
   */
  public String getName()
  {
    return name_ ;
  }

  /**
   * vf̒l擾B
   *
   * @return vf̒lB
   */
  public String getValue()
  {
    return value_ ;
  }

  /**
   * vf̒lݒ肷B
   * <br>
   * k̏ꍇ́Â܂܃kݒ肷B
   *
   * @param  value vf̒lB
   * @return O̗vflB
   */
  public String setValue(String value)
  {
    String oldValue = value_ ;
    value_ = value;
    return oldValue;
  }

  /**
   * evf擾B
   *
   * @return  evfB
   */
  public Element getParent()
  {
    return parent_ ;
  }

  /**
   * ̗vf̑i[}bv擾B
   *
   * @return ̗vf̑i[}bvB
   */
  public AttributeMap getAttributes()
  {
    return attrMap_ ;
  }

  /**
   * ݒ肷B
   *
   * @param  name B
   * @param  value lB
   * @return  ȎlB
   * @throws  AssertionError k͑󕶎̏ꍇB
   */
  public String putAttribute(String name, String value)
  {
    assert (name != null) : "@param;name is null.";
    assert (value != null) : "@param:value is null";
    assert (name.length() > 0) : "@param:name is empty";

    return attrMap_.put(name, value);
  }

  /**
   * qvfǉB
   *
   * @param  child qvfB
   * @throws AssertionError k̏ꍇB
   */
  public void addChild(Element child)
  {
    assert (child != null) : "@param:child is null.";

    List<Element> eL = childMap_.get(child.getName());
    if (eL == null) {
      eL = new LinkedList<Element>();
      childMap_.put(child.getName(), eL);
    }
    child.parent_ = this;
    eL.add(child);
  }

  /**
   * w肳ꂽvfSĂ̎qvf폜B
   *
   * @param  name vfB
   * @throws AssertionError k̏ꍇB
   */
  public void removeChildren(String name)
  {
    assert (name != null) : "@param:name is null.";

    childMap_.remove(name);
  }

  /**
   * ̗vf̑SĂ̎qvf폜B
   */
  public void removeAllChildren()
  {
    childMap_.clear();
  }

  /**
   * w肳ꂽvfŏ̎qvf擾B
   * <br>
   * w肳ꂽvfqvf݂Ȃꍇ̓kԂB
   *
   * @param  name vfB
   * @return w肳ꂽvfŏ̎qvfB
   * @throws AssertionError k̏ꍇB
   */
  public Element getFirstChild(String name)
  {
    assert (name != null) : "@param:name is null.";

    List<Element> eL = childMap_.get(name);
    if (eL == null || eL.size() == 0) {
      return null;
    }
    return eL.get(0);
  }

  /**
   * w肳ꂽvfSĂ̎qvfi[Xg擾B
   * <br>
   * w肳ꂽvfqvf݂Ȃꍇ͋̃XgԂB
   *
   * @param  name vfB
   * @return w肳ꂽvfSĂ̎qvfi[XgB
   * @throws AssertionError k̏ꍇB
   */
  public List<Element> getChildren(String name)
  {
     assert (name != null) : "@param:name is null.";

     List<Element> eL = childMap_.get(name);
     return (eL != null) ? eL : new LinkedList<Element>();
  }

  /**
   * ̗vf̑SĂ̎qvf񋓂B
   *
   * @return SĂ̎qvfi[񋓃IuWFNgB
   */
  public List<Element> getAllChildren()
  {
    List<Element> allL = new LinkedList<Element>();
    for (List<Element> eL : childMap_.values()) {
      for (Element e : eL) {
        allL.add(e);
      }
    }
    return allL;
  }
}
