/*
 * SpecialCharNotEscapedExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * {@link ts.util.text.SpecialCharNotEscapedException SpecialCharNotEscapedException}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:17 $
 */
public class SpecialCharNotEscapedExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(SpecialCharNotEscapedExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("SpecialCharNotEscapedException NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor_index_string()
  {
    MSG("CfbNXƕɂƂRXgN^B");

    try {
      throw new SpecialCharNotEscapedException(10, "abc", "\\");
    } catch (SpecialCharNotEscapedException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), "abc");
      EQUAL(e.getSpecialChar(), "\\");
      EQUAL(e.getMessage(), null);
      EQUAL(e.toString(), e.getClass().getName());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_index_string_msg()
  {
    MSG("CfbNXƕƗObZ[WɂƂRXgN^B");

    try {
      throw new SpecialCharNotEscapedException(10, "abc", "\\", "def");
    } catch (SpecialCharNotEscapedException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), "abc");
      EQUAL(e.getSpecialChar(), "\\");
      EQUAL(e.getMessage(), "def");
      EQUAL(e.toString(), e.getClass().getName() + ": def");
    } catch (Exception e) {
      NG(e);
    }
    try {
      throw new SpecialCharNotEscapedException(10, null, "\\", "def");
    } catch (SpecialCharNotEscapedException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), null);
      EQUAL(e.getSpecialChar(), "\\");
      EQUAL(e.getMessage(), "def");
      EQUAL(e.toString(), e.getClass().getName() + ": def");
    } catch (Exception e) {
      NG(e);
    }
    try {
      throw new SpecialCharNotEscapedException(10, "abc", null, "def");
    } catch (SpecialCharNotEscapedException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), "abc");
      EQUAL(e.getSpecialChar(), null);
      EQUAL(e.getMessage(), "def");
      EQUAL(e.toString(), e.getClass().getName() + ": def");
    } catch (Exception e) {
      NG(e);
    }
    try {
      throw new SpecialCharNotEscapedException(10, "abc", "\\", null);
    } catch (SpecialCharNotEscapedException e) {
      EQUAL(e.getStoppedIndex(), 10);
      EQUAL(e.convertedString(), "abc");
      EQUAL(e.getSpecialChar(), "\\");
      EQUAL(e.getMessage(), null);
      EQUAL(e.toString(), e.getClass().getName());
    } catch (Exception e) {
      NG(e);
    }
  }
}

