/*
 * Decompiled with CFR 0.152.
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ts.util.Duo;
import ts.util.file.DirectoryNotEmptyException;
import ts.util.file.FileAlreadyExistsException;
import ts.util.text.StringSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileOperation {
    protected FileOperation() {
    }

    protected static File getDestinationFile(File file, File file2, File file3) throws IOException {
        assert (file != null) : "@param:srcFile is null.";
        assert (file2 != null) : "@param:baseDir is null.";
        assert (file3 != null) : "@param:destDir is null.";
        StringSequence stringSequence = new StringSequence(file.getCanonicalPath());
        assert (stringSequence.startsWith(file2.getCanonicalPath()));
        StringSequence stringSequence2 = new StringSequence(file2.getCanonicalPath() + File.separator);
        if (stringSequence.restLength() > stringSequence2.restLength()) {
            return new File(file3, stringSequence.next(stringSequence2.restLength()).substring());
        }
        return file3;
    }

    private static File createDir(File file) throws IOException {
        if (file == null) {
            return null;
        }
        File file2 = null;
        for (File file3 = file; file3 != null && !file3.exists(); file3 = file3.getParentFile()) {
            file2 = file3;
        }
        if (!file.mkdirs()) {
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new FileAlreadyExistsException(file.getPath());
                }
            } else {
                throw new IOException(file.getPath());
            }
        }
        return file2;
    }

    public static File createNewFile(String string) throws FileAlreadyExistsException, IOException {
        assert (string != null) : "@param:path is null.";
        return FileOperation.createNewFile(new File(string));
    }

    public static File createNewFile(File file) throws IOException {
        assert (file != null) : "@param:file is null.";
        File file2 = FileOperation.createDir(file.getParentFile());
        if (!file.createNewFile()) {
            if (file2 != null) {
                FileOperation.deleteInner(file2);
            }
            if (file.exists()) {
                throw new FileAlreadyExistsException(file.getPath());
            }
            throw new IOException(file.getPath());
        }
        return file;
    }

    public static File createTempFile(String string, String string2, File file) throws IllegalArgumentException, IOException {
        return File.createTempFile(string, string2, file);
    }

    public static File createTempDirectory(String string, String string2, File file) throws IllegalArgumentException, IOException {
        File file2 = File.createTempFile(string, string2, file);
        file2.delete();
        file2.mkdirs();
        return file2;
    }

    public static List<File> list(File file) throws FileNotFoundException, IOException {
        assert (file != null) : "@param:baseDir is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            if (!file.isDirectory()) {
                linkedList.add(file);
                return linkedList;
            }
            throw new IOException(file.getPath());
        }
        for (int i = 0; i < fileArray.length; ++i) {
            linkedList.add(fileArray[i]);
        }
        return linkedList;
    }

    public static List<File> list(File file, FileFilter fileFilter) throws FileNotFoundException, IOException {
        assert (fileFilter != null) : "@param:filter is null.";
        List<File> list = FileOperation.list(file);
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (fileFilter.accept(iterator.next())) continue;
            iterator.remove();
        }
        return list;
    }

    public static List<File> listRecursive(File file) throws FileNotFoundException, IOException {
        assert (file != null) : "@param:baseDir is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        if (!file.isDirectory()) {
            linkedList.add(file);
            return linkedList;
        }
        return FileOperation.listInner(file, linkedList);
    }

    public static List<File> listRecursive(File file, FileFilter fileFilter) throws FileNotFoundException, IOException {
        assert (fileFilter != null) : "@param:filter is null.";
        List<File> list = FileOperation.listRecursive(file);
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (fileFilter.accept(iterator.next())) continue;
            iterator.remove();
        }
        return list;
    }

    public static void delete(File file) throws FileNotFoundException, DirectoryNotEmptyException, IOException {
        assert (file != null) : "@param:file is null.";
        if (!file.delete()) {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (file.isDirectory() && file.list().length > 0) {
                throw new DirectoryNotEmptyException(file.getPath());
            }
            throw new IOException(file.getPath());
        }
    }

    public static void delete(File file, FileFilter fileFilter) throws FileNotFoundException, DirectoryNotEmptyException, IOException {
        assert (file != null) : "@param:file is null.";
        assert (fileFilter != null) : "@param:filter is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (fileFilter.accept(file)) {
            FileOperation.delete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecursive(File file) throws FileNotFoundException, IOException {
        assert (file != null) : "@param:file is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        File file2 = FileOperation.createTempDirectory("._del", "", file.getParentFile());
        try {
            File file3 = new File(file2, file.getName());
            if (!file.renameTo(file3)) {
                throw new IOException(file.getPath());
            }
        }
        finally {
            FileOperation.deleteInner(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecursive(File file, FileFilter fileFilter) throws FileNotFoundException, IOException {
        assert (file != null) : "@param:file is null.";
        assert (fileFilter != null) : "@param:filter is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        linkedList.add(file);
        if (file.isDirectory()) {
            FileOperation.listInner(file, linkedList);
        }
        File file2 = FileOperation.createTempDirectory("._del", "", file.getParentFile());
        File file3 = new File(file2, file.getName());
        boolean bl = false;
        try {
            for (File file4 : linkedList) {
                if (!file4.exists() || !fileFilter.accept(file4)) continue;
                File file5 = FileOperation.getDestinationFile(file4, file, file3);
                File file6 = file5.getParentFile();
                if (file6 != null) {
                    file6.mkdirs();
                }
                if (file4.renameTo(file5)) continue;
                throw new IOException(file4.getPath());
            }
            bl = true;
        }
        finally {
            if (!bl) {
                FileOperation.moveInner(file3, file);
            }
            FileOperation.deleteInner(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(File file, File file2) throws FileNotFoundException, FileAlreadyExistsException, IOException {
        block21: {
            File file3;
            block22: {
                File file4;
                block23: {
                    File file5;
                    boolean bl;
                    block17: {
                        block18: {
                            block19: {
                                block20: {
                                    assert (file != null) : "@param:src is null.";
                                    assert (file2 != null) : "@param:dst is null.";
                                    if (!file.exists()) {
                                        throw new FileNotFoundException(file.getPath());
                                    }
                                    bl = false;
                                    file4 = FileOperation.createDir(file2.getParentFile());
                                    file3 = null;
                                    file5 = null;
                                    try {
                                        if (!file.renameTo(file2)) break block17;
                                        bl = true;
                                        if (bl) break block18;
                                        if (file5 == null) break block19;
                                        if (file5 == null) break block20;
                                        file5.renameTo(file);
                                    }
                                    catch (Throwable throwable) {
                                        if (!bl) {
                                            if (file5 != null) {
                                                if (file5 != null) {
                                                    file5.renameTo(file);
                                                }
                                                if (file4 != null) {
                                                    FileOperation.deleteInner(file4);
                                                }
                                            }
                                            if (file3 != null) {
                                                FileOperation.deleteInner(file3);
                                            }
                                        }
                                        throw throwable;
                                    }
                                }
                                if (file4 != null) {
                                    FileOperation.deleteInner(file4);
                                }
                            }
                            if (file3 != null) {
                                FileOperation.deleteInner(file3);
                            }
                        }
                        return;
                    }
                    if (file2.exists()) {
                        throw new FileAlreadyExistsException(file2.getPath());
                    }
                    file3 = FileOperation.createTempDirectory("._mov", "", file.getParentFile());
                    file5 = new File(file3, file.getName());
                    if (!file.renameTo(file5)) {
                        throw new IOException(file.getPath());
                    }
                    FileOperation.copyInner(file5, file2);
                    bl = true;
                    if (bl) break block21;
                    if (file5 == null) break block22;
                    if (file5 == null) break block23;
                    file5.renameTo(file);
                }
                if (file4 != null) {
                    FileOperation.deleteInner(file4);
                }
            }
            if (file3 != null) {
                FileOperation.deleteInner(file3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(File file, File file2, FileFilter fileFilter) throws FileNotFoundException, FileAlreadyExistsException, IOException {
        File file3;
        block21: {
            File file4;
            block22: {
                File file5;
                boolean bl;
                block18: {
                    block19: {
                        block20: {
                            assert (file != null) : "@param:src is null.";
                            assert (file2 != null) : "@param:dst is null.";
                            assert (fileFilter != null) : "@param:filter is null.";
                            if (!file.exists()) {
                                throw new FileNotFoundException(file.getPath());
                            }
                            if (!fileFilter.accept(file)) {
                                return;
                            }
                            bl = false;
                            file4 = FileOperation.createDir(file2.getParentFile());
                            file3 = null;
                            file5 = null;
                            try {
                                if (!file.renameTo(file2)) break block18;
                                bl = true;
                                if (bl) break block19;
                                if (file5 == null) break block20;
                                file5.renameTo(file);
                            }
                            catch (Throwable throwable) {
                                if (!bl) {
                                    if (file5 != null) {
                                        file5.renameTo(file);
                                    }
                                    if (file4 != null) {
                                        FileOperation.deleteInner(file4);
                                    }
                                }
                                if (file3 != null) {
                                    FileOperation.deleteInner(file3);
                                }
                                throw throwable;
                            }
                        }
                        if (file4 != null) {
                            FileOperation.deleteInner(file4);
                        }
                    }
                    if (file3 != null) {
                        FileOperation.deleteInner(file3);
                    }
                    return;
                }
                if (file2.exists()) {
                    throw new FileAlreadyExistsException(file2.getPath());
                }
                file3 = FileOperation.createTempDirectory("._mov", "", file.getParentFile());
                file5 = new File(file3, file.getName());
                if (!file.renameTo(file5)) {
                    throw new IOException(file.getPath());
                }
                FileOperation.copyInner(file5, file2);
                bl = true;
                if (bl) break block21;
                if (file5 == null) break block22;
                file5.renameTo(file);
            }
            if (file4 != null) {
                FileOperation.deleteInner(file4);
            }
        }
        if (file3 != null) {
            FileOperation.deleteInner(file3);
        }
    }

    public static void moveRecursive(File file, File file2) throws FileNotFoundException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException {
        FileOperation.moveInner(file, file2);
    }

    public static void moveRecursive(File file, File file2, FileFilter fileFilter) throws FileNotFoundException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException {
        FileOperation.moveInner(file, file2, fileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws FileNotFoundException, DirectoryNotEmptyException, FileAlreadyExistsException, IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file2.getPath());
        }
        if (file2.exists()) {
            throw new FileAlreadyExistsException(file2.getPath());
        }
        if (!file.isDirectory()) {
            boolean bl = false;
            File file3 = FileOperation.createDir(file2.getParentFile());
            try {
                FileOperation.copyFile(file, file2);
                bl = true;
            }
            finally {
                if (!bl && file3 != null) {
                    FileOperation.deleteInner(file3);
                }
            }
        } else {
            if (file.list().length > 0) {
                throw new DirectoryNotEmptyException(file.getPath());
            }
            file2.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2, FileFilter fileFilter) throws FileNotFoundException, DirectoryNotEmptyException, FileAlreadyExistsException, IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        assert (fileFilter != null) : "@param:filter is null.";
        if (!file.exists()) {
            throw new FileNotFoundException(file2.getPath());
        }
        if (!fileFilter.accept(file)) {
            return;
        }
        if (file2.exists()) {
            throw new FileAlreadyExistsException(file2.getPath());
        }
        if (!file.isDirectory()) {
            boolean bl = false;
            File file3 = FileOperation.createDir(file2.getParentFile());
            try {
                FileOperation.copyFile(file, file2);
                bl = true;
            }
            finally {
                if (!bl && file3 != null) {
                    FileOperation.deleteInner(file3);
                }
            }
        } else {
            if (file.list().length > 0) {
                throw new DirectoryNotEmptyException(file.getPath());
            }
            file2.mkdirs();
        }
    }

    public static void copyRecursive(File file, File file2) throws FileNotFoundException, FileAlreadyExistsException, IOException {
        FileOperation.copyInner(file, file2);
    }

    public static void copyRecursive(File file, File file2, FileFilter fileFilter) throws FileNotFoundException, FileAlreadyExistsException, IOException {
        FileOperation.copyInner(file, file2, fileFilter);
    }

    private static List<File> listInner(File file, List<File> list) throws IOException {
        assert (file != null) : "@param:dir is null.";
        assert (list != null) : "@param:fileLst is null.";
        assert (file.exists()) : "@param:dir does not exist.";
        if (!file.isDirectory()) {
            return list;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException(file.getPath());
        }
        for (File file2 : fileArray) {
            list.add(file2);
            FileOperation.listInner(file2, list);
        }
        return list;
    }

    private static void deleteInner(File file) throws IOException {
        assert (file != null) : "@param:dir is null.";
        assert (file.exists()) : "@param:dir does not exist.";
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                throw new IOException(file.getPath());
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    FileOperation.deleteInner(fileArray[i]);
                    continue;
                }
                if (fileArray[i].delete()) continue;
                throw new IOException(file.getPath());
            }
        }
        if (!file.delete()) {
            throw new IOException(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void moveInner(File file, File file2) throws IOException {
        LinkedList<Duo<Object, File>> linkedList;
        File file3;
        File file4;
        File file5;
        boolean bl;
        block43: {
            block42: {
                block40: {
                    block41: {
                        assert (file != null) : "@param:src is null.";
                        assert (file2 != null) : "@param:dst is null.";
                        if (!file.exists()) {
                            throw new FileNotFoundException(file.getPath());
                        }
                        bl = false;
                        file5 = FileOperation.createDir(file2.getParentFile());
                        file4 = null;
                        file3 = null;
                        linkedList = new LinkedList<Duo<Object, File>>();
                        try {
                            if (file.renameTo(file2)) {
                                bl = true;
                                Object var11_7 = null;
                                if (bl) break block40;
                                break block41;
                            }
                            if (file2.exists()) {
                                if (!file.isDirectory()) {
                                    throw new FileAlreadyExistsException(file2.getPath());
                                }
                                if (!file2.isDirectory()) {
                                    throw new FileAlreadyExistsException(file2.getPath());
                                }
                            } else {
                                if (!file.isDirectory()) {
                                    FileOperation.copyFile(file, file2);
                                    linkedList.addFirst(new Duo<Object, File>(null, file2));
                                    if (!file.delete()) {
                                        throw new IOException(file.getPath());
                                    }
                                    bl = true;
                                    break block42;
                                }
                                if (!file2.mkdir()) {
                                    throw new IOException(file2.getPath());
                                }
                                linkedList.addFirst(new Duo<Object, File>(null, file2));
                            }
                            if (!file.renameTo(file3 = new File(file4 = FileOperation.createTempDirectory("._mov", "", file.getParentFile()), file.getName()))) {
                                throw new IOException(file.getPath());
                            }
                            for (File file6 : FileOperation.listInner(file3, new LinkedList<File>())) {
                                File file7 = FileOperation.getDestinationFile(file6, file3, file2);
                                if (!file6.exists()) continue;
                                if (file6.renameTo(file7)) {
                                    linkedList.addFirst(new Duo<File, File>(file6, file7));
                                    continue;
                                }
                                if (file7.exists()) {
                                    if (!file6.isDirectory()) {
                                        throw new FileAlreadyExistsException(file7.getPath());
                                    }
                                    if (file7.isDirectory()) continue;
                                    throw new FileAlreadyExistsException(file7.getPath());
                                }
                                if (!file6.isDirectory()) {
                                    FileOperation.copyFile(file6, file7);
                                } else if (!file7.mkdir()) {
                                    throw new IOException(file2.getPath());
                                }
                                linkedList.addFirst(new Duo<Object, File>(null, file7));
                            }
                            bl = true;
                            break block43;
                        }
                        catch (Throwable throwable) {
                            Object var11_10 = null;
                            if (!bl) {
                                for (Duo duo : linkedList) {
                                    if (duo.getFirst() == null) {
                                        ((File)duo.getSecond()).delete();
                                        continue;
                                    }
                                    ((File)duo.getSecond()).renameTo((File)duo.getFirst());
                                }
                                if (file3 != null) {
                                    file3.renameTo(file);
                                }
                                if (file5 != null) {
                                    FileOperation.deleteInner(file5);
                                }
                            }
                            if (file4 == null) throw throwable;
                            FileOperation.deleteInner(file4);
                            throw throwable;
                        }
                    }
                    for (Duo duo : linkedList) {
                        if (duo.getFirst() == null) {
                            ((File)duo.getSecond()).delete();
                            continue;
                        }
                        ((File)duo.getSecond()).renameTo((File)duo.getFirst());
                    }
                    if (file3 != null) {
                        file3.renameTo(file);
                    }
                    if (file5 != null) {
                        FileOperation.deleteInner(file5);
                    }
                }
                if (file4 == null) return;
                FileOperation.deleteInner(file4);
                return;
            }
            Object var11_8 = null;
            if (!bl) {
                for (Duo duo : linkedList) {
                    if (duo.getFirst() == null) {
                        ((File)duo.getSecond()).delete();
                        continue;
                    }
                    ((File)duo.getSecond()).renameTo((File)duo.getFirst());
                }
                if (file3 != null) {
                    file3.renameTo(file);
                }
                if (file5 != null) {
                    FileOperation.deleteInner(file5);
                }
            }
            if (file4 == null) return;
            FileOperation.deleteInner(file4);
            return;
        }
        Object var11_9 = null;
        if (!bl) {
            for (Duo duo : linkedList) {
                if (duo.getFirst() == null) {
                    ((File)duo.getSecond()).delete();
                    continue;
                }
                ((File)duo.getSecond()).renameTo((File)duo.getFirst());
            }
            if (file3 != null) {
                file3.renameTo(file);
            }
            if (file5 != null) {
                FileOperation.deleteInner(file5);
            }
        }
        if (file4 == null) return;
        FileOperation.deleteInner(file4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveInner(File file, File file2, FileFilter fileFilter) throws IOException {
        File file3;
        block28: {
            assert (file != null) : "@param:src is null.";
            assert (file2 != null) : "@param:dst is null.";
            assert (fileFilter != null) : "@param:filter is null.";
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (fileFilter.accept(file)) {
                FileOperation.moveInner(file, file2);
                return;
            }
            boolean bl = false;
            File file4 = FileOperation.createDir(file2.getParentFile());
            file3 = null;
            File file5 = null;
            LinkedList<Duo<File, File>> linkedList = new LinkedList<Duo<File, File>>();
            try {
                File file6;
                List<File> list = FileOperation.listRecursive(file, fileFilter);
                file3 = FileOperation.createTempDirectory("._mov", "", file.getParentFile());
                file5 = new File(file3, file.getName());
                for (File file7 : list) {
                    if (!file7.exists()) continue;
                    file6 = FileOperation.getDestinationFile(file7, file, file5);
                    FileOperation.createDir(file6.getParentFile());
                    if (!file7.renameTo(file6)) {
                        throw new IOException(file7.getPath());
                    }
                    linkedList.addFirst(new Duo<File, File>(file7, file6));
                }
                for (File file7 : FileOperation.listInner(file5, new LinkedList<File>())) {
                    file6 = FileOperation.getDestinationFile(file7, file5, file2);
                    if (!file7.exists()) continue;
                    File file8 = FileOperation.createDir(file6.getParentFile());
                    if (file8 != null) {
                        linkedList.addFirst(new Duo<Object, File>(null, file8));
                    }
                    if (file7.renameTo(file6)) {
                        linkedList.addFirst(new Duo<File, File>(file7, file6));
                        continue;
                    }
                    if (file6.exists()) {
                        if (!file7.isDirectory()) {
                            throw new FileAlreadyExistsException(file6.getPath());
                        }
                        if (file6.isDirectory()) continue;
                        throw new FileAlreadyExistsException(file6.getPath());
                    }
                    if (!file7.isDirectory()) {
                        FileOperation.copyFile(file7, file6);
                    } else if (!file6.mkdir()) {
                        throw new IOException(file2.getPath());
                    }
                    linkedList.addFirst(new Duo<Object, File>(null, file6));
                }
                bl = true;
                Object var14_13 = null;
                if (bl) break block28;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (!bl) {
                    for (Duo duo : linkedList) {
                        if (duo.getFirst() == null) {
                            ((File)duo.getSecond()).delete();
                            continue;
                        }
                        ((File)duo.getSecond()).renameTo((File)duo.getFirst());
                    }
                    if (file5 != null) {
                        file5.renameTo(file);
                    }
                    if (file4 != null) {
                        FileOperation.deleteInner(file4);
                    }
                }
                if (file3 != null) {
                    FileOperation.deleteInner(file3);
                }
                throw throwable;
            }
            for (Duo duo : linkedList) {
                if (duo.getFirst() == null) {
                    ((File)duo.getSecond()).delete();
                    continue;
                }
                ((File)duo.getSecond()).renameTo((File)duo.getFirst());
            }
            if (file5 != null) {
                file5.renameTo(file);
            }
            if (file4 != null) {
                FileOperation.deleteInner(file4);
            }
        }
        if (file3 != null) {
            FileOperation.deleteInner(file3);
        }
    }

    private static void checkFailureReason(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (file2.exists()) {
            if (file.isDirectory() != file2.isDirectory()) {
                throw new FileAlreadyExistsException(file2.getPath());
            }
            if (!file.isDirectory()) {
                throw new FileAlreadyExistsException(file2.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        assert (!file.isDirectory()) : "@param:src is a directory.";
        boolean bl = !file2.exists();
        boolean bl2 = false;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            bl2 = true;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (!bl2 && bl) {
                file2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyInner(File file, File file2) throws IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        FileOperation.checkFailureReason(file, file2);
        boolean bl = false;
        LinkedList<File> linkedList = new LinkedList<File>();
        File file3 = null;
        try {
            file3 = FileOperation.createDir(file2.getParentFile());
            LinkedList<File> linkedList2 = new LinkedList<File>();
            linkedList2.add(file);
            if (file.isDirectory()) {
                FileOperation.listInner(file, linkedList2);
            }
            Iterator object = linkedList2.iterator();
            while (object.hasNext()) {
                File file4 = (File)object.next();
                File file5 = FileOperation.getDestinationFile(file4, file, file2);
                FileOperation.checkFailureReason(file4, file5);
                if (!file4.isDirectory()) {
                    FileOperation.copyFile(file4, file5);
                    linkedList.addFirst(file5);
                    continue;
                }
                if (file5.exists()) continue;
                file5.mkdir();
                linkedList.addFirst(file5);
            }
            bl = true;
        }
        finally {
            if (!bl) {
                if (file3 != null) {
                    FileOperation.deleteInner(file3);
                } else {
                    for (File file6 : linkedList) {
                        file6.delete();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyInner(File file, File file2, FileFilter fileFilter) throws IOException {
        assert (file != null) : "@param:src is null.";
        assert (file2 != null) : "@param:dst is null.";
        assert (fileFilter != null) : "@param:filter is null.";
        FileOperation.checkFailureReason(file, file2);
        boolean bl = false;
        LinkedList<File> linkedList = new LinkedList<File>();
        try {
            LinkedList<File> linkedList2 = new LinkedList<File>();
            linkedList2.add(file);
            if (file.isDirectory()) {
                FileOperation.listInner(file, linkedList2);
            }
            Iterator object = linkedList2.iterator();
            while (object.hasNext()) {
                File file3;
                File file4 = (File)object.next();
                if (!fileFilter.accept(file4)) continue;
                File file5 = FileOperation.getDestinationFile(file4, file, file2);
                FileOperation.checkFailureReason(file4, file5);
                if (!file4.isDirectory()) {
                    file3 = FileOperation.createDir(file5.getParentFile());
                    if (file3 != null) {
                        linkedList.addFirst(file3);
                    }
                    FileOperation.copyFile(file4, file5);
                    linkedList.addFirst(file5);
                    continue;
                }
                if (file5.exists() || (file3 = FileOperation.createDir(file5)) == null) continue;
                linkedList.addFirst(file3);
            }
            bl = true;
        }
        finally {
            if (!bl) {
                for (File file6 : linkedList) {
                    if (!file6.exists()) continue;
                    FileOperation.deleteInner(file6);
                }
            }
        }
    }
}

