/*
 * Decompiled with CFR 0.152.
 */
package ts.util.lifetime;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ts.util.lifetime.Life;
import ts.util.lifetime.PeriodicEventfulLife;
import ts.util.lifetime.ScheduledEventfulLife;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lifetime {
    private List<Life> lifeLst_;
    private Timer lifeTimer_ = new Timer(true);

    public Lifetime() {
        this.lifeLst_ = this.createLifeList();
    }

    protected List<Life> createLifeList() {
        return new LinkedList<Life>();
    }

    private Method getLifeMethod(Life life, String string) {
        try {
            return life.getClass().getMethod(string, new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void add(Life life) {
        assert (life != null) : "@param:life is null.";
        this.lifeLst_.add(life);
        try {
            life.wasBorn();
        }
        catch (Exception exception) {
            this.catchException(exception, life, this.getLifeMethod(life, "wasBorn"));
        }
        if (life instanceof PeriodicEventfulLife) {
            this.setupPeriodicEvent((PeriodicEventfulLife)PeriodicEventfulLife.class.cast(life));
        } else if (life instanceof ScheduledEventfulLife) {
            this.setupScheduledEvent((ScheduledEventfulLife)ScheduledEventfulLife.class.cast(life));
        }
    }

    protected void setupScheduledEvent(ScheduledEventfulLife scheduledEventfulLife) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ScheduleThread
        extends Thread {
            final /* synthetic */ ScheduledEventfulLife val$life;

            ScheduleThread() {
                this.val$life = scheduledEventfulLife;
            }

            @Override
            public void run() {
                try {
                    Date date = null;
                    try {
                        date = this.val$life.getNextTime();
                    }
                    catch (Exception exception) {
                        Lifetime.this.catchException(exception, this.val$life, Lifetime.this.getLifeMethod(this.val$life, "getNextTime"));
                        throw exception;
                    }
                    if (date.getTime() > System.currentTimeMillis()) {
                        TimerTask timerTask = new TimerTask(){

                            public void run() {
                                try {
                                    val$life.happens();
                                }
                                catch (Exception exception) {
                                    Lifetime.this.catchException(exception, val$life, Lifetime.this.getLifeMethod(val$life, "happens"));
                                }
                                new ScheduleThread(Lifetime.this, val$life).start();
                            }
                        };
                        Lifetime.this.lifeTimer_.schedule(timerTask, date);
                    }
                }
                catch (Exception exception) {
                    new ScheduleThread().start();
                }
            }
        }
        new ScheduleThread().start();
    }

    protected void setupPeriodicEvent(final PeriodicEventfulLife periodicEventfulLife) {
        long l = periodicEventfulLife.getInterval();
        if (l > 0L) {
            try {
                TimerTask timerTask = new TimerTask(){

                    public void run() {
                        try {
                            periodicEventfulLife.happens();
                        }
                        catch (Exception exception) {
                            Lifetime.this.catchException(exception, periodicEventfulLife, Lifetime.this.getLifeMethod(periodicEventfulLife, "happens"));
                        }
                    }
                };
                this.lifeTimer_.schedule(timerTask, 0L, l);
            }
            catch (RuntimeException runtimeException) {
                this.setupPeriodicEvent(periodicEventfulLife);
            }
        }
    }

    protected synchronized void kill() {
        this.lifeTimer_.cancel();
        this.lifeTimer_ = new Timer(true);
        for (Life life : this.lifeLst_) {
            try {
                life.willDie();
            }
            catch (Exception exception) {
                this.catchException(exception, life, this.getLifeMethod(life, "willDie"));
            }
        }
        while (!this.lifeLst_.isEmpty()) {
            this.lifeLst_.remove(0);
        }
    }

    protected void catchException(Exception exception, Life life, Method method) {
    }

    protected Enumeration<Life> enumeration() {
        return Collections.enumeration(this.lifeLst_);
    }

    protected void finalize() throws Throwable {
        this.kill();
        super.finalize();
    }
}

