/*
 * Decompiled with CFR 0.152.
 */
package ts.util.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ts.util.table.Header;
import ts.util.table.Index;
import ts.util.table.MapComparator;
import ts.util.table.MapIterator;
import ts.util.table.Record;
import ts.util.table.Table;
import ts.util.table.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTable<C, V>
implements Table<C, V>,
Cloneable,
Serializable {
    static final long serialVersionUID = 1469325734478989265L;
    private Header<C> header_;
    private Collection<Record<C, V>> recordCollection_;
    private Map<LinkedHashSet<C>, Index<C, V>> indexMap_ = new HashMap<LinkedHashSet<C>, Index<C, V>>();
    private List<Trigger<C, V>> triggerLst_ = new LinkedList<Trigger<C, V>>();

    public AbstractTable() {
        this(16, 0);
    }

    public AbstractTable(int n, int n2) {
        assert (n >= 0) : "@param:initRecCapacity is negative.";
        assert (n2 >= 0) : "@param:initColCapacity is negative.";
        this.header_ = this.createHeader(n2);
        this.recordCollection_ = this.createRecordCollection(n < 0 ? 0 : n);
    }

    protected AbstractTable(Header<C> header) {
        assert (header != null) : "@param:header is null.";
        this.header_ = header;
        this.recordCollection_ = this.createRecordCollection(10);
    }

    protected Header<C> header() {
        return this.header_;
    }

    @Override
    public int columnCount() {
        return this.header_.columnCount();
    }

    @Override
    public int recordCount() {
        return this.recordCollection_.size();
    }

    @Override
    public Enumeration<C> columns() {
        return this.header_.columns();
    }

    @Override
    public MapIterator<C, V> records() {
        return new MapIterator<C, V>(){
            private Iterator<Record<C, V>> it_;
            {
                this.it_ = AbstractTable.this.recordCollection_.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it_.hasNext();
            }

            @Override
            public Map<C, V> next() {
                return this.it_.next();
            }

            @Override
            public void remove() {
                this.it_.remove();
            }
        };
    }

    @Override
    public MapIterator<C, V> records(MapComparator<C, V> mapComparator) {
        assert (mapComparator != null) : "@param:comparator is null.";
        final LinkedList<Record<C, V>> linkedList = new LinkedList<Record<C, V>>(this.recordCollection_);
        Collections.sort(linkedList, mapComparator);
        return new MapIterator<C, V>(){
            private Iterator<Map<C, V>> it_;
            private Object rec_;
            {
                this.it_ = linkedList.iterator();
                this.rec_ = this;
            }

            @Override
            public boolean hasNext() {
                return this.it_.hasNext();
            }

            @Override
            public Map<C, V> next() {
                Map map;
                this.rec_ = map = this.it_.next();
                return map;
            }

            @Override
            public void remove() {
                this.it_.remove();
                AbstractTable.this.recordCollection_.remove(this.rec_);
            }
        };
    }

    @Override
    public Map<C, V> recordFirst() {
        if (this.recordCollection_.size() > 0) {
            return this.recordCollection_.iterator().next();
        }
        return null;
    }

    @Override
    public Map<C, V> appendNew() {
        return this.appendNew(this.header_.columnCount());
    }

    @Override
    public Map<C, V> appendNew(int n) {
        assert (n >= 0) : "@param:initColCapacity is negative.";
        IndexAndTriggerSupportRecord indexAndTriggerSupportRecord = new IndexAndTriggerSupportRecord(this.createRecord(n));
        ArrayList arrayList = null;
        if (this.triggerLst_.size() > 0) {
            arrayList = new ArrayList(this.triggerLst_.size());
            for (Trigger object : this.triggerLst_) {
                Trigger trigger = object.createClone();
                trigger.preAppend(this, indexAndTriggerSupportRecord);
                arrayList.add(trigger);
            }
        }
        this.recordCollection_.add(indexAndTriggerSupportRecord);
        if (arrayList != null) {
            for (Trigger trigger : arrayList) {
                trigger.postAppend(this, indexAndTriggerSupportRecord);
            }
        }
        for (Index index : this.indexMap_.values()) {
            index.getIndexedCollectionByForce(indexAndTriggerSupportRecord).add(indexAndTriggerSupportRecord);
        }
        return indexAndTriggerSupportRecord;
    }

    @Override
    public void deleteAll() {
        Collection collection = Collections.unmodifiableCollection(this.recordCollection_);
        ArrayList arrayList = null;
        if (this.triggerLst_.size() > 0) {
            arrayList = new ArrayList(this.triggerLst_.size());
            for (Trigger object : this.triggerLst_) {
                Trigger trigger = object.createClone();
                trigger.preDeleteAll(this, collection);
                arrayList.add(trigger);
            }
        }
        this.recordCollection_ = this.createRecordCollection(16);
        if (arrayList != null) {
            for (Trigger trigger : arrayList) {
                trigger.postDeleteAll(this, collection);
            }
        }
        for (Index index : this.indexMap_.values()) {
            index.deleteAllRecordsFromIndex();
        }
    }

    @Override
    public boolean exists(C c, V v) {
        HashMap<C, V> hashMap = new HashMap<C, V>();
        hashMap.put(c, v);
        return this.exists(hashMap);
    }

    @Override
    public boolean exists(Map<C, V> map) {
        assert (map != null) : "@param:condition is null.";
        return this.existsInCollection(this.recordCollection_, map);
    }

    protected boolean existsInCollection(Collection<Record<C, V>> collection, Map<C, V> map) {
        assert (collection != null) : "@param:coll is null.";
        assert (map != null) : "@param:condition is null.";
        for (Record<C, V> record : collection) {
            if (!record.satisfyCondition(map)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<C, V> selectFirst(C c, V v) {
        HashMap<C, V> hashMap = new HashMap<C, V>();
        hashMap.put(c, v);
        return this.selectFirst(hashMap);
    }

    @Override
    public Map<C, V> selectFirst(Map<C, V> map) {
        assert (map != null) : "@param:condition is null.";
        return this.selectFirstFromCollection(this.recordCollection_, map);
    }

    protected Map<C, V> selectFirstFromCollection(Collection<Record<C, V>> collection, Map<C, V> map) {
        assert (collection != null) : "@param:coll is null.";
        assert (map != null) : "@param:condition is null.";
        for (Record<C, V> record : collection) {
            if (!record.satisfyCondition(map)) continue;
            return record;
        }
        return null;
    }

    @Override
    public List<Map<C, V>> select(C c, V v) {
        HashMap<C, V> hashMap = new HashMap<C, V>();
        hashMap.put(c, v);
        return this.select(hashMap);
    }

    @Override
    public List<Map<C, V>> select(Map<C, V> map) {
        assert (map != null) : "@param:condition is null.";
        return this.selectFromCollection(this.recordCollection_, map);
    }

    protected List<Map<C, V>> selectFromCollection(Collection<Record<C, V>> collection, Map<C, V> map) {
        assert (collection != null) : "@param:coll is null.";
        assert (map != null) : "@param:condition is null.";
        LinkedList<Map<C, V>> linkedList = new LinkedList<Map<C, V>>();
        for (Record<C, V> record : collection) {
            if (!record.satisfyCondition(map)) continue;
            linkedList.add(record);
        }
        return linkedList;
    }

    @Override
    public List<Map<C, V>> delete(Map<C, V> map) {
        assert (map != null) : "@param:condition is null.";
        return this.deleteFromCollection(this.recordCollection_, map);
    }

    protected List<Map<C, V>> deleteFromCollection(Collection<Record<C, V>> collection, Map<C, V> map) {
        assert (collection != null) : "@param:coll is null.";
        assert (map != null) : "@param:condition is null.";
        LinkedList<Map<C, V>> linkedList = new LinkedList<Map<C, V>>();
        Iterator<Record<C, V>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Record<C, V> record = iterator.next();
            if (!record.satisfyCondition(map)) continue;
            ArrayList<Trigger<C, V>> arrayList = null;
            if (this.triggerLst_.size() > 0) {
                arrayList = new ArrayList<Trigger<C, V>>(this.triggerLst_.size());
                for (Trigger<C, V> trigger : this.triggerLst_) {
                    Trigger<C, V> trigger2 = trigger.createClone();
                    trigger2.preDelete(this, record);
                    arrayList.add(trigger2);
                }
            }
            if (collection == this.recordCollection_) {
                iterator.remove();
            } else {
                this.recordCollection_.remove(record);
            }
            linkedList.add(record);
            if (arrayList != null) {
                for (Trigger trigger : arrayList) {
                    trigger.postDelete(this, record);
                }
            }
            for (Index index : this.indexMap_.values()) {
                index.getIndexedCollection(record).remove(record);
            }
        }
        return linkedList;
    }

    @Override
    public List<Map<C, V>> update(Map<C, V> map, Map<C, V> map2) {
        assert (map != null) : "@param:condition is null.";
        assert (map2 != null) : "@param:destination is null.";
        return this.updateInCollection(this.recordCollection_, map, map2);
    }

    protected List<Map<C, V>> updateInCollection(Collection<Record<C, V>> collection, Map<C, V> map, Map<C, V> map2) {
        assert (collection != null) : "@param:coll is null.";
        assert (map != null) : "@param:condition is null.";
        assert (map2 != null) : "@param:destination is null.";
        LinkedList<Map<C, V>> linkedList = new LinkedList<Map<C, V>>();
        for (Record<C, V> record : collection) {
            if (!record.satisfyCondition(map)) continue;
            record.putAll(map2);
            linkedList.add(record);
        }
        return linkedList;
    }

    @Override
    public Index<C, V> getIndex(C ... CArray) {
        assert (CArray != null) : "@param:indexKeys is null";
        if (CArray.length == 0) {
            throw new IllegalArgumentException("indexKeys is an empty array.");
        }
        LinkedHashSet<C> linkedHashSet = new LinkedHashSet<C>();
        for (C object : CArray) {
            linkedHashSet.add(object);
        }
        C[] CArray2 = this._cast_to_columns(linkedHashSet.toArray(new Object[linkedHashSet.size()]));
        AbstractTableIndex abstractTableIndex = this.indexMap_.get(linkedHashSet);
        if (abstractTableIndex == null) {
            abstractTableIndex = new AbstractTableIndex(CArray2);
            this.indexMap_.put(linkedHashSet, abstractTableIndex);
            for (Record<C, V> record : this.recordCollection_) {
                abstractTableIndex.getIndexedCollectionByForce(record).add(record);
            }
        }
        return abstractTableIndex;
    }

    @Override
    public void addTrigger(Trigger<C, V> trigger) {
        assert (trigger != null) : "@param:trigger is null.";
        this.triggerLst_.add(trigger);
    }

    protected abstract Header<C> createHeader(int var1);

    protected abstract Collection<Record<C, V>> createRecordCollection(int var1);

    protected abstract Record<C, V> createRecord(int var1);

    private Map<C, V> _cast_to_map(Object object) {
        return (Map)object;
    }

    private C _cast_to_column(Object object) {
        return (C)object;
    }

    private C[] _cast_to_columns(Object[] objectArray) {
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AbstractTableIndex
    extends Index<C, V> {
        protected AbstractTableIndex(C[] CArray) {
            super(CArray);
        }

        @Override
        protected Table<C, V> getBaseTable() {
            return AbstractTable.this;
        }

        @Override
        public boolean exists(Map<C, V> map) {
            return AbstractTable.this.existsInCollection(this.collectRecords(map), map);
        }

        @Override
        public Map<C, V> selectFirst(Map<C, V> map) {
            return AbstractTable.this.selectFirstFromCollection(this.collectRecords(map), map);
        }

        @Override
        public List<Map<C, V>> select(Map<C, V> map) {
            return AbstractTable.this.selectFromCollection(this.collectRecords(map), map);
        }

        @Override
        public List<Map<C, V>> delete(Map<C, V> map) {
            return AbstractTable.this.deleteFromCollection(this.collectRecords(map), map);
        }

        @Override
        public List<Map<C, V>> update(Map<C, V> map, Map<C, V> map2) {
            return AbstractTable.this.updateInCollection(this.collectRecords(map), map, map2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IndexAndTriggerSupportRecord
    extends Record<C, V> {
        static final long serialVersionUID = 7787001267275530819L;
        private Record<C, V> record_;

        public IndexAndTriggerSupportRecord(Record<C, V> record) {
            assert (record != null) : "@param:record is null.";
            this.record_ = record;
        }

        @Override
        public Header<C> header() {
            return this.record_.header();
        }

        @Override
        public int size() {
            return this.record_.size();
        }

        @Override
        public boolean isEmpty() {
            return this.record_.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.record_.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.record_.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.record_.get(object);
        }

        @Override
        protected V getValue(Object object) {
            return this.record_.getValue(object);
        }

        @Override
        protected V putValue(C c, V v) {
            return this.record_.putValue(c, v);
        }

        @Override
        protected V removeValue(Object object) {
            return this.record_.removeValue(object);
        }

        @Override
        public V put(C c, V v) {
            Object object;
            Trigger trigger2;
            Object object22;
            for (Object object22 : AbstractTable.this.indexMap_.values()) {
                ((Index)object22).getIndexedCollection(this).remove(this);
            }
            Object object3 = null;
            object22 = null;
            if (AbstractTable.this.triggerLst_.size() > 0) {
                object22 = new HashMap();
                object22.put(c, v);
                object3 = new ArrayList(AbstractTable.this.triggerLst_.size());
                for (Object object4 : AbstractTable.this.triggerLst_) {
                    trigger2 = ((Trigger)object4).createClone();
                    trigger2.preUpdate(AbstractTable.this, this.record_, (Map)object22);
                    object3.add(trigger2);
                }
            }
            if (object22 != null && object22.size() > 1) {
                object = this.record_.get(c);
                this.record_.putAll((Map)object22);
            } else {
                object = this.record_.put(c, v);
            }
            if (object3 != null) {
                Object object4;
                object4 = object3.iterator();
                while (object4.hasNext()) {
                    trigger2 = (Trigger)object4.next();
                    trigger2.postUpdate(AbstractTable.this, this.record_, (Map)object22);
                }
            }
            for (Trigger trigger2 : AbstractTable.this.indexMap_.values()) {
                ((Index)((Object)trigger2)).getIndexedCollectionByForce(this).add(this);
            }
            return object;
        }

        @Override
        public V remove(Object object) {
            Iterator iterator;
            if (!this.record_.containsKey(object)) {
                return null;
            }
            for (Iterator iterator2 : AbstractTable.this.indexMap_.values()) {
                ((Index)((Object)iterator2)).getIndexedCollection(this).remove(this);
            }
            if (AbstractTable.this.triggerLst_.size() > 0) {
                Iterator iterator2;
                iterator2 = AbstractTable.this._cast_to_column(object);
                Object object2 = new HashMap();
                object2.put(iterator2, null);
                ArrayList arrayList = new ArrayList(AbstractTable.this.triggerLst_.size());
                for (Trigger trigger : AbstractTable.this.triggerLst_) {
                    Trigger trigger2 = trigger.createClone();
                    trigger2.preUpdate(AbstractTable.this, this.record_, (Map)object2);
                    arrayList.add(trigger2);
                }
                iterator = this.record_.remove(object);
                if (object2.size() > 1) {
                    this.record_.putAll((Map)object2);
                }
                for (Trigger trigger : arrayList) {
                    trigger.postUpdate(AbstractTable.this, this.record_, object2);
                }
            } else {
                iterator = this.record_.remove(object);
            }
            for (Object object2 : AbstractTable.this.indexMap_.values()) {
                ((Index)object2).getIndexedCollectionByForce(this).add(this);
            }
            return iterator;
        }

        @Override
        public void putAll(Map<? extends C, ? extends V> map) {
            Object object2;
            for (Object object2 : AbstractTable.this.indexMap_.values()) {
                ((Index)object2).getIndexedCollection(this).remove(this);
            }
            Map map2 = AbstractTable.this._cast_to_map(map);
            object2 = null;
            if (AbstractTable.this.triggerLst_.size() > 0) {
                object2 = new ArrayList(AbstractTable.this.triggerLst_.size());
                for (Object object3 : AbstractTable.this.triggerLst_) {
                    Trigger trigger = ((Trigger)object3).createClone();
                    trigger.preUpdate(AbstractTable.this, this.record_, map2);
                    object2.add(trigger);
                }
            }
            this.record_.putAll(map);
            if (object2 != null) {
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object object3;
                    object3 = (Trigger)iterator.next();
                    ((Trigger)object3).postUpdate(AbstractTable.this, this.record_, map2);
                }
            }
            for (Object object3 : AbstractTable.this.indexMap_.values()) {
                ((Index)object3).getIndexedCollectionByForce(this).add(this);
            }
        }

        @Override
        public void clear() {
            for (Object object : AbstractTable.this.indexMap_.values()) {
                ((Index)object).getIndexedCollection(this).remove(this);
            }
            if (AbstractTable.this.triggerLst_.size() > 0) {
                Object object;
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class _ClearMap
                extends Record<C, V> {
                    private Header<C> header_ = new 1_ClearMap._ClearMapHeader();
                    private Map<C, V> map_ = new HashMap();
                    private boolean modified_ = false;

                    _ClearMap() {
                    }

                    @Override
                    protected Header<C> header() {
                        return this.header_;
                    }

                    @Override
                    protected V getValue(Object object) {
                        return this.map_.get(object);
                    }

                    @Override
                    protected V putValue(C c, V v) {
                        this.modified_ = true;
                        return this.map_.put(c, v);
                    }

                    @Override
                    protected V removeValue(Object object) {
                        this.modified_ = true;
                        return this.map_.remove(object);
                    }

                    boolean isModified() {
                        return this.modified_;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class 1_ClearMap._ClearMapHeader
                    implements Header<C> {
                        private Header<C> base_;

                        1_ClearMap._ClearMapHeader() {
                            this.base_ = AbstractTable.this.header();
                        }

                        @Override
                        public int columnCount() {
                            return this.base_.columnCount();
                        }

                        @Override
                        public Enumeration<C> columns() {
                            return this.base_.columns();
                        }

                        @Override
                        public boolean hasColumn(Object object) {
                            return this.base_.hasColumn(object);
                        }

                        @Override
                        public void addColumn(C c) {
                            if (this.base_.hasColumn(c)) {
                                return;
                            }
                            if (this.base_ == AbstractTable.this.header()) {
                                this.base_ = new 1_ClearMap._MutableClearMapHeader(this.base_);
                            }
                            this.base_.addColumn(c);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class 1_ClearMap._MutableClearMapHeader
                    implements Header<C> {
                        private Set<C> set_ = new HashSet();

                        1_ClearMap._MutableClearMapHeader(Header<C> header) {
                            Enumeration enumeration = header.columns();
                            while (enumeration.hasMoreElements()) {
                                this.set_.add(enumeration.nextElement());
                            }
                        }

                        @Override
                        public int columnCount() {
                            return this.set_.size();
                        }

                        @Override
                        public Enumeration<C> columns() {
                            return Collections.enumeration(this.set_);
                        }

                        @Override
                        public boolean hasColumn(Object object) {
                            return this.set_.contains(object);
                        }

                        @Override
                        public void addColumn(C c) {
                            this.set_.add(c);
                        }
                    }
                }
                Iterator iterator = new _ClearMap();
                object = new ArrayList(AbstractTable.this.triggerLst_.size());
                for (Trigger trigger : AbstractTable.this.triggerLst_) {
                    Trigger trigger2 = trigger.createClone();
                    trigger2.preUpdate(AbstractTable.this, this.record_, AbstractTable.this._cast_to_map(iterator));
                    object.add(trigger2);
                }
                this.record_.clear();
                if (((_ClearMap)((Object)iterator)).isModified()) {
                    this.record_.putAll(AbstractTable.this._cast_to_map(iterator));
                }
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Trigger trigger;
                    trigger = (Trigger)iterator2.next();
                    trigger.postUpdate(AbstractTable.this, this.record_, AbstractTable.this._cast_to_map(iterator));
                }
            } else {
                this.record_.clear();
            }
            for (Object object : AbstractTable.this.indexMap_.values()) {
                ((Index)object).getIndexedCollectionByForce(this).add(this);
            }
        }

        @Override
        public Set<C> keySet() {
            return this.record_.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.record_.values();
        }

        @Override
        public Set<Map.Entry<C, V>> entrySet() {
            return this.record_.entrySet();
        }
    }
}

