/*
 * Decompiled with CFR 0.152.
 */
package ts.util.table;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ts.util.table.AbstractTable;
import ts.util.table.Header;
import ts.util.table.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListTable<C, V>
extends AbstractTable<C, V> {
    static final long serialVersionUID = 1940969047348687437L;

    public ArrayListTable() {
    }

    public ArrayListTable(int n, int n2) {
        super(n, n2);
    }

    protected ArrayListTable(Header<C> header) {
        super(header);
    }

    @Override
    protected Header<C> createHeader(int n) {
        return new ArrayListTableHeader(n);
    }

    @Override
    protected Collection<Record<C, V>> createRecordCollection(int n) {
        assert (n >= 0) : "@param:initRecCapacity is negative.";
        return new LinkedList<Record<C, V>>();
    }

    @Override
    protected Record<C, V> createRecord(int n) {
        assert (n >= 0) : "@param:initColCapacity is negative.";
        return new ArrayListTableRecord(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArrayListTableRecord
    extends Record<C, V> {
        static final long serialVersionUID = 4663048964389775476L;
        private V[] values_;

        public ArrayListTableRecord(int n) {
            assert (n >= 0) : "@param:size is negative.";
            this.values_ = this.newValue(n);
        }

        private V[] newValue(int n) {
            return new Object[n < 0 ? 0 : n];
        }

        @Override
        protected Header<C> header() {
            return ArrayListTable.this.header();
        }

        private ArrayListTableHeader altHeader() {
            return (ArrayListTableHeader)this.header();
        }

        @Override
        public boolean containsValue(Object object) {
            if (object == null) {
                if (this.size() > this.values_.length) {
                    return true;
                }
                for (int i = 0; i < this.size(); ++i) {
                    if (this.values_[i] != null) continue;
                    return true;
                }
            } else {
                int n = Math.min(this.size(), this.values_.length);
                for (int i = 0; i < n; ++i) {
                    if (!object.equals(this.values_[i])) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected V getValue(Object object) {
            try {
                return this.values_[this.altHeader().getArrayIndexForColumn(object)];
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        protected V putValue(C c, V v) {
            Object object;
            int n = this.altHeader().addArrayIndexForColumn(c);
            if (n >= this.values_.length) {
                object = new Object[n + 10];
                System.arraycopy(this.values_, 0, object, 0, this.values_.length);
                this.values_ = object;
            }
            object = this.values_[n];
            this.values_[n] = v;
            return object;
        }

        @Override
        protected V removeValue(Object object) {
            try {
                int n = this.altHeader().getArrayIndexForColumn(object);
                Object v = this.values_[n];
                this.values_[n] = null;
                return v;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public void clear() {
            Arrays.fill(this.values_, null);
        }

        @Override
        public Collection<V> values() {
            return new AbstractCollection<V>(){

                @Override
                public int size() {
                    return ArrayListTableRecord.this.header().columnCount();
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private int index_ = -1;

                        @Override
                        public boolean hasNext() {
                            return this.index_ + 1 < this.size();
                        }

                        @Override
                        public V next() {
                            ++this.index_;
                            if (this.index_ >= this.size()) {
                                throw new NoSuchElementException();
                            }
                            if (this.index_ < ArrayListTableRecord.this.values_.length) {
                                return ArrayListTableRecord.this.values_[this.index_];
                            }
                            return null;
                        }

                        @Override
                        public void remove() {
                            if (this.index_ < 0) {
                                throw new IllegalStateException();
                            }
                            if (this.index_ >= this.size()) {
                                throw new NoSuchElementException();
                            }
                            if (this.index_ < ArrayListTableRecord.this.values_.length) {
                                ((ArrayListTableRecord)ArrayListTableRecord.this).values_[this.index_] = null;
                            }
                        }
                    };
                }
            };
        }

        @Override
        public Set<Map.Entry<C, V>> entrySet() {
            return new AbstractSet<Map.Entry<C, V>>(){

                @Override
                public int size() {
                    return ArrayListTableRecord.this.header().columnCount();
                }

                @Override
                public Iterator<Map.Entry<C, V>> iterator() {
                    return new Iterator<Map.Entry<C, V>>(){
                        private int index_ = -1;
                        private Iterator<Map.Entry<C, Integer>> it;
                        {
                            this.it = ArrayListTableRecord.this.altHeader().columnMap_.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public Map.Entry<C, V> next() {
                            Map.Entry entry = this.it.next();
                            this.index_ = entry.getValue();
                            if (0 <= this.index_ && this.index_ < ArrayListTableRecord.this.values_.length) {
                                return new Record.SimpleEntry(entry.getKey(), ArrayListTableRecord.this.values_[this.index_]);
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            if (this.index_ < 0) {
                                throw new IllegalStateException();
                            }
                            if (this.index_ >= this.size()) {
                                throw new NoSuchElementException();
                            }
                            if (this.index_ < ArrayListTableRecord.this.values_.length) {
                                ((ArrayListTableRecord)ArrayListTableRecord.this).values_[this.index_] = null;
                            }
                        }
                    };
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArrayListTableHeader
    implements Header<C>,
    Serializable {
        static final long serialVersionUID = -114778725908464738L;
        private HashMap<C, Integer> columnMap_;
        private int maxArrayIndex_ = -1;

        public ArrayListTableHeader(int n) {
            assert (n >= 0) : "@param:initColCapacity is negative.";
            this.columnMap_ = new HashMap(n);
        }

        @Override
        public int columnCount() {
            return this.columnMap_.size();
        }

        @Override
        public Enumeration<C> columns() {
            return Collections.enumeration(this.columnMap_.keySet());
        }

        @Override
        public boolean hasColumn(Object object) {
            return this.columnMap_.containsKey(object);
        }

        @Override
        public void addColumn(C c) {
            this.addArrayIndexForColumn(c);
        }

        protected int getArrayIndexForColumn(Object object) {
            Integer n = this.columnMap_.get(object);
            return n == null ? -1 : n;
        }

        protected int addArrayIndexForColumn(C c) {
            Integer n = this.columnMap_.get(c);
            if (n != null) {
                return n;
            }
            ++this.maxArrayIndex_;
            this.columnMap_.put(c, this.maxArrayIndex_);
            return this.maxArrayIndex_;
        }
    }
}

