/*
 * Decompiled with CFR 0.152.
 */
package ts.util.text;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import ts.util.text.StringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConcatenator {
    protected StringConcatenator() {
    }

    public static String concatenate(String[] stringArray, String string) {
        assert (stringArray != null) : "@param:strings is null.";
        assert (string != null) : "@param:delimiter is null.";
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(string).append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public static String concatenate(Enumeration<String> enumeration, String string) {
        assert (enumeration != null) : "@param:enm is null.";
        assert (string != null) : "@param:delimiter is null.";
        StringBuilder stringBuilder = new StringBuilder();
        if (enumeration.hasMoreElements()) {
            stringBuilder.append(enumeration.nextElement());
            while (enumeration.hasMoreElements()) {
                stringBuilder.append(string).append(enumeration.nextElement());
            }
        }
        return stringBuilder.toString();
    }

    public static String concatenate(Collection<String> collection, String string) {
        assert (collection != null) : "@param:coll is null.";
        assert (string != null) : "@param;delimiter is null.";
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(string).append(iterator.next());
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String repeat(char c, int n) {
        assert (n >= 0) : "@param:count is negative.";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string, int n) {
        assert (string != null) : "@param:repeated is null.";
        assert (n >= 0) : "@param:count is negative.";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string, int n, String string2) {
        assert (string != null) : "@param:repeated is null.";
        assert (string2 != null) : "@param:delimiter is null.";
        assert (n >= 0) : "@param:count is negative.";
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0) {
            stringBuilder.append(string);
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(string2).append(string);
            }
        }
        return stringBuilder.toString();
    }

    public static String concatenate(Object[] objectArray, Format format, String string) throws IllegalArgumentException {
        assert (objectArray != null) : "@param:objs is null.";
        assert (format != null) : "@param:fmt is null.";
        assert (string != null) : "@param:delim is null.";
        if (format instanceof MessageFormat) {
            MessageFormat messageFormat = (MessageFormat)format;
            Object[] objectArray2 = new Object[1];
            StringBuilder stringBuilder = new StringBuilder();
            if (objectArray.length > 0) {
                objectArray2[0] = objectArray[0];
                stringBuilder.append(MessageFormat.format(messageFormat.toPattern(), objectArray2));
                for (int i = 1; i < objectArray.length; ++i) {
                    objectArray2[0] = objectArray[i];
                    stringBuilder.append(string).append(MessageFormat.format(messageFormat.toPattern(), objectArray2));
                }
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (objectArray.length > 0) {
            stringBuilder.append(format.format(objectArray[0]));
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuilder.append(string).append(format.format(objectArray[i]));
            }
        }
        return stringBuilder.toString();
    }

    public static String concatenate(Enumeration<Object> enumeration, Format format, String string) throws IllegalArgumentException {
        assert (enumeration != null) : "@param:enm is null.";
        assert (format != null) : "@param:fmt is null.";
        assert (string != null) : "@param:delim is null.";
        if (format instanceof MessageFormat) {
            MessageFormat messageFormat = (MessageFormat)format;
            Object[] objectArray = new Object[1];
            StringBuilder stringBuilder = new StringBuilder();
            if (enumeration.hasMoreElements()) {
                objectArray[0] = enumeration.nextElement();
                stringBuilder.append(MessageFormat.format(messageFormat.toPattern(), objectArray));
                while (enumeration.hasMoreElements()) {
                    objectArray[0] = enumeration.nextElement();
                    stringBuilder.append(string).append(MessageFormat.format(messageFormat.toPattern(), objectArray));
                }
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (enumeration.hasMoreElements()) {
            stringBuilder.append(format.format(enumeration.nextElement()));
            while (enumeration.hasMoreElements()) {
                stringBuilder.append(string).append(format.format(enumeration.nextElement()));
            }
        }
        return stringBuilder.toString();
    }

    public static String concatenate(Collection collection, Format format, String string) throws IllegalArgumentException {
        assert (collection != null) : "@param:coll is null.";
        assert (format != null) : "@param:fmt is null.";
        assert (string != null) : "@param:delim is null.";
        if (format instanceof MessageFormat) {
            MessageFormat messageFormat = (MessageFormat)format;
            Object[] objectArray = new Object[1];
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                objectArray[0] = iterator.next();
                stringBuilder.append(MessageFormat.format(messageFormat.toPattern(), objectArray));
                while (iterator.hasNext()) {
                    objectArray[0] = iterator.next();
                    stringBuilder.append(string).append(MessageFormat.format(messageFormat.toPattern(), objectArray));
                }
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(format.format(iterator.next()));
            while (iterator.hasNext()) {
                stringBuilder.append(string).append(format.format(iterator.next()));
            }
        }
        return stringBuilder.toString();
    }

    public static String concatenate(String[] stringArray, String string, String string2) {
        assert (stringArray != null) : "@param:strs is null.";
        assert (string != null) : "@param:delim is null.";
        assert (string2 != null) : "@param:escape is null.";
        List<String> list = Arrays.asList(string);
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(StringConverter.toWriteString(stringArray[0], string2, list));
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(StringConverter.toWriteString(stringArray[i], string2, list));
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String concatenate(String[] stringArray, char c, char c2) {
        assert (stringArray != null) : "@param:strs is null.";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder2.append(StringConverter.toWriteString(stringArray[0], c2, stringBuilder));
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder2.append(c);
                stringBuilder2.append(StringConverter.toWriteString(stringArray[i], c2, stringBuilder));
            }
        }
        return stringBuilder2.toString();
    }

    @Deprecated
    public static String concatenate(Enumeration<String> enumeration, char c, char c2) {
        assert (enumeration != null) : "@param:enm is null.";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (enumeration.hasMoreElements()) {
            stringBuilder2.append(StringConverter.toWriteString(enumeration.nextElement(), c2, stringBuilder));
            while (enumeration.hasMoreElements()) {
                stringBuilder2.append(c);
                stringBuilder2.append(StringConverter.toWriteString(enumeration.nextElement(), c2, stringBuilder));
            }
        }
        return stringBuilder2.toString();
    }

    public static String concatenate(Enumeration<String> enumeration, String string, String string2) {
        assert (enumeration != null) : "@param:enm is null.";
        assert (string != null) : "@param:delim is null.";
        assert (string2 != null) : "@param:esc is null.";
        List<String> list = Arrays.asList(string);
        StringBuilder stringBuilder = new StringBuilder();
        if (enumeration.hasMoreElements()) {
            stringBuilder.append(StringConverter.toWriteString(enumeration.nextElement(), string2, list));
            while (enumeration.hasMoreElements()) {
                stringBuilder.append(string);
                stringBuilder.append(StringConverter.toWriteString(enumeration.nextElement(), string2, list));
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String concatenate(Collection<String> collection, char c, char c2) {
        assert (collection != null) : "@param:coll is null.";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        StringBuilder stringBuilder2 = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuilder2.append(StringConverter.toWriteString(iterator.next(), c2, stringBuilder));
            while (iterator.hasNext()) {
                stringBuilder2.append(c);
                stringBuilder2.append(StringConverter.toWriteString(iterator.next(), c2, stringBuilder));
            }
        }
        return stringBuilder2.toString();
    }

    public static String concatenate(Collection<String> collection, String string, String string2) {
        assert (collection != null) : "@param:coll is null.";
        assert (string != null) : "@param:delim is null.";
        assert (string2 != null) : "@param:esc is null.";
        List<String> list = Arrays.asList(string);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(StringConverter.toWriteString(iterator.next(), string2, list));
            while (iterator.hasNext()) {
                stringBuilder.append(string);
                stringBuilder.append(StringConverter.toWriteString(iterator.next(), string2, list));
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String concatenate(String[] stringArray, char c, char c2, char c3, char c4) {
        assert (stringArray != null) : "@param:strs is null.";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        stringBuilder.append(c2);
        stringBuilder.append(c3);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder2.append(c2);
            stringBuilder2.append(StringConverter.toWriteString(stringArray[0], c4, stringBuilder));
            stringBuilder2.append(c3);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder2.append(c);
                stringBuilder2.append(c2);
                stringBuilder2.append(StringConverter.toWriteString(stringArray[i], c4, stringBuilder));
                stringBuilder2.append(c3);
            }
        }
        return stringBuilder2.toString();
    }

    public static String concatenate(String[] stringArray, String string, String string2, String string3, String string4) {
        assert (stringArray != null) : "@param:strs is null.";
        assert (string != null) : "@param:delim is null.";
        assert (string2 != null) : "@param:openPar is null.";
        assert (string3 != null) : "@param:closePar is null.";
        assert (string4 != null) : "@param:escape is null.";
        List<String> list = Arrays.asList(string, string2, string3);
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(string2);
            stringBuilder.append(StringConverter.toWriteString(stringArray[0], string4, list));
            stringBuilder.append(string3);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                stringBuilder.append(StringConverter.toWriteString(stringArray[i], string4, list));
                stringBuilder.append(string3);
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String concatenate(Enumeration<String> enumeration, char c, char c2, char c3, char c4) {
        assert (enumeration != null) : "@param:enm is null.";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        stringBuilder.append(c2);
        stringBuilder.append(c3);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (enumeration.hasMoreElements()) {
            stringBuilder2.append(c2);
            stringBuilder2.append(StringConverter.toWriteString(enumeration.nextElement(), c4, stringBuilder));
            stringBuilder2.append(c3);
            while (enumeration.hasMoreElements()) {
                stringBuilder2.append(c);
                stringBuilder2.append(c2);
                stringBuilder2.append(StringConverter.toWriteString(enumeration.nextElement(), c4, stringBuilder));
                stringBuilder2.append(c3);
            }
        }
        return stringBuilder2.toString();
    }

    public static String concatenate(Enumeration<String> enumeration, String string, String string2, String string3, String string4) {
        assert (enumeration != null) : "@param:enm is null.";
        assert (string != null) : "@param:delim is null.";
        assert (string2 != null) : "@param:openPar is null.";
        assert (string3 != null) : "@param:closePar is null.";
        assert (string4 != null) : "@param:escape is null.";
        List<String> list = Arrays.asList(string, string2, string3);
        StringBuilder stringBuilder = new StringBuilder();
        if (enumeration.hasMoreElements()) {
            stringBuilder.append(string2);
            stringBuilder.append(StringConverter.toWriteString(enumeration.nextElement(), string4, list));
            stringBuilder.append(string3);
            while (enumeration.hasMoreElements()) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                stringBuilder.append(StringConverter.toWriteString(enumeration.nextElement(), string4, list));
                stringBuilder.append(string3);
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String concatenate(Collection<String> collection, char c, char c2, char c3, char c4) {
        assert (collection != null) : "@param:coll is null.";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        stringBuilder.append(c2);
        stringBuilder.append(c3);
        StringBuilder stringBuilder2 = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuilder2.append(c2);
            stringBuilder2.append(StringConverter.toWriteString(iterator.next(), c4, stringBuilder));
            stringBuilder2.append(c3);
            while (iterator.hasNext()) {
                stringBuilder2.append(c);
                stringBuilder2.append(c2);
                stringBuilder2.append(StringConverter.toWriteString(iterator.next(), c4, stringBuilder));
                stringBuilder2.append(c3);
            }
        }
        return stringBuilder2.toString();
    }

    public static String concatenate(Collection<String> collection, String string, String string2, String string3, String string4) {
        assert (collection != null) : "@param:coll is null.";
        assert (string != null) : "@param:delim is null.";
        assert (string2 != null) : "@param:openPar is null.";
        assert (string3 != null) : "@param:closePar is null.";
        assert (string4 != null) : "@param:escape is null.";
        List<String> list = Arrays.asList(string, string2, string3);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(string2);
            stringBuilder.append(StringConverter.toWriteString(iterator.next(), string4, list));
            stringBuilder.append(string3);
            while (iterator.hasNext()) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                stringBuilder.append(StringConverter.toWriteString(iterator.next(), string4, list));
                stringBuilder.append(string3);
            }
        }
        return stringBuilder.toString();
    }
}

