/*
 * IdentityHashSetTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.util.ObjectSerializer;
import java.util.*;

/**
 * {@link ts.util.IdentityHashSet IdentityHashSet}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:44 $
 */
public class IdentityHashSetTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(IdentityHashSetTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("IdentityHashSet NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^B");

    Set<String> set = new IdentityHashSet<String>();
    EQUAL(set.size(), 0);
  }

  public void constructor_collection()
  {
    MSG("RNVɂƂRXgN^B");

    List<Integer> lst = new ArrayList<Integer>(3);
    Integer i0 = new Integer(123);
    Integer i1 = new Integer(234);
    Integer i2 = new Integer(123);
    lst.add(i0);
    lst.add(i1);
    lst.add(i2);
    FALSE(i0 == i2);

    Set<Integer> set = new IdentityHashSet<Integer>(lst);
    EQUAL(set.size(), 3);
    FALSE(set.contains(new Integer(123)));
    FALSE(set.contains(new Integer(234)));
    TRUE(set.contains(i0));
    TRUE(set.contains(i1));
    TRUE(set.contains(i2));
  }

  public void constructor_int()
  {
    MSG("eʂɂƂRXgN^B");

    Set<Integer> set = new IdentityHashSet<Integer>(10);
    EQUAL(set.size(), 0);
  }

  public void isEmpty()
  {
    MSG("vf[ǂ̊mFB");

    Set<Integer> set = new IdentityHashSet<Integer>(10);
    EQUAL(set.size(), 0);
    TRUE(set.isEmpty());

    set.add(123);
    EQUAL(set.size(), 1);
    FALSE(set.isEmpty());

    set.clear();
    EQUAL(set.size(), 0);
    TRUE(set.isEmpty());
  }

  public void contains()
  {
    MSG("w肳ꂽvf܂܂Ă邩ǂ̊mFB");

    Set<Integer> set = new IdentityHashSet<Integer>(10);

    Integer i0 = new Integer(123);
    Integer i1 = new Integer(234);
    Integer i2 = new Integer(123);
    set.add(i0);
    set.add(i1);
    set.add(i2);
    set.add(null);

    EQUAL(set.size(), 4);
    TRUE(set.contains(i0));
    TRUE(set.contains(i1));
    TRUE(set.contains(i2));
    TRUE(set.contains(null));
    FALSE(set.contains(123));
    FALSE(set.contains(234));
  }

  public void contains_1()
  {
    MSG("̏ꍇ͓ê͓̂IuWFNgB");

    Set<String> set = new IdentityHashSet<String>();
    String s0 = "";
    String s1 = "";
    String s2 = "";
    TRUE(s0 == s1);
    set.add(s0);
    set.add(s1);
    set.add(s2);
    EQUAL(set.size(), 2);
    TRUE(set.contains(s0));
    TRUE(set.contains(s1));
    TRUE(set.contains(s2));
    TRUE(set.contains(""));
    TRUE(set.contains(""));
  }

  public void iterator()
  {
    MSG("vf̃Ce[^擾B");

    Set<Integer> set = new IdentityHashSet<Integer>();
    Iterator<Integer> it = set.iterator();
    FALSE(it.hasNext());

    List<Integer> lst = new ArrayList<Integer>(3);
    Integer i0 = new Integer(123);
    Integer i1 = new Integer(234);
    Integer i2 = new Integer(123);
    lst.add(i0);
    lst.add(i1);
    lst.add(i2);

    set = new IdentityHashSet<Integer>(lst);
    it = set.iterator();
    TRUE(it.hasNext());
    TRUE(lst.contains(it.next()));
    TRUE(it.hasNext());
    TRUE(lst.contains(it.next()));
    TRUE(it.hasNext());
    TRUE(lst.contains(it.next()));
    FALSE(it.hasNext());
  }

  public void add()
  {
    MSG("vf̒ǉB");

    Set<Integer> set = new IdentityHashSet<Integer>();
    EQUAL(set.size(), 0);
    set.add(123);
    EQUAL(set.size(), 1);
    set.add(456);
    EQUAL(set.size(), 2);
    set.add(789);
    EQUAL(set.size(), 3);
  }

  public void clear()
  {
    MSG("vf̃NAB");
    Set<Integer> set = new IdentityHashSet<Integer>();
    set.add(123);
    set.add(456);
    set.add(789);
    EQUAL(set.size(), 3);
    set.clear();
    EQUAL(set.size(), 0);
  }

  @SuppressWarnings("unchecked")
  public void _clone()
  {
    MSG("N[EIuWFNg̍쐬B");

    IdentityHashSet<Integer> set = new IdentityHashSet<Integer>(10);
    Integer i0 = new Integer(123);
    Integer i1 = new Integer(234);
    Integer i2 = new Integer(123);
    set.add(i0);
    set.add(i1);
    set.add(i2);
    set.add(null);

    Object obj = set.clone();
    FALSE(obj == set);
    EQUAL(obj.getClass(), set.getClass());
    
    IdentityHashSet<Integer> set2 = (IdentityHashSet<Integer>) obj;
    EQUAL(set2.size(), 4);
    TRUE(set2.contains(i0));
    TRUE(set2.contains(i1));
    TRUE(set2.contains(i2));
    TRUE(set2.contains(null));
    FALSE(set2.contains(123));
    FALSE(set2.contains(234));
  }

  @SuppressWarnings("unchecked")
  public void serialize()
  {
    MSG("VACY̊mFB");

    IdentityHashSet<Integer> set = new IdentityHashSet<Integer>(10);
    Integer i0 = new Integer(123);
    Integer i1 = new Integer(234);
    Integer i2 = new Integer(123);
    set.add(i0);
    set.add(i1);
    set.add(i2);
    set.add(null);

    try {
      Object obj = ObjectSerializer.deserialize(
        ObjectSerializer.serializeToByteArray(set));
    
      FALSE(obj == set);
      EQUAL(obj.getClass(), set.getClass());

      IdentityHashSet<Integer> set2 = (IdentityHashSet<Integer>) obj;
      EQUAL(set2.size(), 4);
      FALSE(set2.contains(i0));
      FALSE(set2.contains(i1));
      FALSE(set2.contains(i2));
      TRUE(set2.contains(null));
      FALSE(set2.contains(123));
      FALSE(set2.contains(234));
    }
    catch (Exception e) {
      NG(e);
    }
  }
}

