/*
 * ProcessLifetimeTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.lifetime;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * {@link ts.util.lifetime.ProcessLifetime ProcessLifetime}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:48 $
 */
public class ProcessLifetimeTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ProcessLifetimeTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("ProcessLifetime NX̋@\sB");
  }

  /* -- inner classes -- */

  void log(String msg) {
    System.out.println(msg);
  }

  class LifeA implements Life {
    public void wasBorn() { log(getClass().getSimpleName() + " was born!"); }
    public void willDie() { log(getClass().getSimpleName() + " will die!"); }
  }
  class LifeB extends LifeA {}
  class LifeC extends LifeA {}

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^B");

    NOTNULL(new ProcessLifetime());
  }

  public void setLifeLong()
  {
    MSG("vZXɂ鐶Ԑݒ");

    Life lifeA0 = new LifeA();
    Life lifeB1 = new LifeB();
    Life lifeA2 = new LifeA();
    Life lifeC3 = new LifeC();
    ProcessLifetime lifetime0 = new ProcessLifetime(); 
    ProcessLifetime lifetime1 = new ProcessLifetime();
    lifetime1.add(lifeA0);
    lifetime1.add(lifeB1);
    lifetime1.add(lifeA2);
    lifetime1.add(lifeC3);

    Process process = null;
    try {
      ProcessBuilder pb = new ProcessBuilder("notepad.exe");
      process = pb.start();
    } catch (Exception e) {
      NG(e);
      return;
    }

    lifetime0.setLifeLong(process);
    lifetime1.setLifeLong(process);

    log("# Exit after 10 seconds...");
    try {
      Thread.currentThread().sleep(10000);
    }
    catch (InterruptedException e) {
      NG(e);
    }
    OK("# Complete.");
  }

  public void catchProcessException()
  {
    MSG("ÕLb`mFB");

    try {
      ProcessBuilder pb = new ProcessBuilder("notepad.exe");
      final Process process = pb.start();

      ProcessLifetime lifetime0 = new ProcessLifetime() {
        @Override public void processEnded(Process p) {
          throw new RuntimeException("G[");
        }
      };
      ProcessLifetime lifetime1 = new ProcessLifetime() {
        @Override public void processEnded(Process p) {
          throw new RuntimeException("error");
        }
        @Override public void catchProcessException(Exception e, Process p) {
          EQUAL(e.getMessage(), "error");
          EQUAL(p, process);
        }
      };

      lifetime0.setLifeLong(process);
      lifetime1.setLifeLong(process);

      Thread.sleep(2000);

    } catch (Exception e) {
      NG(e);
      return;
    }

  }
}

