/*
 * Resource class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

import java.util.List;
import java.util.ArrayList;

/**
 * \[XNXB
 * <br>
 * L[ƒl̑ΉێNX̃C^[tFCXB
 * L[w肵Ēl擾Aݒ肵肷邽߂̃\bh錾ĂB
 * <br>
 * L[́AKw\łAeKwɂuvfvƓKwɂ
 * ̗vfʂ邽߂́uvɂ\B
 * vf̋؂蕶<code>.</code>isIhjƂA<code>()</code>
 * ͂ނƂꍇAL[̌`͎̂悤ɂȂF
 * <pre>
 *     &lt;vf1&gt;.&lt;vf2&gt;.&lt;vf3&gt;(&lt;1&gt;=&lt;l1&gt;,&lt;2&gt;=&lt;l2&gt;).&lt;vf4&gt;.c
 * </pre>
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:49 $
 */
public interface Resource
{
  /**
   * w肳ꂽL[ɍŏɊYvf̒l擾B
   * <br>
   * Yvf݂Ȃꍇ͋󕶎ԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɍŏɊYvf̒lB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  String getFirstValue(String key) throws IllegalKeyException;

  /**
   * w肳ꂽL[ɊYSvf̒l̃Xg擾B
   * <br>
   * Yvf݂Ȃꍇ͋̃XgԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɊYSvf̒l̃XgB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  List<String> getValues(String key) throws IllegalKeyException;

  /**
   * w肳ꂽL[ɍŏɊYvf́Aw肳ꂽ̒l擾B
   * <br>
   * Yvf݂Ȃꍇ͋󕶎ԂB
   * YvfɁAw肳ꂽȎ݂Ȃꍇ͋󕶎ԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @param  attr B
   * @return ̃L[ɍŏɊYvf́Aw肳ꂽ̒lB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertError k̏ꍇifobO[ĥ݁jB
   */
  String getFirstAttribute(String key, String attr) throws IllegalKeyException;

  /**
   * w肳ꂽL[ɊYSvf́Aw肳ꂽ̒l̃Xg擾B
   * <br>
   * Yvf݂Ȃꍇ͋̃XgԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @param  attr B
   * @return ̃L[ɊYSvf́Aw肳ꂽ̒l̃XgB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertError k̏ꍇifobO[ĥ݁jB
   */
  List<String> getAttributes(String key, String attr)
    throws IllegalKeyException;

  /**
   * w肳ꂽL[ɍŏɊYvfvfƂq\[X擾B
   * <br>
   * w肳ꂽL[ɊYvf݂Ȃꍇ
   * {@link ts.util.resource.Resource#EMPTY}ԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɍŏɊYq\[XB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  Resource getFirstChild(String key) throws IllegalKeyException;

  /**
   * w肳ꂽL[ɊYSĂ̗vfꂼvfƂ̎q\[X
   * Xg擾B
   * <br>
   * w肳ꂽL[ɊYvf݂Ȃꍇ͋̃XgԂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɊYSvf̎q\[X̃XgB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  List<Resource> getChildren(String key) throws IllegalKeyException;

  /**
   * w肳ꂽL[ɍŏɊYvfɁAlݒ肷B
   * <br>
   * w肳ꂽL[ɊYvf݂Ȃꍇ́A̗vf쐬
   * lݒ肷B
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @param  value w肳ꂽL[ɍŏɊYvfɐݒ肷lB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void setFirstValue(String key, String value) throws IllegalKeyException;

  /**
   * w肳ꂽL[ɍŏɊYvfvfƂq\[X擾B
   * w肳ꂽL[ɊYvf݂Ȃꍇ́A쐬ĕԂB
   * <br>
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @return ̃L[ɍŏɊYq\[XB
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  Resource getOrCreateFirstChild(String key) throws IllegalKeyException;

  /**
   * w肳ꂽL[ɊYSĂ̗vf폜B
   * <br>
   * w肳ꂽL[ɊYvf݂Ȃꍇ́Â܂܉ȂB
   * ̃L[sȏꍇ͗OX[B
   *
   * @param  key L[B
   * @throws IllegalKeyException L[sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  void removeChildren(String key) throws IllegalKeyException;

  /**
   * ̃\[XIuWFNgB
   */
  static Resource EMPTY = new Resource() {
    /**
     * w肳ꂽL[ɍŏɊYvf̒l擾B
     * <br>
     * ɋ󕶎ԂB
     *
     * @param  key L[B
     * @return ̃L[ɍŏɊYvf̒lB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    public String getFirstValue(String key)
    {
      assert (key != null) : "@param:key is null.";
      return "";
    }
  
    /**
     * w肳ꂽL[ɊYSvf̒l̃Xg擾B
     * <br>
     * w肳ꂽL[ɊYvf݂Ȃꍇ͋̃XgԂB
     *
     * @param  key L[B
     * @return ̃L[ɊYSvf̒l̃XgB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    public List<String> getValues(String key)
    {
      assert (key != null) : "@param:key is null.";
      return new ArrayList<String>(0);
    }

    /**
     * w肳ꂽL[ɍŏɊYvf́Aw肳ꂽ̒l擾B
     * <br>
     * Yvf݂Ȃꍇ͋󕶎ԂB
     * YvfɁAw肳ꂽȎ݂Ȃꍇ͋󕶎ԂB
     * ̃L[sȏꍇ͗OX[B
     *
     * @param  key L[B
     * @param  attr B
     * @return ̃L[ɍŏɊYvf́Aw肳ꂽ̒lB
     * @throws AssertError k̏ꍇifobO[ĥ݁jB
     */
    public String getFirstAttribute(String key, String attr)
    {
      assert (key != null) : "@param:key is null.";
      assert (attr != null) : "@param:attr is null.";
      return "";
    }
  
    /**
     * w肳ꂽL[ɊYSvf́Aw肳ꂽ̒l̃Xg擾B
     * <br>
     * Yvf݂Ȃꍇ͋̃XgԂB
     * ̃L[sȏꍇ͗OX[B
     *
     * @param  key L[B
     * @param  attr B
     * @return ̃L[ɊYSvf́Aw肳ꂽ̒l̃XgB
     * @throws AssertError k̏ꍇifobO[ĥ݁jB
     */
    public List<String> getAttributes(String key, String attr)
    {
      assert (key != null) : "@param:key is null.";
      assert (attr != null) : "@param:attr is null.";
      return new ArrayList<String>(0);
    }
  
    /**
     * w肳ꂽL[ɍŏɊYvfvfƂq\[X擾B
     * <be>
     * {@link ts.util.resource.Resource#EMPTY}ԂB
     *
     * @param  key L[B
     * @return ̃L[ɍŏɊYq\[XB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    public Resource getFirstChild(String key)
    {
      assert (key != null) : "@param:key is null.";
      return this;
    }
  
    /**
     * w肳ꂽL[ɊYSĂ̎q\[X̃Xg擾B
     * <br>
     * ɋ̃XgԂB
     *
     * @param  key L[B
     * @return ̃L[ɊYSvf̎q\[X̃XgB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    public List<Resource> getChildren(String key)
    {
      assert (key != null) : "@param:key is null.";
      return new ArrayList<Resource>(0);
    }
  
    /**
     * w肳ꂽL[ɍŏɊYvfɁAlIuWFNgݒ肷B
     * <br>
     * ̃IuWFNgł͏ɗOX[B
     *
     * @param  key L[B
     * @param  value w肳ꂽL[ɍŏɊYvfɐݒ肷lB
     * @throws UnsupportedOperationException ɃX[B
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    public void setFirstValue(String key, String value)
      throws UnsupportedOperationException
    {
      assert (key != null) : "@param:key is null.";
      throw new UnsupportedOperationException();
    }

    /**
     * w肳ꂽL[ɍŏɊYvfvfƂq\[X擾B
     * w肳ꂽL[ɊYvf݂Ȃꍇ͍쐬ĕԂB
     * <br>
     * ̃IuWFNgł͏ɗOX[B
     *
     * @param  key L[B
     * @return ̃L[ɍŏɊYq\[XB
     * @throws UnsupportedOperationException ɃX[B
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    public Resource getOrCreateFirstChild(String key)
      throws UnsupportedOperationException
    {
      assert (key != null) : "@param:key is null.";
      throw new UnsupportedOperationException();
    }

    /**
     * w肳ꂽL[ɊYSĂ̗vf폜B
     * <br>
     * ̃IuWFNgł͉ȂB
     *
     * @param  key L[B
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    public void removeChildren(String key)
    {
      assert (key != null) : "@param:key is null.";
    }
  };
}
