/*
 * ConstraintViolationExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.util.table.Trigger.Action;

/**
 * {@link ts.util.table.ConstraintViolationException ConstraintViolationException}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:51 $
 */
public class ConstraintViolationExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ConstraintViolationExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("ConstraintViolationException NX̋@\sB");
  }
  
  enum REASON{
    CANNOT_APPEND,
    CANNOT_UPDATE,
    CANNOT_DELETE,
  }

  /* -- test case -- */

  public void constructor_action()
  {
    MSG("RXgN^̊mFB");

    try {
      throw new ConstraintViolationException(Action.Append);
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Append");
      NULL(e.getReason());
      EQUAL(e.getMessage(), "[Append][]");
      NULL(e.getCause());
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new ConstraintViolationException(null);
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_reason()
  {
    MSG("RXgN^̊mFB");

    try {
      throw new ConstraintViolationException(Action.Update,
        REASON.CANNOT_UPDATE);
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Update");
      EQUAL(e.getReason(), REASON.CANNOT_UPDATE);
      EQUAL(e.getMessage(), "[Update][CANNOT_UPDATE]");
      NULL(e.getCause());
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_reason_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new ConstraintViolationException(null, REASON.CANNOT_UPDATE);
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      throw new ConstraintViolationException(Action.Delete, null);
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      NULL(e.getReason());
      EQUAL(e.getMessage(), "[Delete][]");
      NULL(e.getCause());
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_reason_msg()
  {
    MSG("RXgN^̊mFB");

    try {
      throw new ConstraintViolationException(Action.Update, 
        REASON.CANNOT_UPDATE, "");
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Update");
      EQUAL(e.getReason(), REASON.CANNOT_UPDATE);
      EQUAL(e.getMessage(), "[Update][CANNOT_UPDATE] ");
      NULL(e.getCause());
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_reason_msg_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new ConstraintViolationException(null, REASON.CANNOT_APPEND, "");
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      throw new ConstraintViolationException(Action.Delete, null, "");
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      EQUAL(e.getReason(), null);
      EQUAL(e.getMessage(), "[Delete][] ");
      NULL(e.getCause());
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      throw new ConstraintViolationException(Action.Append,
        REASON.CANNOT_APPEND, (String) null);
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Append");
      EQUAL(e.getReason(), REASON.CANNOT_APPEND);
      EQUAL(e.getMessage(), "[Append][CANNOT_APPEND]");
      NULL(e.getCause());
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_reason_msg_cause()
  {
    MSG("RXgN^̊mFB");

    try {
      throw new ConstraintViolationException(Action.Delete,
        REASON.CANNOT_DELETE, "abc", new NullPointerException("xyz"));
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      EQUAL(e.getReason(), REASON.CANNOT_DELETE);
      EQUAL(e.getMessage(), "[Delete][CANNOT_DELETE] abc");
      EQUAL(e.getCause().getClass(), NullPointerException.class);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_reason_msg_cause_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new ConstraintViolationException(null, REASON.CANNOT_DELETE, "abc",
        new NullPointerException("xyz"));
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      throw new ConstraintViolationException(Action.Delete,
        null, "abc", new NullPointerException("xyz"));
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      NULL(e.getReason());
      EQUAL(e.getMessage(), "[Delete][] abc");
      EQUAL(e.getCause().getClass(), NullPointerException.class);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      throw new ConstraintViolationException(Action.Delete,
        REASON.CANNOT_DELETE, null, new NullPointerException("xyz"));
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      EQUAL(e.getReason(), REASON.CANNOT_DELETE);
      EQUAL(e.getMessage(), "[Delete][CANNOT_DELETE] " + new NullPointerException("xyz").toString());
      EQUAL(e.getCause().getClass(), NullPointerException.class);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      throw new ConstraintViolationException(Action.Delete,
        REASON.CANNOT_DELETE, "abc", null);
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      EQUAL(e.getReason(), REASON.CANNOT_DELETE);
      EQUAL(e.getMessage(), "[Delete][CANNOT_DELETE] abc");
      NULL(e.getCause());
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_reason_cause()
  {
    MSG("RXgN^̊mFB");

    try {
      throw new ConstraintViolationException(Action.Delete,
        REASON.CANNOT_DELETE, new NullPointerException("xyz"));
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      EQUAL(e.getReason(), REASON.CANNOT_DELETE);
      EQUAL(e.getMessage(), "[Delete][CANNOT_DELETE] " +
        new NullPointerException("xyz"));
      EQUAL(e.getCause().getClass(), NullPointerException.class);
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_action_reason_cause_1()
  {
    MSG("k̏ꍇB");

    try {
      throw new ConstraintViolationException(null, REASON.CANNOT_DELETE,
        new NullPointerException("xyz"));
    }
    catch (AssertionError e) {
      OK(e);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      throw new ConstraintViolationException(Action.Delete, null,
        new NullPointerException("xyz"));
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      NULL(e.getReason());
      EQUAL(e.getMessage(), "[Delete][] " + new NullPointerException("xyz"));
      EQUAL(e.getCause().getClass(), NullPointerException.class);
    }
    catch (Exception e) {
      NG(e);
    }

    try {
      throw new ConstraintViolationException(Action.Delete,
        REASON.CANNOT_DELETE, (Throwable) null);
    }
    catch (ConstraintViolationException e) {
      OK(e);
      EQUAL(e.getAction().name(), "Delete");
      EQUAL(e.getReason(), REASON.CANNOT_DELETE);
      EQUAL(e.getMessage(), "[Delete][CANNOT_DELETE]");
      NULL(e.getCause());
    }
    catch (Exception e) {
      NG(e);
    }
  }

  public void setNext_next()
  {
    MSG("̐ᔽO̐ݒƎ擾B");

    ConstraintViolationException e1,e2,e3;
    e1 = new ConstraintViolationException(Action.Append, REASON.CANNOT_APPEND);
    e2 = new ConstraintViolationException(Action.Update, REASON.CANNOT_UPDATE);
    e3 = new ConstraintViolationException(Action.Delete, REASON.CANNOT_DELETE);

    StringBuffer buf;

    buf = new StringBuffer();
    for (ConstraintViolationException e=e1 ; e != null; e = e.next()) {
      buf.append("[").append(e.getAction().name()).append("]");
    }
    EQUAL(buf.toString(), "[Append]");

    e1.setNext(e2);
    e2.setNext(e3);

    buf = new StringBuffer();
    for (ConstraintViolationException e=e1; e!= null; e = e.next()) {
      buf.append("[").append(e.getAction().name()).append("]");
    }
    EQUAL(buf.toString(), "[Append][Update][Delete]");

    e1.setNext(null);
    buf = new StringBuffer();
    for (ConstraintViolationException e=e1 ; e != null; e = e.next()) {
      buf.append("[").append(e.getAction().name()).append("]");
    }
    EQUAL(buf.toString(), "[Append]");
  }
}

