/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class ObjectSerializer {
    public static byte[] serializeToByteArray(Serializable serializable) throws InvalidClassException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            objectOutputStream.writeObject(serializable);
        }
        catch (NotSerializableException notSerializableException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] byArray) throws ClassNotFoundException, InvalidClassException, StreamCorruptedException, OptionalDataException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static String serializeToString(Serializable serializable) throws InvalidClassException, IOException {
        byte[] byArray = ObjectSerializer.serializeToByteArray(serializable);
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            String string = Integer.toHexString(0xFF & by);
            stringBuffer.append(string.length() == 1 ? "0" + string : string);
        }
        return stringBuffer.toString();
    }

    public static Object deserialize(String string) throws ClassNotFoundException, InvalidClassException, StreamCorruptedException, OptionalDataException, IOException {
        byte[] byArray = new byte[string.length() << 2];
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            int n3 = Integer.parseInt(string.substring(n, n + 2), 16);
            byArray[n2] = (byte)(n3 >= 128 ? n3 - 256 : n3);
            n += 2;
            ++n2;
        }
        return ObjectSerializer.deserialize(byArray);
    }
}

