/*
 * CountDown class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.math.BigDecimal;

/**
 * JEg_ENXB
 * <br>
 * JE^̒lێAZĂ߂̃\bh
 * pӂĂB
 * JE^̉ĺAftHgł̓[ɐݒ肳邪ARXgN^Ŏw
 * 邱ƂłB
 * JE^̏l͕KRXgN^Ŏw肵Ȃ΂ȂȂB
 * <br>
 * ̃NX̒ڂ̃CX^X̓}`XbhɑΉĂȂA
 * {@link ts.util.CountDown#synchronizedCountDown}\bh𗘗pāA
 * XbhZ[tȃCX^X𐶐邱ƂłB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:43 $
 */
public class CountDown
{
  /** JE^B */
  private long value_;

  /** lB */
  private long limit_;

  /**
   * JE^̏lɂƂRXgN^B
   * <br>
   * JE^̉l̓[ƂBJE^̏llꍇA
   * ̂܂ܐݒ肷B
   */
  public CountDown(long init)
  {
    this(init, 0L);
  }

  /**
   * JE^̏lƉlɂƂRXgN^B
   * <br>
   * llꍇÂ܂ܐݒ肷B
   *
   * @param  init  JE^̏lB
   * @param  limit JE^̉lB
   */
  public CountDown(long init, long limit)
  {
    value_ = init;
    limit_ = limit;
  }

  /**
   * ݂̃JE^l擾B
   *
   * @return ݂̃JE^lB
   */
  public long currentValue()
  {
    return value_;
  }

  /**
   * l擾B
   *
   * @return lB
   */
  public long limitValue()
  {
    return limit_;
  }

  /**
   * JE^̒llɒBǂ𔻒肷B
   *
   * @return JE^̒ll傫ꍇ<tt>true</tt>
   *           ԂAłȂ<tt>false</tt>ԂB
   */
  public boolean isReached()
  {
    return (value_ <= limit_) ? true : false;
  }

  /**
   * JE^ZB
   * <br>
   * JE^̒llzꍇɂ͗OX[B
   * 
   * @return Z̃JE^lB
   * @throws OutOfRangeException JE^lzꍇB
   */
  public long decrement() throws OutOfRangeException
  {
    if (value_ <= limit_) {
      BigDecimal v = new BigDecimal(String.valueOf(value_));
      v.subtract(BigDecimal.valueOf(1L));
      BigDecimal s = BigDecimal.valueOf(limit_);
      throw new OutOfRangeException(v, s, null);
    }

    value_ --;
    return value_;
  }

  /**
   * JE^̏lw肵āAXbhZ[tȃJEg_EIuWFNg
   * 𐶐B
   * <br>
   * JE^̉l̓[ƂB
   *
   * @param  init JE^̏lB
   * @return XbhZ[tȃJEg_EIuWFNgB
   */
  public static CountDown synchronizedCountDown(long init)
  {
    return synchronizedCountDown(init, 0L);
  }

  /**
   * JE^̏lyщlw肵āAXbhZ[tȃJEgAbv
   * IuWFNg𐶐B
   * <br>
   * llꍇÂ܂ܐݒ肷B
   *
   * @param  init  JE^̏lB
   * @param  limit JE^̉lB
   */
  public static CountDown synchronizedCountDown(long init, long limit)
  {
    return new CountDown(init, limit) {
      @Override
      public synchronized long currentValue() {
        return super.currentValue();
      }
      @Override
      public synchronized boolean isReached() {
        return super.isReached();
      }
      @Override
      public synchronized long decrement() throws OutOfRangeException {
        return super.decrement();
      }
    };
  }

  /**
   * w肳ꂽJEg_EIuWFNǧ݂̒lgpāA
   * XbhZ[tȃJEg_EIuWFNgVɐB
   *
   * @param  c ɂȂJEg_EIuWFNgB
   * @return XbhZ[tȃJEg_EIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static CountDown synchronizedCountDown(CountDown c) 
  {
    assert (c != null) : "@param:c is null.";

    return synchronizedCountDown(c.currentValue(), c.limitValue());
  }
}
