/*
 * RuntimeLifetime class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.lifetime;

/**
 * {@link java.lang.Runtime Runtime}IuWFNg̏Iɍ킹ĐԂ̏I
 * 肷{@link ts.util.lifetime.Lifetime Lifetime}NXB
 * <br>
 * w肳ꂽ{@link java.lang.Runtime Runtime}IuWFNgg Java VM@
 * Vbg_EmAi[Ă{@link ts.util.lifetime.Life Life}
 * {@link ts.util.lifetime.Life#willDie() willDie()}\bhĂяoB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:48 $
 */
public class RuntimeLifetime extends Lifetime
{
  /**
   * ftHgRXgN^B
   */
  public RuntimeLifetime()
  {}

  /**
   * Ԃ肷{@link java.lang.Runtime Runtime}IuWFNgݒ肷B
   *
   * @param  runtime Ԃ肷{@link java.lang.Runtime Runtime}
   *           IuWFNgB
   * @throws IllegalStateException w肳ꂽ{@link java.lang.Runtime Runtime}
   *           ̉z}VɃVbg_EłꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public void setLifeLong(final Runtime runtime)
  {
    Thread notifyThread = new Thread() {
      public void run() {
        RuntimeLifetime.this.kill();
      }
    };

    runtime.addShutdownHook(notifyThread);
  }
}

