/*
 * Trigger class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import java.util.Collection;
import java.util.Map;

/**
 * gKENXB
 * <br>
 * gḰAo^̃e[uύX钼OyђɌĂяoAύX̎
 * ƕύX̑Oɉ\bhsB
 * <br>
 * s郁\bh́Aȉ̒ʂłF
 * <table>
 * <tr>
 *  <th>\bh</th>
 *  <th>ύX̎</th>
 *  <th>ύX̑O</th>
 * </tr>
 * <tr>
 *  <td>preAppend</td>
 *  <td>R[h̒ǉ</td>
 *  <td>ύXO</td>
 * </tr>
 * <tr>
 *  <td>postAppend</td>
 *  <td>R[h̒ǉ</td>
 *  <td>ύX</td>
 * </tr>
 * <tr>
 *  <td>preUpdate</td>
 *  <td>R[h̍XV</td>
 *  <td>ύXO</td>
 * </tr>
 * <tr>
 *  <td>postUpdate</td>
 *  <td>R[h̍XV</td>
 *  <td>ύX</td>
 * </tr>
 * <tr>
 *  <td>preDelete</td>
 *  <td>R[h̍폜</td>
 *  <td>ύXO</td>
 * </tr>
 * <tr>
 *  <td>postDelete</td>
 *  <td>R[h̍폜</td>
 *  <td>ύX</td>
 * </tr>
 * </table>
 * <br>
 * s郁\bhɓn͋ʂĂAȉ̂̂nF
 * <ul>
 *  <li>e[uEIuWFNg</li>
 *  <li>ύXΏۂ̃R[hEIuWFNg</li>
 *  <li>ύXJEL[Ƃ̒li[}bvEIuWFNgiύX̎
 *      XV̏ꍇ̂݁j</li>
 * </ul>
 * <br>
 * gKEIuWFNǵA
 * {@link ts.util.table.Table#addTrigger(ts.util.table.Trigger)}\bh
 * gĒǉ邪Ae[u̕ύXɌĂяogKEIuWFNg
 * ǉꂽIuWFNĝ̂ł͂ȂÃN[EIuWFNgłB
 * ̂߁AtB[hϐĕύXOƕύXŗp悤ɂgK
 * Ãe[u}`EXbhŗpĂx͂ȂB
 *
 * @param <C> JEL[̃^CvB 
 * @param <V> J̒l̃^CvB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:52 $
 */
public abstract class Trigger<C,V> implements Cloneable
{
  /** e[uύX̎ނ񋓃NXB */
  public enum Action 
  {
    Append,  /* 󃌃R[h̒ǉB */
    Update,  /* R[h̍XVB */
    Delete,  /* R[h̍폜B */
  }

  /**
   * ftHgERXgN^B
   */
  public Trigger()
  {}

  /**
   * R[h̒ǉ̒OɌĂяo郁\bhB
   * <br>
   * ύXΏۂ̃R[hEIuWFNg̓e͋łB
   * <br>
   * <br>
   * ̃NXł́Ã\bh͉ȂB
   *
   * @param  table e[uEIuWFNgB
   * @param  record ǉ郌R[hEIuWFNgB
   */
  protected void preAppend(Table<C,V> table, Map<C,V> record)
  {}

  /**
   * R[h̒ǉ̒ɌĂяo郁\bhB
   * <br>
   * <br>
   * ̃NXł́Ã\bh͉ȂB
   *
   * @param  table e[uEIuWFNgB
   * @param  record ǉꂽR[hEIuWFNgB
   */
  protected void postAppend(Table<C,V> table, Map<C,V> record)
  {}

  /**
   * R[h̍XV̒OɌĂяo郁\bhB
   * <br>
   * ύXΏۂ̃R[hEIuWFNǵAύXȌԂœnB
   * <br>
   * <br>
   * ̃NXł́Ã\bh͉ȂB
   *
   * @param  table e[uEIuWFNgB
   * @param  record ύXΏۂ̃R[hEIuWFNgB
   * @param  destination XVJEL[Ƃ̒li[}bvB
   */
  protected void preUpdate(
    Table<C,V> table, Map<C,V> record, Map<C,V> destination)
  {}

  /**
   * R[h̍XV̒ɌĂяo郁\bhB
   * <br>
   * ύXΏۂ̃R[hEIuWFNǵAύX̏ԂœnB
   * <br>
   * <br>
   * ̃NXł́Ã\bh͉ȂB
   *
   * @param  table e[uEIuWFNgB
   * @param  record ύXΏۂ̃R[hEIuWFNgB
   * @param  destination XVJEL[Ƃ̒li[}bvB
   */
  protected void postUpdate(
    Table<C,V> table, Map<C,V> record, Map<C,V> destination)
  {}

  /**
   * R[h̍폜̒OɌĂяo郁\bhB
   * <br>
   * <br>
   * ̃NXł́Ã\bh͉ȂB
   *
   * @param  table e[uEIuWFNgB
   * @param  record ύXΏۂ̃R[hEIuWFNgB
   */
  protected void preDelete(Table<C,V> table, Map<C,V> record)
  {}

  /**
   * R[h̍폜̒ɌĂяo郁\bhB
   * <br>
   * <br>
   * ̃NXł́Ã\bh͉ȂB
   *
   * @param  table e[uEIuWFNgB
   * @param  record ύXΏۂ̃R[hEIuWFNgB
   */
  protected void postDelete(Table<C,V> table, Map<C,V> record)
  {}

  /**
   * SẴR[h폜钼OɌĂяo郁\bhB
   * <br>
   * ̃R[hERNV烌R[hɎoāA{@link
   * #preDelete(ts.util.table.Table,java.util.Map)}\bhsĂB
   *
   * @param  table e[uEIuWFNgB
   * @param  coll 폜Ώۂ̃R[hi[RNVB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  protected void preDeleteAll(Table<C,V> table, Collection<Map<C,V>> coll)
  {
    assert (table != null) : "@param:table is null.";
    assert (coll != null) : "@param:coll is null.";
    
    for (Map<C,V> rec : coll) {
      preDelete(table, rec);
    }
  }

  /**
   * SẴR[h폜ɌĂяo郁\bhB
   * <br>
   * ̃R[hERNV烌R[hɎoāA
   * {@link #postDelete(ts.util.table.Table,java.util.Map)}\bhs
   * B
   *
   * @param  table e[uEIuWFNgB
   * @param  coll 폜Ώۂ̃R[hi[RNVB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  protected void postDeleteAll(Table<C,V> table, Collection<Map<C,V>> coll)
  {
    assert (table != null) : "@param:table is null.";
    assert (coll != null) : "@param:coll is null.";

    for (Map<C,V> rec : coll) {
      postDelete(table, rec);
    }
  }

  /**
   * ̃IuWFNg̃N[EIuWFNg쐬B
   *
   * @return ̃IuWFNg̃N[EIuWFNgB
   */
  @SuppressWarnings("unchecked")
  protected Trigger<C,V> createClone()
  {
    try {
      return (Trigger<C,V>) clone();
    }
    catch (CloneNotSupportedException e) {
      throw new InternalError();
    }
  }
}
