/*
 * Decompiled with CFR 0.152.
 */
package org.nihonsoft.turbosql.modules.pg.app;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.nihonsoft.turbosql.modules.pg.app.DatabaseDataObjectInterface;
import org.nihonsoft.turbosql.modules.pg.app.DatabaseListNodeObject;
import org.nihonsoft.turbosql.modules.pg.app.DatabaseNodeObject;
import org.nihonsoft.turbosql.modules.pg.app.NodeObject;
import org.nihonsoft.turbosql.modules.pg.app.ServerNodeObject;
import org.nihonsoft.turbosql.modules.pg.app.TableListNodeObject;
import org.nihonsoft.turbosql.modules.pg.app.TableNodeObject;
import org.nihonsoft.turbosql.modules.pg.app.dialogs.DatabaseAddPane;
import org.nihonsoft.turbosql.modules.pg.app.dialogs.TableAddFrame;
import org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer.InteractiveSQL;
import org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer.StatementMetaData;

public class PostgreSQLDataObject
implements DatabaseDataObjectInterface {
    private static final String QUOTE = "\"";
    private static final String SQL_GET_DATABASES = "SELECT oid, *, pg_encoding_to_char(encoding) AS serverencoding, pg_get_userbyid(datdba) AS datowner FROM pg_database";
    private static final String SQL_GET_LANGUAGES = "SELECT now() AS ts, oid, * FROM pg_language";
    private static final String SQL_GET_USERS = "SELECT * FROM pg_user";
    private static final String SQL_GET_GROUPS = "SELECT * FROM pg_group";
    private static final String SQL_GET_SEQUENCES = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) AS seqowner, relacl FROM pg_class WHERE relkind = 'S'";
    private static final String SQL_GET_VIEWS = "SELECT now() AS ts, c.oid, c.relname, pg_get_userbyid(c.relowner) AS viewowner, c.relacl, pg_get_viewdef(c.relname) AS definition FROM pg_class c WHERE ((c.relhasrules AND (EXISTS (SELECT r.rulename FROM pg_rewrite r WHERE ((r.ev_class = c.oid) AND (bpchar(r.ev_type) = '1'::bpchar))))) OR (c.relkind = 'v'::\"char\"))";
    private static final String SQL_GET_TYPES7_1 = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as typeowner FROM pg_type WHERE typrelid = 0";
    private static final String SQL_GET_TYPES7_3 = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as typeowner FROM pg_type WHERE typtype = 'b'";
    private static final String SQL_GET_DOMAINS = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as domainowner FROM pg_type WHERE typtype = 'd'";
    private static final String SQL_GET_FUNCTIONS = "SELECT now() AS ts, oid, *, pg_get_userbyid(proowner) as funcowner FROM pg_proc";
    private static final String SQL_GET_OPERATORS = "SELECT now() AS ts, oid, *, pg_get_userbyid(oprowner) as opowner FROM pg_operator";
    private static final String SQL_GET_RULES = "SELECT now() AS ts, oid, rulename, pg_get_ruledef(rulename) as definition FROM pg_rewrite";
    private static final String SQL_GET_TRIGGERS = "SELECT now() AS ts, t.oid, tgname, proname, tgargs, tgtype FROM pg_trigger t, pg_proc p WHERE t.tgfoid = p.oid AND tgisconstraint = FALSE";
    private static final String SQL_GET_TABLES7_1 = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's'))";
    private static final String SQL_GET_TABLES7_2 = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl, relhasoids FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's'))";
    private static final String SQL_GET_COLUMNS7_1 = "SELECT a.oid, a.attname, a.attnum, t.typname, CASE WHEN ((a.attlen = -1) AND ((a.atttypmod)::int4 = (-1)::int4)) THEN (0)::int4 ELSE CASE WHEN a.attlen = -1 THEN CASE WHEN ((t.typname = 'bpchar') OR (t.typname = 'char') OR (t.typname = 'varchar')) THEN (a.atttypmod -4)::int4 ELSE (a.atttypmod)::int4 END ELSE (a.attlen)::int4 END END AS length, a.attnotnull, (SELECT adsrc FROM pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum) AS default, (SELECT indisprimary FROM pg_index i, pg_class ic, pg_attribute ia  WHERE i.indrelid = a.attrelid AND i.indexrelid = ic.oid AND ic.oid = ia.attrelid AND ia.attname = a.attname LIMIT 1) AS primarykey FROM pg_attribute a, pg_type t WHERE a.atttypid = t.oid";
    private static final String SQL_GET_COLUMNS7_2 = "SELECT 0::oid AS oid, a.attname, a.attnum, t.typname, CASE WHEN ((a.attlen = -1) AND ((a.atttypmod)::int4 = (-1)::int4)) THEN (0)::int4 ELSE CASE WHEN a.attlen = -1 THEN CASE WHEN ((t.typname = 'bpchar') OR (t.typname = 'char') OR (t.typname = 'varchar')) THEN (a.atttypmod -4)::int4 ELSE (a.atttypmod)::int4 END ELSE (a.attlen)::int4 END END AS length, a.attnotnull, (SELECT adsrc FROM pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum) AS default, (SELECT indisprimary FROM pg_index i, pg_class ic, pg_attribute ia  WHERE i.indrelid = a.attrelid AND i.indexrelid = ic.oid AND ic.oid = ia.attrelid AND ia.attname = a.attname LIMIT 1) AS primarykey FROM pg_attribute a, pg_type t WHERE a.atttypid = t.oid";
    private static final String SQL_GET_INDEXES = "SELECT now() AS ts, i.oid, i.relname, x.indisunique, x.indisprimary, pg_get_indexdef(i.oid) AS definition FROM pg_index x, pg_class i WHERE i.oid = x.indexrelid";
    private static final String SQL_GET_INDEX_COLUMNS = "SELECT attname FROM pg_attribute";
    private static final String SQL_GET_CHECKS = "SELECT rcname, rcsrc FROM pg_relcheck WHERE NOT EXISTS (SELECT * FROM pg_relcheck AS c, pg_inherits AS i WHERE i.inhrelid = pg_relcheck.rcrelid AND (c.rcname = pg_relcheck.rcname OR (c.rcname[0] = '$' AND pg_relcheck.rcname[0] = '$')) AND c.rcsrc = pg_relcheck.rcsrc AND  c.rcrelid = i.inhparent)";
    private static final String SQL_GET_INHERITED_TABLES = "SELECT c.relname FROM pg_class c, pg_inherits i WHERE c.oid = i.inhparent";
    private static final String SQL_GET_AGGREGATES = "SELECT now() AS ts, oid, aggname, pg_get_userbyid(aggowner) AS owner, aggtransfn, aggfinalfn, aggbasetype, aggtranstype, aggfinaltype, agginitval FROM pg_aggregate";
    private static final String SQL_GET_FOREIGN_KEYS = "SELECT oid, tgrelid, tgconstrname, tgnargs, tgargs, tgdeferrable, tginitdeferred FROM pg_trigger WHERE tgisconstraint = TRUE AND tgtype = 21";
    private static final String SQL_CREATE_REVLOG = "CREATE TABLE pgadmin_rclog(rc_timestamp timestamp DEFAULT now(), rc_user name DEFAULT current_user, rc_action varchar(1), rc_type varchar(32), rc_identifier varchar(256), rc_oid oid, rc_table varchar(64), rc_version int4, rc_definition text, rc_comment text); GRANT SELECT, INSERT ON pgadmin_rclog TO PUBLIC; COMMENT ON TABLE pgadmin_rclog IS 'pgAdmin II Revision Log'; CREATE INDEX pgadmin_rclog_idx ON pgadmin_rclog (rc_action, rc_type, rc_identifier, rc_table, rc_oid, rc_version);";
    private static final String SQL_DROP_REVLOG = "DROP TABLE pgadmin_rclog;";
    private static final String SQL_GRAVEYARD = "SELECT DISTINCT ON (rc_type, rc_identifier) * FROM pgadmin_rclog ORDER BY rc_type, rc_identifier, rc_version DESC";
    private static final String[] drivers = new String[]{"org.postgresql.Driver"};
    private static final String defaultDriver = "org.postgresql.Driver";
    private static final String dbProtocol = "jdbc:postgresql://";
    private static final String defaultActionList_default = "no action";
    private static final String[] defaultActionList = new String[]{"no action"};
    private static final String serverNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] serverNodeActionList = new String[]{"Do Nothing"};
    private static final String serverMultipleNodeActionList_disconnectAction = "disconnect";
    private static final String serverMultipleNodeActionList_propertiesAction = "Properties";
    private static final String[] serverMultipleNodeActionList = new String[]{"disconnect"};
    private static final String databaseListNodeActionList_addAction = "add Database";
    private static final String databaseListNodeActionList_propertiesAction = "properties";
    private static final String[] databaseListNodeActionList = new String[]{"add Database"};
    private static final String databaseListMultipleNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] databaseListMultipleNodeActionList = new String[]{"Do Nothing"};
    private static final String databaseNodeActionList_addAction = "add Database";
    private static final String databaseNodeActionList_deleteAction = "delete Database";
    private static final String databaseNodeActionList_executeSQLQuery = "execute SQL Query";
    private static final String databaseNodeActionList_propertiesAction = "properties";
    private static final String[] databaseNodeActionList = new String[]{"add Database", "delete Database", "execute SQL Query"};
    private static final String databaseMultipleNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] databaseMultipleNodeActionList = new String[]{"Do Nothing"};
    private static final String tableListNodeActionList_addAction = "add Table";
    private static final String tableListNodeActionList_propertiesAction = "properties";
    private static final String tableNodeActionList_executeSQLQuery = "execute SQL Query";
    private static final String[] tableListNodeActionList = new String[]{"add Table", "execute SQL Query"};
    private static final String tableListMultipleNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] tableListMultipleNodeActionList = new String[]{"Do Nothing"};
    private static final String tableNodeActionList_addAction = "add Table";
    private static final String tableNodeActionList_renameAction = "rename Table";
    private static final String tableNodeActionList_deleteAction = "delete Table";
    private static final String tableNodeActionList_viewDataAction = "view Data";
    private static final String tableNodeActionList_propertiesAction = "Properties";
    private static final String[] tableNodeActionList = new String[]{"add Table", "rename Table", "delete Table", "view Data"};
    private static final String tableMultipleNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] tableMultipleNodeActionList = new String[]{"Do Nothing"};
    private static final String[] dbEncodings = new String[]{"UNICODE", "EUC-JP"};
    private static final String htmlOrange = "\"ff3300\"";
    private static final String htmlRed = "\"ff0000\"";
    private static final String htmlGreen = "\"00ff00\"";
    private static final String htmlBlue = "\"0000ff\"";
    private static final String htmlYellow = "\"00ffff\"";

    public static Vector processToDataRows(ResultSet results) {
        Vector<Object[]> dataRows = new Vector<Object[]>();
        try {
            ResultSetMetaData metadata = results.getMetaData();
            int columns = metadata.getColumnCount();
            int[] columnTypes = new int[columns];
            String[] columnTypeNames = new String[columns];
            int i = 0;
            while (i < columns) {
                columnTypes[i] = metadata.getColumnType(i + 1);
                columnTypeNames[i] = metadata.getColumnTypeName(i + 1);
                ++i;
            }
            while (results.next()) {
                Object[] rowData = new Object[columns];
                int i2 = 0;
                while (i2 < columns) {
                    switch (columnTypes[i2]) {
                        case -7: {
                            rowData[i2] = new Boolean(results.getBoolean(i2 + 1));
                            break;
                        }
                        case -6: {
                            rowData[i2] = new Byte(results.getByte(i2 + 1));
                            break;
                        }
                        case 5: {
                            rowData[i2] = new Short(results.getShort(i2 + 1));
                            break;
                        }
                        case 4: {
                            rowData[i2] = new Integer(results.getInt(i2 + 1));
                            break;
                        }
                        case -5: {
                            rowData[i2] = new Long(results.getLong(i2 + 1));
                            break;
                        }
                        case 6: {
                            rowData[i2] = new Float(results.getFloat(i2 + 1));
                            break;
                        }
                        case 8: {
                            rowData[i2] = new Double(results.getDouble(i2 + 1));
                            break;
                        }
                        case 3: {
                            rowData[i2] = new Double(results.getDouble(i2 + 1));
                            break;
                        }
                        case 2: {
                            rowData[i2] = results.getBigDecimal(i2 + 1);
                            break;
                        }
                        case 1: {
                            rowData[i2] = results.getString(i2 + 1);
                            break;
                        }
                        case 12: {
                            rowData[i2] = results.getString(i2 + 1);
                            break;
                        }
                        case 91: {
                            Date temp_date = results.getDate(i2 + 1);
                            if (temp_date != null) {
                                rowData[i2] = temp_date.toString();
                                break;
                            }
                            rowData[i2] = null;
                            break;
                        }
                        case 92: {
                            Time temp_time = results.getTime(i2 + 1);
                            if (temp_time != null) {
                                rowData[i2] = temp_time.toString();
                                break;
                            }
                            rowData[i2] = null;
                            break;
                        }
                        case 93: {
                            Timestamp temp_timestamp = results.getTimestamp(i2 + 1);
                            if (temp_timestamp != null) {
                                rowData[i2] = temp_timestamp.toString();
                                break;
                            }
                            rowData[i2] = null;
                            break;
                        }
                        case 2000: {
                            rowData[i2] = results.getObject(i2 + 1);
                            break;
                        }
                        default: {
                            rowData[i2] = columnTypeNames[i2].equals("text") ? results.getString(i2 + 1) : results.getString(i2 + 1);
                        }
                    }
                    if (results.wasNull()) {
                        rowData[i2] = null;
                    }
                    ++i2;
                }
                dataRows.addElement(rowData);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle);
        }
        return dataRows;
    }

    public static Object[] processToColumnTypeArray(int[] columnTypes, String[] columnTypeNames) {
        int columnCount = columnTypes.length;
        Object[] columnTypeArray = new Object[columnCount];
        int i = 0;
        while (i < columnCount) {
            switch (columnTypes[i]) {
                case -7: {
                    columnTypeArray[i] = new Boolean(false);
                    break;
                }
                case -6: {
                    columnTypeArray[i] = new Byte(-128);
                    break;
                }
                case 5: {
                    columnTypeArray[i] = new Short(Short.MIN_VALUE);
                    break;
                }
                case 4: {
                    columnTypeArray[i] = new Integer(0);
                    break;
                }
                case -5: {
                    columnTypeArray[i] = new Long(0L);
                    break;
                }
                case 6: {
                    columnTypeArray[i] = new Float(0.0f);
                    break;
                }
                case 8: {
                    columnTypeArray[i] = new Double(0.0);
                    break;
                }
                case 3: {
                    columnTypeArray[i] = new BigDecimal(0.0);
                    break;
                }
                case 2: {
                    columnTypeArray[i] = new BigDecimal(0.0);
                    break;
                }
                case 1: {
                    columnTypeArray[i] = new String("");
                    break;
                }
                case 12: {
                    columnTypeArray[i] = "";
                    break;
                }
                case 91: {
                    columnTypeArray[i] = new String("");
                    break;
                }
                case 92: {
                    columnTypeArray[i] = new String("");
                    break;
                }
                case 93: {
                    columnTypeArray[i] = new String("");
                    break;
                }
                case 2000: {
                    columnTypeArray[i] = new Object();
                    break;
                }
                default: {
                    columnTypeArray[i] = columnTypeNames[i].equals("text") ? new String("") : new String("");
                }
            }
            ++i;
        }
        return columnTypeArray;
    }

    public static StatementMetaData parseSQLStatement(String statement) {
        String statementTrimmed = statement.trim();
        String statementQuote = "";
        boolean inQuote = false;
        int start_ptr = 0;
        boolean end_ptr = false;
        boolean from_start_ptr = false;
        String SQL_KEYWORD_FROM_lc = "from";
        boolean has_FROM = false;
        boolean is_escape = false;
        boolean was_space = false;
        String table_name = "";
        boolean table_updatable = true;
        int i = 0;
        while (i < statementTrimmed.length()) {
            if (is_escape) {
                is_escape = false;
                statementQuote = statementQuote + statementTrimmed.substring(i, i + 1);
            } else if (statementTrimmed.substring(i, i + 1).equals("\\")) {
                is_escape = true;
                statementQuote = statementQuote + statementTrimmed.substring(i, i + 1);
            } else if (statementTrimmed.substring(i, i + 1).equals("'") || statementTrimmed.substring(i, i + 1).equals(QUOTE)) {
                statementQuote = statementQuote + statementTrimmed.substring(i, i + 1);
                inQuote = !inQuote;
            } else {
                statementQuote = (statementTrimmed.substring(i, i + 1).equals(" ") || statementTrimmed.substring(i, i + 1).equals("\n")) && inQuote ? statementQuote + "\t" : ((statementTrimmed.substring(i, i + 1).equals("\t") || statementTrimmed.substring(i, i + 1).equals("\n")) && !inQuote ? statementQuote + " " : statementQuote + statementTrimmed.substring(i, i + 1));
            }
            ++i;
        }
        String temp_str = "";
        String temp_str2 = "";
        int i2 = 0;
        while (i2 < statementQuote.length()) {
            if (statementQuote.substring(i2, i2 + 1).equals(" ") && !was_space) {
                was_space = true;
                temp_str = temp_str + statementQuote.substring(i2, i2 + 1);
            } else if (!statementQuote.substring(i2, i2 + 1).equals(" ")) {
                was_space = false;
                temp_str = temp_str + statementQuote.substring(i2, i2 + 1);
            }
            ++i2;
        }
        statementQuote = temp_str;
        temp_str = "";
        String lowerCaseStatementQuote = statementQuote.toLowerCase();
        if (lowerCaseStatementQuote.indexOf(" from ", start_ptr) != -1) {
            has_FROM = true;
            temp_str = statementQuote.substring(lowerCaseStatementQuote.indexOf(" from ", start_ptr) + SQL_KEYWORD_FROM_lc.length() + 2);
            StringTokenizer strTokenizer = new StringTokenizer(temp_str, " ");
            if (strTokenizer.hasMoreTokens()) {
                table_name = strTokenizer.nextToken();
            }
            if (table_name.toLowerCase().equals("only")) {
                table_name = strTokenizer.nextToken();
            }
            temp_str2 = "";
            int i3 = 0;
            while (i3 < table_name.length()) {
                temp_str2 = table_name.substring(i3, i3 + 1).equals("\t") ? temp_str2 + " " : temp_str2 + table_name.substring(i3, i3 + 1);
                ++i3;
            }
            table_name = temp_str2;
            if (table_name.substring(table_name.length() - 1, table_name.length()).equals(",")) {
                table_updatable = false;
                table_name = table_name.substring(0, table_name.length() - 1);
            }
        } else {
            table_updatable = false;
        }
        return new StatementMetaData(table_name, table_updatable);
    }

    public static PreparedStatement getPreparedStatementForUpdate(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData) {
        Vector<Integer> SET_parameters = new Vector<Integer>();
        String sql_statement = "UPDATE " + tableName;
        String WHERE_statement = " WHERE";
        PreparedStatement pStatement = null;
        String temp_condition = "";
        int i = 0;
        while (i < columnNames.length) {
            if (changedRowData[i] != null || originalRowData[i] != null) {
                if (originalRowData[i] == null) {
                    SET_parameters.add(new Integer(i));
                } else if (changedRowData[i] == null) {
                    SET_parameters.add(new Integer(i));
                } else if (!changedRowData[i].equals(originalRowData[i])) {
                    SET_parameters.add(new Integer(i));
                }
            }
            temp_condition = originalRowData[i] == null ? columnNames[i] + " IS NULL" : columnNames[i] + "=?";
            WHERE_statement = i == 0 ? WHERE_statement + " " + temp_condition : WHERE_statement + " AND " + temp_condition;
            ++i;
        }
        if (SET_parameters.size() == 0) {
            return null;
        }
        sql_statement = sql_statement + " SET";
        int i2 = 0;
        while (i2 < SET_parameters.size()) {
            sql_statement = i2 == 0 ? sql_statement + " " + columnNames[(Integer)SET_parameters.get(i2)] + "=?" : sql_statement + ", " + columnNames[(Integer)SET_parameters.get(i2)] + "=?";
            ++i2;
        }
        sql_statement = sql_statement + WHERE_statement;
        int temp_index = 0;
        try {
            pStatement = conn.prepareStatement(sql_statement);
            int i3 = 0;
            while (i3 < SET_parameters.size()) {
                pStatement.setObject(++temp_index, changedRowData[(Integer)SET_parameters.get(i3)]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < columnNames.length) {
                if (originalRowData[i4] != null) {
                    pStatement.setObject(++temp_index, originalRowData[i4]);
                }
                ++i4;
            }
        }
        catch (SQLException sqle) {
            System.err.println("From pStatement" + sqle);
        }
        return pStatement;
    }

    public static PreparedStatement getPreparedStatementForInsert(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData) {
        Vector<Integer> columnsInsert_parameters = new Vector<Integer>();
        String sql_statement = "INSERT INTO " + tableName;
        String VALUES_statement = " VALUES(";
        String columnsInsert_statement = "(";
        PreparedStatement pStatement = null;
        int i = 0;
        while (i < columnNames.length) {
            if (changedRowData[i] != null) {
                columnsInsert_parameters.add(new Integer(i));
            }
            ++i;
        }
        if (columnsInsert_parameters.size() == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < columnsInsert_parameters.size()) {
            if (i2 == 0) {
                columnsInsert_statement = columnsInsert_statement + columnNames[(Integer)columnsInsert_parameters.get(i2)];
                VALUES_statement = VALUES_statement + "?";
            } else {
                columnsInsert_statement = columnsInsert_statement + ", " + columnNames[(Integer)columnsInsert_parameters.get(i2)];
                VALUES_statement = VALUES_statement + ", ?";
            }
            ++i2;
        }
        columnsInsert_statement = columnsInsert_statement + ")";
        VALUES_statement = VALUES_statement + ")";
        sql_statement = sql_statement + " " + columnsInsert_statement + VALUES_statement;
        int temp_index = 0;
        try {
            pStatement = conn.prepareStatement(sql_statement);
            int i3 = 0;
            while (i3 < columnsInsert_parameters.size()) {
                pStatement.setObject(++temp_index, changedRowData[(Integer)columnsInsert_parameters.get(i3)]);
                ++i3;
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle);
        }
        return pStatement;
    }

    public static PreparedStatement getPreparedStatementForDelete(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData) {
        String sql_statement = "DELETE FROM " + tableName;
        String WHERE_statement = " WHERE";
        PreparedStatement pStatement = null;
        String temp_condition = "";
        int i = 0;
        while (i < columnNames.length) {
            temp_condition = originalRowData[i] == null ? columnNames[i] + " IS NULL" : columnNames[i] + "=?";
            WHERE_statement = i == 0 ? WHERE_statement + " " + temp_condition : WHERE_statement + " AND " + temp_condition;
            ++i;
        }
        sql_statement = sql_statement + " " + WHERE_statement;
        int temp_index = 0;
        try {
            pStatement = conn.prepareStatement(sql_statement);
            int i2 = 0;
            while (i2 < originalRowData.length) {
                if (originalRowData[i2] != null) {
                    pStatement.setObject(++temp_index, originalRowData[i2]);
                }
                ++i2;
            }
        }
        catch (SQLException sqle) {
            System.err.println("From pStatementDelete " + sqle);
        }
        return pStatement;
    }

    public static String[] getDBEncodings() {
        return dbEncodings;
    }

    public static void buildServerNode(TreeNode serverNode, Connection conn) {
        DatabaseListNodeObject databaseListNodeObject = new DatabaseListNodeObject("Databases");
        DefaultMutableTreeNode databaseListNode = new DefaultMutableTreeNode(databaseListNodeObject);
        DefaultMutableTreeNode serverNodeDef = (DefaultMutableTreeNode)serverNode;
        serverNodeDef.add(databaseListNode);
        PostgreSQLDataObject.buildDatabaseListNode(databaseListNode, conn);
    }

    public static void buildDatabaseListNode(TreeNode databaseListNode, Connection conn) {
        String[] databaseNames = PostgreSQLDataObject.getDatabaseNames(conn);
        DefaultMutableTreeNode databaseListNodeDef = (DefaultMutableTreeNode)databaseListNode;
        DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)databaseListNode.getParent();
        ServerNodeObject serverNodeObject = (ServerNodeObject)tempNode.getUserObject();
        String username = serverNodeObject.getUsername();
        String password = serverNodeObject.getPassword();
        String urlPrefix = dbProtocol + serverNodeObject.getServerIP() + ":" + serverNodeObject.getServerPort() + "/";
        int i = 0;
        while (i < databaseNames.length) {
            if (!databaseNames[i].equals("template0")) {
                DefaultMutableTreeNode databaseNode = new DefaultMutableTreeNode(new DatabaseNodeObject(databaseNames[i]));
                Connection conn2 = PostgreSQLDataObject.getConnection(urlPrefix + databaseNames[i], username, password);
                databaseListNodeDef.add(databaseNode);
                PostgreSQLDataObject.buildDatabaseNode(databaseNode, conn2);
            }
            ++i;
        }
    }

    public static void buildDatabaseNode(TreeNode databaseNode, Connection conn) {
        TableListNodeObject tableListNodeObject = new TableListNodeObject("Tables");
        DefaultMutableTreeNode tableListNode = new DefaultMutableTreeNode(tableListNodeObject);
        DefaultMutableTreeNode databaseNodeDef = (DefaultMutableTreeNode)databaseNode;
        databaseNodeDef.add(tableListNode);
        PostgreSQLDataObject.buildTreeListNode(tableListNode, conn);
    }

    public static void buildTreeListNode(TreeNode tableListNode, Connection conn) {
        String[] tableNames = PostgreSQLDataObject.getTableNames(conn);
        DefaultMutableTreeNode tableListNodeDef = (DefaultMutableTreeNode)tableListNode;
        int i = 0;
        while (i < tableNames.length) {
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(new TableNodeObject(tableNames[i]));
            tableListNodeDef.add(tableNode);
            ++i;
        }
    }

    public static String[] getPopupMenuNodeActionList(NodeObject nodeObject) {
        String[] popupList = nodeObject instanceof ServerNodeObject ? serverNodeActionList : (nodeObject instanceof DatabaseNodeObject ? databaseNodeActionList : (nodeObject instanceof DatabaseListNodeObject ? databaseListNodeActionList : (nodeObject instanceof TableNodeObject ? tableNodeActionList : (nodeObject instanceof TableListNodeObject ? tableListNodeActionList : defaultActionList))));
        return popupList;
    }

    public static String[] getPopupMenuMultipleNodeActionList(NodeObject nodeObject) {
        String[] popupList = nodeObject instanceof ServerNodeObject ? serverMultipleNodeActionList : (nodeObject instanceof DatabaseListNodeObject ? databaseListMultipleNodeActionList : (nodeObject instanceof DatabaseNodeObject ? databaseMultipleNodeActionList : (nodeObject instanceof TableListNodeObject ? tableListMultipleNodeActionList : (nodeObject instanceof TableNodeObject ? tableMultipleNodeActionList : defaultActionList))));
        return popupList;
    }

    public static String[] getDatabaseNames(Connection conn) {
        String[] databaseNames = null;
        Vector<String> databaseNamesVector = new Vector<String>();
        try {
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(SQL_GET_DATABASES);
            while (rs.next()) {
                databaseNamesVector.add(rs.getString(2));
            }
            databaseNames = new String[databaseNamesVector.size()];
            int i = 0;
            while (i < databaseNamesVector.size()) {
                databaseNames[i] = (String)databaseNamesVector.get(i);
                ++i;
            }
        }
        catch (SQLException sqle) {
            System.out.println(sqle.getMessage());
        }
        return databaseNames;
    }

    public static String[] getTableNames(Connection conn) {
        String[] tableNames = null;
        Vector<String> tableNamesVector = new Vector<String>();
        String[] tableTypes = new String[]{"TABLE"};
        try {
            DatabaseMetaData dbMetaData = conn.getMetaData();
            ResultSet rs = dbMetaData.getTables(null, null, null, tableTypes);
            while (rs.next()) {
                tableNamesVector.add(rs.getString("TABLE_NAME"));
            }
            tableNames = new String[tableNamesVector.size()];
            int i = 0;
            while (i < tableNamesVector.size()) {
                tableNames[i] = (String)tableNamesVector.get(i);
                ++i;
            }
        }
        catch (SQLException sqle) {
            System.out.println(sqle.getMessage());
        }
        return tableNames;
    }

    public static Connection getConnection(String url, String username, String password) {
        Connection conn = null;
        int i = 0;
        while (i < drivers.length) {
            try {
                Class.forName(drivers[i]);
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe);
            }
            ++i;
        }
        try {
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (SQLException sqle) {
            System.out.println(sqle.getMessage());
        }
        return conn;
    }

    public static String getDBProtocol() {
        return dbProtocol;
    }

    public static String getDefaultDBURL(String serverIP, String serverPort) {
        return dbProtocol + serverIP + ":" + serverPort + "/template1";
    }

    /*
     * Unable to fully structure code
     */
    public static void performAction(Component component, String actionName, JTree jTree, ActionListener refreshListener) {
        selectionCount = jTree.getSelectionCount();
        if (selectionCount == 0) ** GOTO lbl141
        selectedRows = jTree.getSelectionRows();
        treePath = jTree.getSelectionPaths();
        selectedNodes = new Object[selectionCount];
        i = 0;
        while (i < selectionCount) {
            selectedNodes[i] = ((DefaultMutableTreeNode)treePath[i].getLastPathComponent()).getUserObject();
            ++i;
        }
        if (selectedNodes[0] instanceof ServerNodeObject) {
            if (selectedNodes.length == 1) {
                // empty if block
            }
        } else if (selectedNodes[0] instanceof DatabaseListNodeObject) {
            databaseListNode = (DefaultMutableTreeNode)treePath[0].getLastPathComponent();
            tempNode = (DefaultMutableTreeNode)databaseListNode.getParent();
            serverNodeObject = (ServerNodeObject)tempNode.getUserObject();
            serverIP = serverNodeObject.getServerIP();
            serverPort = serverNodeObject.getServerPort();
            username = serverNodeObject.getUsername();
            password = serverNodeObject.getPassword();
            if (actionName.equals("add Database")) {
                pane = new DatabaseAddPane(serverIP, serverPort, username, password, refreshListener);
                dialog = pane.createDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), "Add Database");
                dialog.show();
            }
        } else if (selectedNodes[0] instanceof DatabaseNodeObject) {
            databaseNode = (DefaultMutableTreeNode)treePath[0].getLastPathComponent();
            databaseListNode = (DefaultMutableTreeNode)databaseNode.getParent();
            tempNode = (DefaultMutableTreeNode)databaseListNode.getParent();
            serverNodeObject = (ServerNodeObject)tempNode.getUserObject();
            serverIP = serverNodeObject.getServerIP();
            serverPort = serverNodeObject.getServerPort();
            username = serverNodeObject.getUsername();
            password = serverNodeObject.getPassword();
            urlPrefix = "jdbc:postgresql://" + serverIP + ":" + serverPort + "/";
            dbName = ((DatabaseNodeObject)selectedNodes[0]).getObjectName();
            url = urlPrefix + dbName;
            if (selectedNodes.length == 1) {
                if (actionName.equals("execute SQL Query")) {
                    theApp = new InteractiveSQL("org.postgresql.Driver", url, username, password);
                } else if (actionName.equals("add Database")) {
                    pane = new DatabaseAddPane(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, refreshListener);
                    dialog = pane.createDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), "Add Database");
                    dialog.show();
                } else if (actionName.equals("delete Database")) {
                    optionPane = new JOptionPane();
                    choosenOption = JOptionPane.showConfirmDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), "Delete " + dbName + "?", "Delete Database", 1);
                    if (choosenOption == 0) {
                        errorMSG = PostgreSQLDataObject.deleteDatabase(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName);
                        if (errorMSG == null) {
                            return;
                        }
                        if (!errorMSG.equals("")) {
                            JOptionPane.showConfirmDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), errorMSG, "msg", 2);
                        } else {
                            refreshListener.actionPerformed(null);
                        }
                    }
                }
            }
        } else if (selectedNodes[0] instanceof TableListNodeObject) {
            tableListNode = (DefaultMutableTreeNode)treePath[0].getLastPathComponent();
            databaseNode = (DefaultMutableTreeNode)tableListNode.getParent();
            databaseListNode = (DefaultMutableTreeNode)databaseNode.getParent();
            tempNode = (DefaultMutableTreeNode)databaseListNode.getParent();
            serverNodeObject = (ServerNodeObject)tempNode.getUserObject();
            serverIP = serverNodeObject.getServerIP();
            serverPort = serverNodeObject.getServerPort();
            username = serverNodeObject.getUsername();
            password = serverNodeObject.getPassword();
            urlPrefix = "jdbc:postgresql://" + serverIP + ":" + serverPort + "/";
            dbName = ((DatabaseNodeObject)databaseNode.getUserObject()).getObjectName();
            url = urlPrefix + dbName;
            if (selectedNodes.length == 1) {
                if (actionName.equals("add Table")) {
                    jFrame = new TableAddFrame(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName, refreshListener);
                } else if (actionName.equals("execute SQL Query")) {
                    theApp = new InteractiveSQL("org.postgresql.Driver", url, username, password);
                }
            }
        } else if (selectedNodes[0] instanceof TableNodeObject) {
            tableNode = (DefaultMutableTreeNode)treePath[0].getLastPathComponent();
            tableListNode = (DefaultMutableTreeNode)tableNode.getParent();
            databaseNode = (DefaultMutableTreeNode)tableListNode.getParent();
            databaseListNode = (DefaultMutableTreeNode)databaseNode.getParent();
            tempNode = (DefaultMutableTreeNode)databaseListNode.getParent();
            serverNodeObject = (ServerNodeObject)tempNode.getUserObject();
            serverIP = serverNodeObject.getServerIP();
            serverPort = serverNodeObject.getServerPort();
            username = serverNodeObject.getUsername();
            password = serverNodeObject.getPassword();
            urlPrefix = "jdbc:postgresql://" + serverIP + ":" + serverPort + "/";
            tableName = ((TableNodeObject)tableNode.getUserObject()).getObjectName();
            dbName = ((DatabaseNodeObject)databaseNode.getUserObject()).getObjectName();
            url = urlPrefix + dbName;
            if (selectedNodes.length == 1) {
                if (actionName.equals("add Table")) {
                    jFrame = new TableAddFrame(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName, refreshListener);
                } else if (actionName.equals("rename Table")) {
                    newTableName = JOptionPane.showInputDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), "Enter a new name for the table:", "Rename Table", -1);
                    if (newTableName == null) {
                        return;
                    }
                    if (newTableName.equals("")) {
                        JOptionPane.showConfirmDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), "New name not entered", "msg", 2);
                        return;
                    }
                    errorMSG = PostgreSQLDataObject.renameTable(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName, tableName, newTableName);
                    if (errorMSG == null) {
                        return;
                    }
                    if (!errorMSG.equals("")) {
                        JOptionPane.showConfirmDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), errorMSG, "msg", 2);
                    } else {
                        refreshListener.actionPerformed(null);
                    }
                } else if (actionName.equals("delete Table")) {
                    optionPane = new JOptionPane();
                    choosenOption = JOptionPane.showConfirmDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), "Delete " + tableName + "?", "Delete Table", 1);
                    if (choosenOption == 0) {
                        errorMSG = PostgreSQLDataObject.deleteTable(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName, tableName);
                        if (errorMSG == null) {
                            return;
                        }
                        if (!errorMSG.equals("")) {
                            JOptionPane.showConfirmDialog(PostgreSQLDataObject.getParentFromPopupComponent(component), errorMSG, "msg", 2);
                        } else {
                            refreshListener.actionPerformed(null);
                        }
                    }
                } else if (actionName.equals("view Data")) {
                    tableNameToExecute = "SELECT * FROM \"" + tableName + "\"";
                    theApp = new InteractiveSQL("org.postgresql.Driver", url, username, password, tableNameToExecute);
                }
            }
        } else {
            ** if (selectedNodes.length != 1) goto lbl145
lbl141:
            // 1 sources

            parent = PostgreSQLDataObject.getParentFromPopupComponent(component);
            jDialog = new JOptionPane(parent.getClass().toString(), 1).createDialog(parent, "test");
            jDialog.show();
lbl-1000:
            // 1 sources

            {
                // empty if block
            }
        }
lbl145:
        // 19 sources

    }

    public static String getNodePropertyInHTML(Component component, JTree jTree) {
        int selectionCount = jTree.getSelectionCount();
        if (selectionCount != 0) {
            int[] selectedRows = jTree.getSelectionRows();
            TreePath[] treePath = jTree.getSelectionPaths();
            Object[] selectedNodes = new Object[selectionCount];
            int i = 0;
            while (i < selectionCount) {
                selectedNodes[i] = ((DefaultMutableTreeNode)treePath[i].getLastPathComponent()).getUserObject();
                ++i;
            }
            if (selectedNodes[0] instanceof ServerNodeObject) {
                return "";
            }
            if (selectedNodes[0] instanceof DatabaseListNodeObject) {
                return "";
            }
            if (selectedNodes[0] instanceof DatabaseNodeObject) {
                DefaultMutableTreeNode databaseNode = (DefaultMutableTreeNode)treePath[0].getLastPathComponent();
                DefaultMutableTreeNode databaseListNode = (DefaultMutableTreeNode)databaseNode.getParent();
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)databaseListNode.getParent();
                ServerNodeObject serverNodeObject = (ServerNodeObject)tempNode.getUserObject();
                String serverIP = serverNodeObject.getServerIP();
                String serverPort = serverNodeObject.getServerPort();
                String username = serverNodeObject.getUsername();
                String password = serverNodeObject.getPassword();
                String urlPrefix = dbProtocol + serverIP + ":" + serverPort + "/";
                String dbName = ((DatabaseNodeObject)selectedNodes[0]).getObjectName();
                String url = urlPrefix + dbName;
                if (selectedNodes.length == 1) {
                    return PostgreSQLDataObject.getDatabasePropertyHTML(component, serverIP, serverPort, username, password, dbName);
                }
                return "";
            }
            if (selectedNodes[0] instanceof TableListNodeObject) {
                return "";
            }
            if (selectedNodes[0] instanceof TableNodeObject) {
                DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)treePath[0].getLastPathComponent();
                DefaultMutableTreeNode tableListNode = (DefaultMutableTreeNode)tableNode.getParent();
                DefaultMutableTreeNode databaseNode = (DefaultMutableTreeNode)tableListNode.getParent();
                DefaultMutableTreeNode databaseListNode = (DefaultMutableTreeNode)databaseNode.getParent();
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)databaseListNode.getParent();
                ServerNodeObject serverNodeObject = (ServerNodeObject)tempNode.getUserObject();
                String serverIP = serverNodeObject.getServerIP();
                String serverPort = serverNodeObject.getServerPort();
                String username = serverNodeObject.getUsername();
                String password = serverNodeObject.getPassword();
                String urlPrefix = dbProtocol + serverIP + ":" + serverPort + "/";
                String tableName = ((TableNodeObject)tableNode.getUserObject()).getObjectName();
                String dbName = ((DatabaseNodeObject)databaseNode.getUserObject()).getObjectName();
                String url = urlPrefix + dbName;
                if (selectedNodes.length == 1) {
                    return PostgreSQLDataObject.getTablePropertyHTML(component, serverIP, serverPort, username, password, dbName, tableName);
                }
                return "";
            }
            return "";
        }
        return "";
    }

    public static String getDatabasePropertyHTML(Component component, String serverIP, String serverPort, String username, String password, String dbName) {
        String url = dbProtocol + serverIP + ":" + serverPort + "/template1";
        String sqlQueryStr = "SELECT oid, *, pg_encoding_to_char(encoding) AS serverencoding, pg_get_userbyid(datdba) AS datowner FROM pg_database WHERE datname = '" + dbName + "'";
        boolean hasError = false;
        String sqlError = "";
        String htmlStr = "";
        String dbNameLabel = "Database Name";
        String dbOwnerLabel = "Database Owner";
        String dbEncodingLabel = "Database Encoding";
        String dbOwner = "";
        String dbEncoding = "";
        Connection conn = PostgreSQLDataObject.getConnection(url, username, password);
        try {
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlQueryStr);
            rs.next();
            dbOwner = rs.getString("datowner");
            dbEncoding = rs.getString("serverencoding");
            conn.close();
        }
        catch (SQLException sqle) {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
            hasError = true;
        }
        if (hasError) {
            JOptionPane.showConfirmDialog(component, sqlError, "msg", 2);
            return "";
        }
        htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + dbNameLabel + "</font>: " + dbName + "<br>";
        htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + dbOwnerLabel + "</font>: " + dbOwner + "<br>";
        htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + dbEncodingLabel + "</font>: " + dbEncoding + "<br>";
        return htmlStr;
    }

    public static String getTablePropertyHTML(Component component, String serverIP, String serverPort, String username, String password, String dbName, String tableName) {
        String url = dbProtocol + serverIP + ":" + serverPort + "/" + dbName;
        String sqlQueryStr = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl, relhasoids FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's')) AND relname = '" + tableName + "'";
        String sqlQueryStr2 = "SELECT COUNT(*) FROM \"" + tableName + QUOTE;
        boolean hasError = false;
        String sqlError = "";
        String htmlStr = "";
        String tableNameLabel = "Table Name";
        String tableOwnerLabel = "Table Owner";
        String tableRowCountLabel = "rows";
        String tableOwner = "";
        int tableRowCount = 0;
        Connection conn = PostgreSQLDataObject.getConnection(url, username, password);
        try {
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlQueryStr);
            rs.next();
            tableOwner = rs.getString("tableowner");
            rs = statement.executeQuery(sqlQueryStr2);
            rs.next();
            tableRowCount = rs.getInt(1);
            conn.close();
        }
        catch (SQLException sqle) {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
            hasError = true;
        }
        if (hasError) {
            JOptionPane.showConfirmDialog(component, sqlError, "msg", 2);
            return "";
        }
        htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + tableNameLabel + "</font>: " + tableName + "<br>";
        htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + tableOwnerLabel + "</font>: " + tableOwner + "<br>";
        htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + tableRowCountLabel + "</font>: " + tableRowCount + "<br>";
        return htmlStr;
    }

    public static Component getParentFromPopupComponent(Component popupComponent) {
        Component component_ptr = popupComponent;
        while (component_ptr.getParent() != null) {
            component_ptr = component_ptr.getParent();
        }
        JPopupMenu jPopupMenu = (JPopupMenu)component_ptr;
        component_ptr = jPopupMenu.getInvoker();
        while (component_ptr.getParent() != null) {
            component_ptr = component_ptr.getParent();
        }
        return component_ptr;
    }

    public static String createDatabase(String serverIP, String serverPort, String username, String password, String dbName, String dbEncoding, boolean revisionControl, String comments) {
        String url = dbProtocol + serverIP + ":" + serverPort + "/template1";
        String sqlQueryStr = "CREATE DATABASE \"" + dbName + "\" WITH ENCODING = '" + dbEncoding + "'";
        String sqlError = "";
        Connection conn = PostgreSQLDataObject.getConnection(url, username, password);
        try {
            Statement statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            conn.close();
        }
        catch (SQLException sqle) {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        }
        return sqlError;
    }

    public static String deleteDatabase(String serverIP, String serverPort, String username, String password, String dbName) {
        String url = dbProtocol + serverIP + ":" + serverPort + "/template1";
        String sqlQueryStr = "DROP DATABASE \"" + dbName + QUOTE;
        String sqlError = "";
        Connection conn = PostgreSQLDataObject.getConnection(url, username, password);
        try {
            Statement statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            conn.close();
        }
        catch (SQLException sqle) {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        }
        return sqlError;
    }

    public static String createTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName, boolean[] relationalColumnPrimaryKeys, String[] relationalColumnNames, String[] relationalColumnTypes, Integer[] relationalColumnLengths, boolean[] relationalColumnAllowNullsArray, String[] relationalColumnDefaultValues, String[] relationalColumnComments, Integer[] relationalColumnNumericPrecisions) {
        String url = dbProtocol + serverIP + ":" + serverPort + "/" + dbName;
        String sqlQueryStr = "CREATE TABLE \"" + tableName + QUOTE;
        String sqlError = "";
        String columnsStr = "";
        String commentsStr = "";
        String pKeyStr = "";
        int commentCount = 0;
        int pKeyCount = 0;
        int i = 0;
        while (i < relationalColumnNames.length) {
            columnsStr = i == 0 ? relationalColumnNames[i] : columnsStr + ", " + relationalColumnNames[i];
            columnsStr = relationalColumnTypes[i].equals("timestamp") ? columnsStr + " timestamp WITHOUT TIME ZONE" : columnsStr + " " + relationalColumnTypes[i];
            if (relationalColumnLengths[i] != null) {
                columnsStr = relationalColumnNumericPrecisions[i] != null ? columnsStr + "(" + relationalColumnLengths[i] + ", " + relationalColumnNumericPrecisions[i] + ")" : columnsStr + "(" + relationalColumnLengths[i] + ")";
            }
            if (relationalColumnDefaultValues[i] != null && !relationalColumnDefaultValues[i].equals("")) {
                columnsStr = columnsStr + " DEFAULT " + relationalColumnDefaultValues[i];
            }
            if (!relationalColumnAllowNullsArray[i]) {
                columnsStr = columnsStr + " NOT NULL";
            }
            if (relationalColumnComments[i] != null && relationalColumnComments[i].length() != 0) {
                commentsStr = commentCount++ == 0 ? "COMMENT ON COLUMN \"" + tableName + "\".\"" + relationalColumnNames[i] + "\" IS '" + relationalColumnComments[i] + "'" : commentsStr + "; COMMENT ON COLUMN \"" + tableName + "\".\"" + relationalColumnNames[i] + "\" IS '" + relationalColumnComments[i] + "'";
            }
            if (relationalColumnPrimaryKeys[i]) {
                pKeyStr = pKeyCount++ == 0 ? QUOTE + relationalColumnNames[i] + QUOTE : pKeyStr + ", \"" + relationalColumnNames[i] + QUOTE;
            }
            ++i;
        }
        if (pKeyCount != 0) {
            pKeyStr = "CONSTRAINT \"" + tableName + "_pkey\" PRIMARY KEY(" + pKeyStr + ")";
        }
        sqlQueryStr = sqlQueryStr + " (" + columnsStr;
        if (pKeyCount != 0) {
            sqlQueryStr = sqlQueryStr + ", " + pKeyStr;
        }
        sqlQueryStr = sqlQueryStr + ") WITHOUT OIDS";
        if (commentCount != 0) {
            sqlQueryStr = sqlQueryStr + "; " + commentsStr;
        }
        Connection conn = PostgreSQLDataObject.getConnection(url, username, password);
        try {
            Statement statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            conn.close();
        }
        catch (SQLException sqle) {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        }
        return sqlError;
    }

    public static String deleteTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName) {
        String url = dbProtocol + serverIP + ":" + serverPort + "/" + dbName;
        String sqlQueryStr = "DROP TABLE \"" + tableName + QUOTE;
        String sqlError = "";
        Connection conn = PostgreSQLDataObject.getConnection(url, username, password);
        try {
            Statement statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            conn.close();
        }
        catch (SQLException sqle) {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        }
        return sqlError;
    }

    public static String renameTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName, String newTableName) {
        String url = dbProtocol + serverIP + ":" + serverPort + "/" + dbName;
        String sqlQueryStr = "ALTER TABLE \"" + tableName + "\" RENAME TO \"" + newTableName + QUOTE;
        String sqlError = "";
        Connection conn = PostgreSQLDataObject.getConnection(url, username, password);
        try {
            Statement statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            conn.close();
        }
        catch (SQLException sqle) {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        }
        return sqlError;
    }
}

