#include "stdafx.h"
#include "resource.h"
#include <initguid.h>
#include "timiditydrv.h"

#include "ks.h"
#include "dmusics.h"
#include <dmusici.h>
#include "mmddk.h"
#include <mmsystem.h>
#include "timiditydrv_i.c"
//#include "tim_synth.h"

#include "stdio.h"
#include "SynthClassFactory.h"

#include <mmreg.h>

#include <windows.h>
#include "SynthTIM.h"

HINSTANCE TIMinstDLL;

CSynthTIM *myTIM;

class tim_synth {
public:
	tim_synth();
	~tim_synth() {
		if(myTIM != NULL) {
			myTIM->Close();
			delete myTIM;
		}
	}
};

tim_synth::tim_synth(){
	unsigned long msg;
	myTIM = new CSynthTIM();
	myTIM->ClassicOpen("dymmy");
	msg = 0x0403C09;
	myTIM->PlayMsg(msg);
	myTIM->TIM_CallBack((unsigned char *)"dymmy",1);
}

BEGIN_OBJECT_MAP(ObjectMap)  //OBJECT_ENTRY_AUTO is better?
OBJECT_ENTRY(CLSID_tim_synth, tim_synth)
//OBJECT_ENTRY(CLSID_SynthClassFactory, SynthClassFactory)
END_OBJECT_MAP()


extern "C"
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved){
	TIMinstDLL=hinstDLL;
	
	if (fdwReason == DLL_PROCESS_ATTACH){
		_Module.Init(ObjectMap, hinstDLL, &LIBID_TIM_DRVLib); 
	}else{
		if (fdwReason == DLL_PROCESS_DETACH)
			_Module.Term();
	}
	return TRUE;
}


