/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aRts_a.c by Peter L Jones <peter@drealm.org.uk>
    based on esd_a.c

    Functions to play sound through aRts
*/

#include "stdafx.h"
#include <windows.h>
#include "SynthTIM.h"


#include "timiwp_timidity.h"
/*
CSynthTIM::CSynthTIM() {
	isOpen = false;
}
*/
CSynthTIM::~CSynthTIM() {
		if ( isOpen == true ){
		rtsyn_stop_playing();
		rtsyn_close();
		timiwp_main_close();
		isOpen = false;
	}
}
bool CSynthTIM::ClassicOpen(char * baseDir){
	int argc;
	char *argv[4];


	argc = 2;
	argv[0] = strdup("timidity");
	argv[1] = strdup("-iW");
	timiwp_main_ini(argc, argv);
	rtsyn_init();
	for(int i = 0 ; i < 2 ; i++) free(argv[i]);
	isOpen = true;
	return true;
}

void CSynthTIM::Close(void){

}

void CSynthTIM::PlayMsg(unsigned long msg){
	if ( isOpen == true ){
		rtsyn_play_one_data(0, (_int32)msg, get_current_calender_time());
	}
}

void CSynthTIM::PlaySysex(unsigned char * sysex,unsigned long len){
	if ( isOpen == true ){
		rtsyn_play_one_sysex ((char *)sysex, (int)len, get_current_calender_time());
	}
}

void CSynthTIM::TIM_CallBack(unsigned char * stream,unsigned long len){
	if ( isOpen == true ){
		rtsyn_play_calculate();
	}
}
	
