#include <stdio.h>
#include <string.h>
#include <dirent.h>

#include <windows.h>
#include <portaudio.h>
#include <pa_asio.h>
#include "w32_portaudio.h"

#include "file_io.h"
 
 
int asioConfigDialog(void)
{

	PaHostApiTypeId HostApiTypeId;
	const PaHostApiInfo  *HostApiInfo;
	PaDeviceIndex DeviceIndex;
	PaError err;
	HWND hWnd;
	int buffered_data;

	PaHostApiIndex i, ApiCount;
	
	
	if(load_portaudio_dll(0))
		return -1;
	
//	play_mode->acntl(PM_REQ_GETFILLED, &buffered_data);
//	if (buffered_data != 0) return -1;
	
//	play_mode->close_output();
	err = Pa_Initialize();
	if( err != paNoError ) goto error1;


	HostApiTypeId = paASIO;
	i = 0;
//	hWnd = hPrefWnd;
    hWnd = NULL;
	ApiCount = Pa_GetHostApiCount();
	do{
		HostApiInfo=Pa_GetHostApiInfo(i);
		if( HostApiInfo->type == HostApiTypeId ) break;
	    i++;
	}while ( i < ApiCount );
	if ( i == ApiCount ) goto error2;
    DeviceIndex = HostApiInfo->defaultOutputDevice;
	if(DeviceIndex==paNoDevice) goto error2;

	if (HostApiTypeId ==  paASIO){
    	err = PaAsio_ShowControlPanel( DeviceIndex, (void*) hWnd);
		if( err != paNoError ) goto error1;
	}
	Pa_Terminate();
//	play_mode->open_output();
  	free_portaudio_dll();
	return 0;
	
error1:
  	free_portaudio_dll();
	MessageBox(NULL, Pa_GetErrorText( err ), "Port Audio (asio) error", IDOK);
error2:
	Pa_Terminate();
	return -1;
}


int dir_list(char* file_path,  char* type, char* file_list, size_t file_list_size)
{
  struct dirent *de;
  DIR *dp = opendir(file_path);
  int offset = 0;
  char ch;
  file_list[0]= '\0';
  if (dp == NULL) return -1;
  while (de = readdir(dp)){
   if ( 0 == strcmp(de->d_name+strlen(de->d_name)-strlen(type), type) )
     offset += snprintf(file_list+offset,file_list_size-offset,"%s\n", de->d_name);
  }
  closedir(dp);
  return 0;
}


const char* get_cfg_path(void){
  FILE *fp;
 
  if ( timidity_cfg_path[0] !='\0'){
    if( (fp=fopen(timidity_cfg_path,"r")) != NULL){		
		fclose(fp);
    }else{
	  exit(1);
    }
  }else{
    GetWindowsDirectory(timidity_cfg_path, sizeof(timidity_cfg_path));
    strncat(timidity_cfg_path,"\\timidity.cfg", FILENAME_MAX-1);
  }
  return timidity_cfg_path;
  
};

