/* $Id: inflate_boot.ld,v 1.3 2003/07/17 13:30:50 ysato Exp $ */

STARTUP(vectors.o)
ENTRY(__start)

INPUT(extras.o)


GROUP(libtarget.a libgcc.a libsupc++.a)
OUTPUT_FORMAT("elf32-h8300")
OUTPUT_ARCH(h8300h)

MEMORY
{
    rom : ORIGIN = 0x000000, LENGTH = 0x80000
    ram : ORIGIN = 0x5e0000, LENGTH = 0x20000
    iram : ORIGIN = 0xffbf20, LENGTH = 0x4000-0x100
}

SECTIONS
{
   
    .vectors 0x000000 : { . = .; KEEP (*(.vectors)) } > rom
    .text ALIGN (0x1) : { ___stext = ABSOLUTE(.); *(.text*) *(.gnu.warning) *(.gnu.linkonce*) *(.init) } > rom ___etext = .; PROVIDE (etext = .);
    .fini ALIGN (0x1) : { . = .; *(.fini) } > rom
    .rodata ALIGN (0x1) : { . = .; *(.rodata*) } > rom
    .rodata1 ALIGN (0x1) : { . = .; *(.rodata1) } > rom
    .fixup ALIGN (0x1) : { . = .; *(.fixup) } > rom
    .gcc_except_table ALIGN (0x1) : { . = .; *(.gcc_except_table) } > rom
    .data : AT ((LOADADDR (.gcc_except_table) + SIZEOF (.gcc_except_table) + 4 - 1) & ~ (4 - 1)) { ___ram_data_start = ABSOLUTE (.); *(.data*) *(.data1) . = ALIGN(4); KEEP(*( SORT (.ecos.table.*))) ; . = ALIGN(4); __GOT1_START_ = ABSOLUTE (.); *(.got1) __GOT1_END_ = ABSOLUTE (.); __GOT2_START_ = ABSOLUTE (.); *(.got2) __GOT2_END_ = ABSOLUTE (.); . = ALIGN (4); ___CTOR_LIST__ = ABSOLUTE (.); KEEP (*(SORT (.ctors*))) ___CTOR_END__ = ABSOLUTE (.); ___DTOR_LIST__ = ABSOLUTE (.); KEEP (*(SORT (.dtors*))) ___DTOR_END__ = ABSOLUTE (.); __GOT_START = ABSOLUTE (.); __GLOBAL_OFFSET_TABLE_ = ABSOLUTE (.) + 32768; __SDA_BASE_ = ABSOLUTE (.); *(.got.plt) *(.got) __GOT_END_ = ABSOLUTE (.); *(.eh_frame) *(.dynamic) *(.sdata*) *(.sbss*) } > ram ___rom_data_start = LOADADDR (.data); ___ram_data_end = .; PROVIDE (___ram_data_end = .); __edata = .; PROVIDE (edata = .);
    .bss ALIGN (0x4) : { ___bss_start = ABSOLUTE (.); *(.scommon) *(.dynbss) *(.bss.*) *(COMMON) ___bss_end = ABSOLUTE (.); } > ram
    .int_hook_table 0x00FFFD20 : AT ((LOADADDR (.data) + SIZEOF (.data) + 4 - 1) & ~ (4 - 1)) { ___int_hook_start = ABSOLUTE (.); . = .; *(.int_hook_table) } > iram ___rom_int_hook_table = LOADADDR(.int_hook_table); ___int_hook_end = .;
    . = ALIGN(4); _end = .; PROVIDE (end = .);
}

_hal_virtual_vector_table = 0xfffe20;
_command = LOADADDR(.int_hook_table) + 0x100;
_deflate_kernel = _command + 0x200;
__deflate_kernel_size = 0x80000 - _deflate_kernel;
_kernel_entry = 0x400000;
__inflate_area_size = 0x200000 - 0x20000;
_linux_command = 0x5ffe00;

