/**********************************************************************
 * asym_k_test.c                                            August 2005
 *
 * ASYM: An implementation of Asymetric Cryptography in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#define __KERNEL_SYSCALLS__

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>

#include "unsx_e.h"
#include "pk_test.h"
#include "base64_test.h"
#include "pk.h"

#define KSSL_DAEMON_NAME "asym_test"

#ifndef VERSION
#define "unknown"
#endif

static int __init asym_test_init(void)
{
	char *str = "Fresh fish for all! Today Only!";

	printk(KERN_NOTICE "asym_test: "
			"(C) Jean-Luc Cooke <jlcooke@certainkey.com>. "
			"Version %s. Build %s %s\n", VERSION, 
			__DATE__, __TIME__);


	/*
	if(unsx_test(1024) < 0) {
		printk(KERN_DEBUG "testing: unsx_test: failed\n");
	}
	else {
		printk(KERN_DEBUG "testing: unsx_test: ok\n");
	}
	yield();
	*/
	if(pk_test(str, strlen(str), 1024, PK_ALGO_RSA)) {
		printk(KERN_DEBUG "testing: pk_test RSA: failed\n");
	}
	else {
		printk(KERN_DEBUG "testing: pk_test RSA: ok\n");
	}
	yield();
	if(pk_test(str, strlen(str), 1024, PK_ALGO_ELGAMAL)) {
		printk(KERN_DEBUG "testing: pk_test ELGAMAL: failed\n");
	}
	else {
		printk(KERN_DEBUG "testing: pk_test ELGAMAL: ok\n");
	}
	yield();
	if(base64_test(str, strlen(str))) {
		printk(KERN_DEBUG "testing: base_64_test: failed\n");
	}
	else {
		printk(KERN_DEBUG "testing: base_64_test: ok\n");
	}
	return(0);
}


static void __exit asym_test_cleanup(void)
{
	;
}

module_init(asym_test_init);
module_exit(asym_test_cleanup);
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("Tests for RSA and EGAMAL");
MODULE_AUTHOR("Jean-Luc Cooke <jlcooke@certainkey.com>");
