/**********************************************************************
 * elgamal.h                                                August 2005
 *
 * ASYM: An implementation of Asymetric Cryptography in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef ELGAMAL_H
#define ELGAMAL_H

#ifdef __KERNEL__
#include <linux/slab.h>
#else
#include "compat.h"
#endif

#include "pk.h"

typedef struct {
  unsx *p;
  unsx *g;
  unsx *ga;
  unsx *a;
  int len;
} elgamal_key_t;


static inline void elgamal_key_destroy_data(elgamal_key_t *k) 
{
   if(k->p) {
     kfree(k->p);
     k->p = NULL;
   }
   if(k->g) {
     kfree(k->g);
     k->g = NULL;
   }
   if(k->ga) {
     kfree(k->ga);
     k->ga = NULL;
   }
   if(k->a) {
     memset(k->a, 0, k->len*sizeof(unsx));
     kfree(k->a);
     k->a = NULL;
   }
   k->len = 0;
}


#define NULL_ELGAMAL_KEY\
 {NULL, NULL, NULL, NULL, 0}

#define ELGAMAL_ENC_LENGTH(BITS,LENGTH)\
  ( 2*BITS/8 )
#define ELGAMAL_SIG_LENGTH(BITS,LENGTH)\
  ( 2*BITS/8 )

int elgamal_keygen(elgamal_key_t *pub, elgamal_key_t *pri,
                          int bitLen,
                          unsigned options);

int elgamal_encrypt(char *out, int *outLen,
                           const elgamal_key_t *pub,
                           const char *in, int inLen,
                           unsigned options);

int elgamal_decrypt(char *out, int *outLen,
                           const elgamal_key_t *pri,
                           const char *in, int inLen,
                           unsigned options);

int elgamal_sign(char *out, int *outLen,
                        const elgamal_key_t *pri,
                        const char *in, int inLen,
                        unsigned options);

int elgamal_verify(const char *hash, int hashLen,
                          const elgamal_key_t *pub,
                          const char *in, int inLen,
                          unsigned options);

#endif /* ELGAMAL_H */
