/**********************************************************************
 * rsa.h                                                    August 2005
 *
 * ASYM: An implementation of Asymetric Cryptography in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef RSA_H
#define RSA_H

#include "pk.h"

typedef struct {
  unsx *n;
  unsx *e;
  unsx *d;
  int len;
} rsa_key_t;

static inline void rsa_key_destroy_data(rsa_key_t *k) 
{
   if(k->n) {
     kfree(k->n);
     k->n = NULL;
   }
   if(k->e) {
     kfree(k->e);
     k->e = NULL;
   }
   if(k->d) {
     memset(k->d, 0, k->len * sizeof(unsx));
     kfree(k->d);
     k->d = NULL;
   }
   k->len = 0;
}

#define NULL_RSA_KEY\
  {NULL, NULL, NULL, 0}

#define RSA_ENC_LENGTH(BITS,OPTIONS)\
  ( BITS/8 )
#define RSA_SIG_LENGTH(BITS,OPTIONS)\
  ( BITS/8 )

int rsa_keygen(rsa_key_t *pub, rsa_key_t *pri,
                      int bitLen,
                      int genOptions);

int rsa_wrap(char *out, int *outLen,
                    const rsa_key_t *pub, const unsx *exp,
                    const char *in, int inLen,
                    int wrapType);
 
int rsa_unwrap(char *out, int *outLen,
                      const rsa_key_t *pri, const unsx *exp,
                      const char *in, int inLen,
                      int wrapType);

#endif /* RSA_H */
