/**********************************************************************
 * ssl3mac.h                                                August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * Based heavily on ssl3mac.c
 * Copyright (c) 2002 James Morris <jmorris@intercode.com.au>
 *
 * Which in turn has its ssl3mac implementation is derived from USAGI.
 * Copyright (c) 2002 Kazunori Miyazawa <miyazawa@linux-ipv6.org> / USAGI
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _SSL3MAC_H
#define _SSL3MAC_H

#include <linux/crypto.h>
#include <asm/scatterlist.h>

void crypto_ssl3mac_init(struct crypto_tfm *tfm, u8 *key, 
		unsigned int *keylen);

void crypto_ssl3mac_update(struct crypto_tfm *tfm,
                        struct scatterlist *sg, unsigned int nsg);

void crypto_ssl3mac_final(struct crypto_tfm *tfm, u8 *key,
                       unsigned int *keylen, u8 *out);
void crypto_ssl3mac(struct crypto_tfm *tfm, u8 *key, unsigned int *keylen,
                 struct scatterlist *sg, unsigned int nsg, u8 *out);

#endif /* _SSL3MAC_H */
