/**********************************************************************
 * asym_method.h                                            August 2005
 *
 * KSSLD(key_tool): An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSL_KEY_TOOL_ASYM_METHOD_H
#define KSSL_KEY_TOOL_ASYM_METHOD_H

#include "kssl.h"

#include <stdio.h>


int asym_method_available_printf(void);

int asym_method_available_fprintf(FILE *stream);

int asym_method_list_printf(kssl_asym_method_t *am_list, size_t noam);

int asym_method_list_fprintf(FILE *stream, kssl_asym_method_t *am_list, 
		size_t noam);

int asym_method_byname_list_alloc(const char *asym_method_str, 
		const char delimiter, kssl_asym_method_t **am_list_ret, 
		size_t *noam_ret);

#endif /* KSSL_KEY_TOOL_ASYM_METHOD_H */
