/**********************************************************************
 * cipher.h                                                 August 2005
 *
 * KSSLD(key_tool): An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSL_KEY_TOOL_CIPHER_H
#define KSSL_KEY_TOOL_CIPHER_H

#include "types/cipher_suite_t.h"

#include <stdio.h>

int vaild_cipher(cipher_suite_t *cs);

int cipher_available_printf(void);

int cipher_available_fprintf(FILE *stream);

int cipher_list_printf(cipher_suite_t *cs, size_t nocs);

int cipher_list_fprintf(FILE *stream, cipher_suite_t *cs, size_t nocs);

int cipher_byname_list_alloc(const char *list, const char delimiter,
		cipher_suite_t **cs_list_ret, size_t *nocs_ret);

#endif /* KSSL_KEY_TOOL_CIPHER_H */
