/**********************************************************************
 * app_data.h                                               August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _KSSL_APP_DATA_H
#define _KSSL_APP_DATA_H

#include "record.h"

int kssl_application_data_send(kssl_record_t *cr, u8 *buf,
		size_t len, int reuse);

int kssl_application_data_process(kssl_record_t *cr, alert_t *alert);

int
kssl_application_data_send_from_pt(kssl_record_t *cr, size_t len,
		                size_t offset, int reuse);

#endif /* _KSSL_APP_DATA_H */
