/**********************************************************************
 * conn_list.c                                              August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#include <linux/kernel.h>
#include <linux/net.h>
#include <linux/version.h>

#include "conn.h"
#include "conn_list.h"
#include "record_list.h"
#include "log.h"

struct list_head kssl_conn_list;
struct list_head kssl_conn_close_list;


void 
kssl_conn_list_close(struct list_head *list)
{
	kssl_conn_t *conn;
	struct list_head *t_list;
	struct list_head *c_list;

	list_for_each_safe(c_list, t_list, list) {
		conn = list_entry(c_list, kssl_conn_t, list);
		kssl_record_list_clear_conn(&kssl_message_in_list, conn);
		kssl_record_list_clear_conn(&kssl_record_out_list, conn);
		kssl_record_list_clear_conn(&kssl_record_in_list, conn);
		kssl_conn_destroy(conn);
	}

	if (!list_empty(list))
		KSSL_DEBUG(6, "ERROR: kssl_conn_list_close: "
				"could not clear list\n");
}


int kssl_conn_list_accept(kssl_daemon_t *daemon, struct list_head *list)
{
	int status;
	int conn_count;
	kssl_conn_t *conn;

	conn_count = 0;
	while(1) {
		status = kssl_conn_accept(daemon, &conn);
		if(!status) {
			break;
		}
		if(status < 0) {
			return(status);
		}
		list_move_tail(&(conn->list), list);
		conn_count++;
	}
	
	return(conn_count);
}
