/**********************************************************************
 * kssl_alloc.h                                             August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSL_ALLOC_H
#define KSSL_ALLOC_H

#ifdef KSSL_ALLOC_DEBUG

void kssl_alloc_cleanup(void);

void kssl_alloc_dump(void);

void *__kssl_kmalloc(size_t len, int flags,
		const char *function, const char *file, size_t line);

void __kssl_kfree(void *ptr,
		const char *function, const char *file, size_t line);

#define kssl_kmalloc(len, flags) \
	__kssl_kmalloc(len, flags, __FUNCTION__, __FILE__, __LINE__)

#define kssl_kfree(ptr) \
	__kssl_kfree(ptr, __FUNCTION__, __FILE__, __LINE__)

#else /* KSSL_ALLOC_DEBUG */

#define kssl_alloc_cleanup() do{ ; }while(0)
#define kssl_alloc_dump() do{ ; }while(0)
#define kssl_kmalloc(len, flags) kmalloc(len, flags);
#define kssl_kfree(ptr) kfree(ptr);

#endif /* KSSL_ALLOC_DEBUG */

#endif /* KSSL_ALLOC_H */

