/**********************************************************************
 * message.h                                                August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSK_CONN_RECORD_H
#define KSSK_CONN_RECORD_H

#include <linux/kernel.h>
#include <linux/net.h>
#include <linux/version.h>

#include "conn.h"
#include "record.h"

#include "types/alert_t.h"
#include "types/record_t.h"


kssl_message_t *kssl_message_create(content_type_t ct);

void kssl_message_destroy(kssl_message_t *msg);

int kssl_message_in(kssl_record_t **cr, alert_t *alert);

int kssl_message_process_in(kssl_record_t *cr);

void kssl_message_update_mask_out(kssl_record_t *cr);

#endif /* KSSK_CONN_RECORD_H */
