/**********************************************************************
 * prf.h                                                    August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSL_PRF_H
#define KSSL_PRF_H

#include <linux/kernel.h>
#include <linux/net.h>
#include <linux/version.h>

#define MASTER_SECRET_LABEL "master secret"
#define KEY_EXPANSION_LABEL "key expansion"
#define CLIENT_WRITE_LABEL  "client write key"
#define SERVER_WRITE_LABEL  "server write key"
#define IV_BLOCK_LABEL      "IV block"

#include <types/security_parameters_t.h>

#define MASTER_SECRET_LABEL "master secret"
#define KEY_EXPANSION_LABEL "key expansion"

u8 *kssl_prf_tls(u8 *secret, u32 secret_len,
		const u8 *label, u32 label_len,
		const u8 *client_random, u32 client_random_len,
		const u8 *server_random, u32 server_random_len,
		u32 output_len);

u8 *kssl_prf_ssl3_export_md5(const u8 *secret, u32 secret_len,
		const u8 *client_random, u32 client_random_len,
		const u8 *server_random, u32 server_random_len,
		u32 *output_len);

u8 *kssl_prf_ssl3(const u8 *secret, u32 secret_len,
		const u8 *random_a, u32 random_a_len,
		const u8 *random_b, u32 random_b_len, u32 *output_len);

#endif /* KSSL_PRF_H */
