/**********************************************************************
 * dest.c                                                   August 2005
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>
#include "glib.h"
#include "vanessa_logger.h"
#include "l7vs.h"

struct l7vs_dest *
l7vs_dest_create(struct sockaddr_in *addr, int weight)
{
        struct l7vs_dest *dest;

        dest = (struct l7vs_dest *)malloc(sizeof(*dest));
        if (dest == NULL) {
                VANESSA_LOGGER_ERR("Could not allocate memory");
                return dest;
        }

        dest->addr = *addr;
        dest->weight = weight;
        dest->nactive = dest->ninact = 0;

#if 0
        mss = l7vs_dest_get_mss(addr);
        if (mss < 0) {
                free(dest);
                return NULL;
        }
        dest->mss = mss;
#endif

        return dest;
}

void
l7vs_dest_destroy(struct l7vs_dest *dest)
{
        free(dest);
}

void
l7vs_dest_to_arg(struct l7vs_dest *dest, struct l7vs_dest_arg *darg)
{
        darg->addr = dest->addr;
        darg->weight = dest->weight;
        darg->nactive = dest->nactive;
        darg->ninact = dest->ninact;
}
