/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.scalar.conf,v 1.8 2004/10/14 12:57:34 dts12 Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "l7vsagent.h"
#include "l7vsClusterInfo.h"


/** Initializes the l7vsClusterInfo module */
void
init_l7vsClusterInfo(void)
{
    static oid      l7vsVersion_oid[] =
        { 1, 3, 6, 1, 4, 1, 9999, 1, 1, 1 }; 
    static oid      l7vsNumServices_oid[] =
        { 1, 3, 6, 1, 4, 1, 9999, 1, 1, 2 };

    DEBUGMSGTL(("l7vsClusterInfo", "Initializing\n"));

    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("l7vsVersion", handle_l7vsVersion,
                             l7vsVersion_oid, OID_LENGTH(l7vsVersion_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("l7vsNumServices", handle_l7vsNumServices,
                             l7vsNumServices_oid,
                             OID_LENGTH(l7vsNumServices_oid),
                             HANDLER_CAN_RONLY));
}


/* For getting the Version number of L7VS */
int
handle_l7vsVersion(netsnmp_mib_handler *handler,
                   netsnmp_handler_registration *reginfo,
                   netsnmp_agent_request_info *reqinfo,
                   netsnmp_request_info *requests)
{
    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

	char* chVersion;
	if(get_str_version(&chVersion) != L7_OK)
	{
		return SNMP_ERR_GENERR;
	}

    switch (reqinfo->mode) {

    case MODE_GET:
        snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                 (u_char *) chVersion
                                 ,strlen(chVersion)+1
				 );
        break;


    default:
        /*
         * we should never get here, so this is a really bad error
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_l7vsVersion\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}


/* For getting the total number of Virtual services in L7VS Table */
int
handle_l7vsNumServices(netsnmp_mib_handler *handler,
                       netsnmp_handler_registration *reginfo,
                       netsnmp_agent_request_info *reqinfo,
                       netsnmp_request_info *requests)
{
    /*
     * We are never called for a GETNEXT if it's registered as a
     * "instance", as it's "magically" handled for us.
     */

    /*
     * a instance handler also only hands us one request at a time, so
     * we don't need to loop over a list of requests; we'll only get one.
     */

	int nNumServices;
	get_int_numServices((int32_t*) &nNumServices);
    switch (reqinfo->mode) {

    case MODE_GET:
        snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
                                 (u_char *)&nNumServices
                                 ,sizeof(nNumServices)
                                  );
        break;


    default:
        /*
         * we should never get here, so this is a really bad error
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_l7vsNumServices\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}
