#ifndef SYNC_SESSION_H
#define SYNC_SESSION_H

#include<sys/shm.h>
#include<sys/sem.h>
#include<sys/ipc.h>
#include<sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* Maintaining Session Count */
#define SES_SZ 10000  

/* Maintaining VIPS Count for Session */
#define VIP_SZ 20 

/* Maintaining VIPS Count for Load Evasion */
#define LE_VIP_SZ 200

/* Key value for shared memory and semaphore to maintain session information */
#define  key_shm_ck  0x1234
#define  key_sem_ck  0x3333

/* Key value for shared memory and semaphore to maintain evasion variables */
#define  key_shm_evs 0x54321
#define  key_sem_evs 0x5555


char *file_path;
char process_file[20];

int cindx;

/* copied from protomod_cpassive */
struct cookie_list{
        char pattern[129];
        struct sockaddr_in raddr;
        time_t date;
};

/* added other variables to distinguish the protocol module type */
struct ck_list_ary_st 
{
        char vip[30];
	char protomod[16];
	char cookie_name[129];
	struct cookie_list cklist_ary[SES_SZ];
};

/* To maintain vips on standby */
struct vip_pmod_info
{
	char vip[30];
	char protomod[16];
};


/* this structure data will write into the shared memory */
struct sync_info_st
{
	struct ck_list_ary_st ckal[VIP_SZ];
        unsigned status_flag[VIP_SZ]; 
        unsigned standby_flag; 
	struct vip_pmod_info vp[VIP_SZ];
};

/* semaphore settings */
union semun
{
        int val;
        struct semid_ds *buf;
        unsigned short *array;
};


//Evasion module
struct evasion_parms
{
        char vaddr[16];
        char ssaddr[16];
        int cc;
};

struct evasion
{
        struct evasion_parms e[LE_VIP_SZ];
};

/* Check the process is running or not */
int check_process_state(char *pid_file,int prtocol);

/* initializing the shared memory */
int initialize_shm(key_t ,int );

/* initializing the semaphore */
int initialize_sem(key_t );

/*  semaphore releasing */
void semaphore_unlock(int);

/*  semaphore locking  */
void semaphore_lock(int);

/* To check weather the system is standby or not */
unsigned isStandby(void);

#endif
