Name:           perl-Net-IP
Version:        1.25
Release: 	2.fc6
Epoch: 2 
Summary:        Perl module for manipulation of IPv4 and IPv6 addresses

Group:          Development/Libraries
License:        GPL or Artistic
URL:            http://search.cpan.org/dist/Net-IP/
Source:         ftp:/cpan.org/pub/CPAN/authors/id/M/MA/MANU/Net-IP-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  perl
Requires:  perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))

Patch0:		perl-Net-IP-1.25-bz197425.patch

%description
This is the Net::IP module for Perl, designed to allow easy
manipulation of IPv4 and IPv6 addresses.  Two applications using the
Net::IP module are included: ipcount, an IP address mini-calculator,
it can calculate the number of IP addresses in a prefix or all the
prefixes contained in a given range; and iptab, which prints out a
handy IP "cheat sheet".


%prep
%setup -q -n Net-IP-%{version}
%patch0 -p1

%build
%{__perl} Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type d -depth -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*


%check
make test


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc COPYING Changes README
%{_bindir}/ipcount
%{_bindir}/iptab
%{perl_vendorlib}/Net/
%{_mandir}/man3/Net::IP.3*


%changelog
* Mon Oct 29 2007 KONDO hideaki <kondo.hideaki@oss.ntt.co.jp>
- Created for ultramonkey3 on RHEL5

* Wed Jul 05 2006 Jason Vas Dias <jvdias@redhat.com> - 1.25-2
- fix bug 197925 - make intip handle zero-valued IP addresses

* Mon Jun 05 2006 Jason Vas Dias <jvdias@redhat.com> - 1.25-1
- upgrade to 1.25

* Fri Feb 03 2006 Jason Vas Dias <jvdias@redhat.com> - 1.24-2.2
- rebuild for new perl-5.8.8

* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt for new gcc

* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt for new gcj

* Mon Oct 31 2005 Warren Togami <wtogami@redhat.com> - 1.24-2
- import into FC5 because perl-Net-DNS needs it

* Wed Oct 19 2005 Ville Skyttä <ville.skytta at iki.fi> - 1.24-1
- 1.24.

* Mon Jun  6 2005 Ville Skyttä <ville.skytta at iki.fi> - 1.23-3
- 1.23, patches applied upstream.
- Improve description.

* Sun May 29 2005 Ville Skyttä <ville.skytta at iki.fi> - 1.22-2
- 1.22, include test case for rt.cpan.org #7528 patch.
- Patch to mute stdout noise from ip_reverse().

* Fri Apr  7 2005 Michael Schwendt <mschwendt[AT]users.sf.net> - 1.21-2
- rebuilt

* Thu Dec  2 2004 Ville Skyttä <ville.skytta at iki.fi> - 0:1.21-1
- Update to 1.21.

* Sat Nov  6 2004 Ville Skyttä <ville.skytta at iki.fi> - 0:1.20-0.fdr.7
- Apply fixes from rt.cpan.org #3844 and #7528.
- Some specfile cleanups.

* Sun May  9 2004 Ville Skyttä <ville.skytta at iki.fi> - 0:1.20-0.fdr.6
- BuildRequire perl >= 1:5.6.1-34.99.6 for support for vendor installdirs.
- Use pure_install to avoid perllocal.pod workarounds.

* Sun Apr 25 2004 Ville Skyttä <ville.skytta at iki.fi> - 0:1.20-0.fdr.5
- Require perl(:MODULE_COMPAT_*).

* Mon Feb  2 2004 Ville Skyttä <ville.skytta at iki.fi> - 0:1.20-0.fdr.4
- Reduce directory ownership bloat.

* Mon Dec  1 2003 Ville Skyttä <ville.skytta at iki.fi> - 0:1.20-0.fdr.3
- Specfile cleanup.

* Sun Aug 31 2003 Ville Skyttä <ville.skytta at iki.fi> - 0:1.20-0.fdr.2
- Install into vendor dirs.

* Wed Jul 16 2003 Ville Skyttä <ville.skytta at iki.fi> - 0:1.20-0.fdr.1
- First build.
