%{!?perl_vendorarch: %define perl_vendorarch %(eval "`perl -V:installvendorarch`"; echo $installvendorarch)}

Summary: XML-LibXML Perl module
Name: perl-XML-LibXML
Version: 1.58
Release: 5
License: GPL or Artistic
Group: Development/Libraries
URL: http://search.cpan.org/dist/XML-LibXML/
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: perl >= 2:5.8.0
Requires: %(perl -MConfig -le 'if (defined $Config{useithreads}) { print "perl(:WITH_ITHREADS)" } else { print "perl(:WITHOUT_ITHREADS)" }')
Requires: %(perl -MConfig -le 'if (defined $Config{usethreads}) { print "perl(:WITH_THREADS)" } else { print "perl(:WITHOUT_THREADS)" }')
Requires: %(perl -MConfig -le 'if (defined $Config{uselargefiles}) { print "perl(:WITH_LARGEFILES)" } else { print "perl(:WITHOUT_LARGEFILES)" }')
Requires: perl(:MODULE_COMPAT_%(perl -MConfig -e 'print $Config{version}'))
Source0: XML-LibXML-1.58.tar.gz
BuildRequires: perl-XML-LibXML-Common perl-XML-SAX perl-XML-NamespaceSupport
BuildRequires: libxml2-devel
Requires: perl-XML-LibXML-Common perl-XML-SAX perl-XML-NamespaceSupport

%description
%{summary}.

%prep
%setup -q -n XML-LibXML-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS" SKIP_SAX_INSTALL=1 perl Makefile.PL INSTALLDIRS=vendor
make OPTIMIZE="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
make install \
  PERL_INSTALL_ROOT=$RPM_BUILD_ROOT \
  INSTALLARCHLIB=$RPM_BUILD_ROOT%{perl_archlib}
find $RPM_BUILD_ROOT -type f -a \( -name perllocal.pod -o -name .packlist \
  -o \( -name '*.bs' -a -empty \) \) -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type d -depth -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*

%check || :
make test

%clean
rm -rf $RPM_BUILD_ROOT

%triggerin -- perl-XML-SAX
for p in XML::LibXML::SAX::Parser XML::LibXML::SAX XML::SAX::PurePerl; do
  perl -MXML::SAX -e "XML::SAX->add_parser(q($p))->save_parsers()" || :
done

%triggerun -- perl-XML-SAX
for p in XML::LibXML::SAX::Parser XML::LibXML::SAX XML::SAX::PurePerl; do
  perl -MXML::SAX -e "XML::SAX->remove_parser(q($p))->save_parsers()" || :
done

%preun
if [ $1 -eq 0 ] ; then
  for p in XML::LibXML::SAX::Parser XML::LibXML::SAX XML::SAX::PurePerl; do
    perl -MXML::SAX -e "XML::SAX->remove_parser(q($p))->save_parsers()" \
      2>/dev/null || :
  done
fi

%files
%defattr(-,root,root,-)
%doc Changes LICENSE README
%{perl_vendorarch}/auto/XML
%{perl_vendorarch}/XML
%{_mandir}/man3/*.3*

%changelog
* Tue Jan 23 2007 Robin Norwood <rnorwood@redhat.com> - 1.58-5
- Resolves: #223057: try again to get the script ordering correct.

* Sat Dec 06 2006 Robin Norwood <rnorwood@redhat.com> - 1.58-4
- rebuild

* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 1.58-2.2.2.1
- rebuild

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1.58-2.2.2
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 1.58-2.2.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Fri Feb 03 2006 Jason Vas Dias <jvdias@redhat.com> - 1.58-2.2
- rebuild for new perl-5.8.8

* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt for new gcc

* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt for new gcj

* Sat Mar 19 2005 Joe Orton <jorton@redhat.com> 1.58-2
- rebuild

* Sun Apr 18 2004 Ville Skyttä <ville.skytta at iki.fi> - 1.58-1
- #121168
- Update to 1.58.
- Require perl(:MODULE_COMPAT_*).
- Handle ParserDetails.ini parser registration.
- BuildRequires libxml2-devel.
- Own installed directories.

* Fri Feb 27 2004 Chip Turner <cturner@redhat.com> - 1.56-1
- Specfile autogenerated.
