Summary: Crypt::SSLeay - OpenSSL glue that provides LWP https support
Name: perl-Crypt-SSLeay
Version: 0.51
Release: 11%{?dist}
Epoch: 2
License: GPL or Artistic
Group: Development/Libraries
Source0: http://www.cpan.org/authors/id/C/CH/CHAMAS/Crypt-SSLeay-%{version}.tar.gz
Patch0: perl-Crypt-SSLeay-cryptdef.patch
Patch1: perl-Crypt-SSLeay-dirnamefix.patch
Patch2: perl-Crypt-SSLeay-lib64.patch
Patch3: perl-Crypt-SSLeay-openssl-098.patch
URL: http://search.cpan.org/dist/Crypt-SSLeay/
BuildRoot: %{_tmppath}/perl-Crypt-SSLeay-buildroot/
BuildRequires: perl >= 2:5.8.0-61 openssl-devel perl-URI pkgconfig
Requires: perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))

%description
This perl module provides support for the https protocol under LWP, so
that a LWP::UserAgent can make https GET & HEAD & POST
requests. Please see perldoc LWP for more information on POST
requests.

The Crypt::SSLeay package contains Net::SSL, which is automatically
loaded by LWP::Protocol::https on https requests, and provides the
necessary SSL glue for that module to work.

%prep
%setup -q -n Crypt-SSLeay-%{version} 
%patch0 -p1 -b .cryptdef
#patch1 -p1 -b .dirnamefix
%patch2 -p1 -b .lib64
%patch3 -p1 -b .openssl-098
# Filter unwanted Provides:
cat << EOF > %{name}-prov
#!/bin/sh
%{__perl_provides} $* |\
  sed -e '/perl(DB)/d'
EOF

%define __perl_provides %{_builddir}/Crypt-SSLeay-%{version}/%{name}-prov
chmod +x %{__perl_provides}


%build
export CFLAGS="$RPM_OPT_FLAGS"
if pkg-config openssl ; then
  export INC="$CFLAGS `pkg-config --cflags-only-I openssl`"
  export LDFLAGS="$LDFLAGS `pkg-config --libs-only-L openssl`"
fi
%{__perl} Makefile.PL INC="$INC" LDFLAGS="$LDFLAGS" INSTALLDIRS=vendor < /dev/null
make %{?_smp_mflags}

%clean 
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type f -name '*.bs' -a -size 0 -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type d -depth -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*

%check
make test

%files
%defattr(-,root,root)
%doc CHANGES
%{perl_vendorarch}/auto/Crypt/
%{perl_vendorarch}/Crypt/
%{perl_vendorarch}/Net/
%{_mandir}/man3/*.3*

%changelog
* Mon Oct 29 2007 KONDO hideaki <kondo.hideaki@oss.ntt.co.jp>
- Created for ultramonkey3 on RHEL5

* Tue Oct 17 2006 Robin Norwood <rnorwood@redhat.com> - 0.51-11
- Filter out Provides perl(DB)
- Fix Release to include magic %{?dist}
- bug #205562

* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 0.51-9.2.2.1
- rebuild

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 0.51-9.2.2
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 0.51-9.2.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Fri Feb 03 2006 Jason Vas Dias <jvdias@redhat.com> - 0.51-9.2
- rebuild for new perl-5.8.8 / gcc / glibc

* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt for new gcc

* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt for new gcj

* Thu Nov 10 2005 Tomas Mraz <tmraz@redhat.com> 0.51-9
- rebuilt against new openssl
- added missing SSL_library_init()

* Sat Sep 24 2005 Ville Skyttä <ville.skytta at iki.fi> 0.51-8
- Own more installed dirs (#73908).
- Enable rpmbuild's internal dependency generator, drop unneeded dependencies.
- Require perl(:MODULE_COMPAT_*).
- Run tests in the %%check section.
- Fix License, Source0, URL, and Group tags.

* Wed Mar 30 2005 Warren Togami <wtogami@redhat.com> 0.51-7
- remove brp-compress

* Tue Mar  8 2005 Joe Orton <jorton@redhat.com> 0.51-6
- rebuild

* Tue Aug 31 2004 Chip Turner <cturner@redhat.com> 0.51-5
- build for FC3

* Tue Aug 31 2004 Chip Turner <cturner@redhat.com> 0.51-4
- build for RHEL3 U4

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Chip Turner <cturner@redhat.com> 0.51-1
- update to upstream 0.51

* Thu Jun 05 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Jan  7 2003 Nalin Dahyabhai <nalin@redhat.com>
- pass openssl includes to make as INC and ldflags in as LDFLAGS

* Thu Nov 21 2002 Chip Turner <cturner@redhat.com>
- patch to support /usr/lib64 before /usr/lib

* Wed Nov 20 2002 Chip Turner <cturner@redhat.com>
- rebuild

* Tue Aug  6 2002 Chip Turner <cturner@redhat.com>
- automated release bump and build

* Thu Jun 27 2002 Chip Turner <cturner@redhat.com>
- description update

* Tue Jun 25 2002 Chip Turner <cturner@redhat.com>
- move to 0.39

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Fri Dec 7 2001 root <root@redhat.com>
- Spec file was autogenerated. 
