#
# Rebuild switch:
#  --with sessiontests          enable session tests
#

Name:           perl-IO-Socket-SSL
Version:        1.01
Release:        1%{?dist}
Epoch: 2
Summary:        Perl library for transparent SSL

Group:          Development/Libraries
License:        GPL or Artistic
URL:            http://search.cpan.org/dist/IO-Socket-SSL/
Source0:        http://www.cpan.org/authors/id/B/BE/BEHROOZI/IO-Socket-SSL-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  perl(Net::SSLeay)
Requires:       perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))

%description
This module is a true drop-in replacement for IO::Socket::INET that
uses SSL to encrypt data before it is transferred to a remote server
or client. IO::Socket::SSL supports all the extra features that one
needs to write a full-featured SSL client or server application:
multiple SSL contexts, cipher selection, certificate verification, and
SSL version selection. As an extra bonus, it works perfectly with
mod_perl.


%prep
%setup -q -n IO-Socket-SSL-%{version}
for f in README SSL.pm ; do
  iconv -f iso-8859-1 -t utf-8 -o $f{.utf8,} ; mv $f{.utf8,}
done


%build
%{__perl} Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type d -depth -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*


%check
# Avoid running the session tests (spawns servers, requires 3 free ports
# and possibly manual configuration).
%{?!_with_sessiontests:mv t/sessions.t t/sessions.t.disable}
make test


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc BUGS Changes README docs/ certs/ example/ util/
%{perl_vendorlib}/IO/
%{_mandir}/man3/*.3*


%changelog
* Mon Oct 29 2007 KONDO hideaki <kondo.hideaki@oss.ntt.co.jp>
- Created for ultramonkey3 on RHEL5

* Mon Sep 18 2006 Warren Togami <wtogami@redhat.com> - 1.01-1
- 1.01 bug fixes (#206782)

* Sun Aug 13 2006 Warren Togami <wtogami@redhat.com> - 0.998-1
- 0.998 with more important fixes

* Tue Aug 01 2006 Warren Togami <wtogami@redhat.com> - 0.994-1
- 0.994 important bugfixes (#200860)

* Tue Jul 18 2006 Warren Togami <wtogami@redhat.com> - 0.991-1
- 0.991

* Wed Jul 12 2006 Warren Togami <wtogami@redhat.com> - 0.97-3
- import into FC6

* Tue Feb 28 2006 Jose Pedro Oliveira <jpo at di.uminho.pt> - 0.97-2
- Rebuild for FC5 (perl 5.8.8).
- Rebuild switch: "--with sessiontests".

* Mon Jul 18 2005 Ville Skyttä <ville.skytta at iki.fi> - 0.97-1
- 0.97.
- Convert docs to UTF-8, drop some unuseful ones.

* Fri Apr  7 2005 Michael Schwendt <mschwendt[AT]users.sf.net> - 0.96-4
- rebuilt

* Tue Oct 12 2004 Ville Skyttä <ville.skytta at iki.fi> - 0:0.96-3
- Disable session test suite even if Net::SSLeay >= 1.26 is available.

* Wed Jul  7 2004 Ville Skyttä <ville.skytta at iki.fi> - 0:0.96-0.fdr.2
- Bring up to date with current fedora.us Perl spec template.
- Include examples in docs.

* Sat May  1 2004 Ville Skyttä <ville.skytta at iki.fi> - 0:0.96-0.fdr.1
- Update to 0.96.
- Reduce directory ownership bloat.
- Require perl(:MODULE_COMPAT_*).

* Fri Oct 17 2003 Ville Skyttä <ville.skytta at iki.fi> - 0:0.95-0.fdr.1
- First build.
