##%%define _use_internal_dependency_generator 0
##%%define __find_requires %{SOURCE10}

%define realname Parse-RecDescent
%define bsname %{realname}-%{version}

%define perlbin /usr/bin/perl

Summary: Generate Recursive-Descent Parsers
Name: perl-%{realname}
Version: 1.94
Release: 1
Epoch: 2
License: GPL or Artistic
Group: Applications/CPAN
Source0: %{bsname}.tar.gz
##%Source10: filter-requires-%{realname}.sh
URL: http://search.cpan.org/search?query=%{realname}
BuildRoot: %{_tmppath}/%{name}-root/
BuildRequires: perl, perl(Text::Balanced)
Requires: perl, perl(Text::Balanced)
BuildArch: noarch

%description
Parse::RecDescent incrementally generates top-down recursive-descent text parsers from simple yacc-like grammar specifications. It provides:

    * Regular expressions or literal strings as terminals (tokens),
    * Multiple (non-contiguous) productions for any rule,
    * Repeated and optional subrules within productions,
    * Full access to Perl within actions specified as part of the grammar,
    * Simple automated error reporting during parser generation and parsing,
    * The ability to commit to, uncommit to, or reject particular productions during a parse,
    * The ability to pass data up and down the parse tree ("down" via subrule argument lists, "up" via subrule return values)
    * Incremental extension of the parsing grammar (even during a parse),
    * Precompilation of parser objects,
    * User-definable reduce-reduce conflict resolution via "scoring" of matching productions.


%prep
%setup -n %{bsname}

%build
eval `%{perlbin} -V:prefix`
eval `%{perlbin} -V:vendorlib`
eval `%{perlbin} -V:vendorarch`
%{perlbin} Makefile.PL -- CFLAGS="${RPM_OPT_FLAGS}" \
        PREFIX="${RPM_BUILD_ROOT}/$prefix" INSTALLDIRS=vendor \
        INSTALLVENDORLIB="${RPM_BUILD_ROOT}/$vendorlib" \
        INSTALLVENDORARCH="${RPM_BUILD_ROOT}/$vendorarch" \
	< /dev/null
make
make test

%install
rm -rf "$RPM_BUILD_ROOT"
make install

[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress

find $RPM_BUILD_ROOT \( -name perllocal.pod -o -name .packlist \) -exec rm -v {} \;

find $RPM_BUILD_ROOT/$prefix -type f -print |
        sed "s@^$RPM_BUILD_ROOT@@g" |
        grep -v perllocal.pod |
        grep -v "\.packlist" > filelist
if [ "$(cat filelist)X" = "X" ] ; then
    echo "ERROR: EMPTY FILE LIST"
    exit -1
fi

%clean
rm -rf "$RPM_BUILD_DIR/%{bsname}"
rm -rf "$RPM_BUILD_ROOT"

%files -f filelist
%defattr(-,root,root)
%doc README Changes tutorial

%changelog
* Mon Oct 29 2007 KONDO hideaki <kondo.hideaki@oss.ntt.co.jp>
- Created for ultramonkey3 on RHEL5

* Fri Mar 17 2006 HONDA Hirofumi <honda.hirofumi@nttcom.co.jp>
- Created for ultramonkey3
- 1.94
